/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Processor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.jackrabbit.filevault.maven.packaging.AbstractMetadataPackageMojo;
import org.apache.jackrabbit.filevault.maven.packaging.Embedded;
import org.apache.jackrabbit.filevault.maven.packaging.Filters;
import org.apache.jackrabbit.filevault.maven.packaging.MavenBasedPackageDependency;
import org.apache.jackrabbit.filevault.maven.packaging.SubPackage;
import org.apache.jackrabbit.vault.fs.api.Filter;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.filter.DefaultPathFilter;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageType;
import org.apache.jackrabbit.vault.util.Text;
import org.apache.maven.archiver.ManifestConfiguration;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generate-metadata", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class GenerateMetadataMojo
extends AbstractMetadataPackageMojo {
    private final DateFormat iso8601DateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    @Component
    private BuildContext buildContext;
    @Component(hint="default")
    private ArtifactRepositoryLayout embedArtifactLayout;
    @Parameter(property="session", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="vault.group", defaultValue="${project.groupId}", required=true)
    String group;
    @Parameter(property="vault.name", defaultValue="${project.artifactId}", required=true)
    String name;
    @Parameter(property="vault.version", defaultValue="${project.version}", required=true)
    String version;
    @Parameter
    private final Filters filters = new Filters();
    @Parameter
    private File filterSource;
    @Deprecated
    @Parameter(property="vault.failOnEmptyFilter", defaultValue="true", required=true)
    private boolean failOnEmptyFilter;
    @Parameter
    private final Properties properties = new Properties();
    @Parameter(property="vault.dependencies")
    private Collection<MavenBasedPackageDependency> dependencies = new LinkedList<MavenBasedPackageDependency>();
    @Parameter(property="vault.acHandling", alias="acHandling", required=false)
    private AccessControlHandling accessControlHandling;
    @Parameter(property="vault.requiresRoot", defaultValue="false", required=true)
    private boolean requiresRoot;
    @Parameter(property="vault.importPackage", defaultValue="-org.apache.sling.scripting.sightly.compiler.expression.nodes,-org.apache.sling.scripting.sightly.java.compiler,-org.apache.sling.scripting.sightly.render")
    private String importPackage;
    @Parameter(property="vault.embeddedTarget")
    private String embeddedTarget;
    @Parameter
    private Embedded[] embeddeds = new Embedded[0];
    @Parameter(property="vault.failOnMissingEmbed", defaultValue="false", required=true)
    private boolean failOnMissingEmbed;
    @Parameter
    private SubPackage[] subPackages = new SubPackage[0];
    @Parameter(property="vault.generatedImportPackage", defaultValue="${project.build.directory}/vault-generated-import.txt")
    private File generatedImportPackage;
    @Parameter
    private MavenArchiveConfiguration archive;
    @Parameter
    private File thumbnailImage;
    @Parameter(property="vault.packageType")
    protected PackageType packageType;
    @Parameter(property="vault.allowIndexDefinitions", defaultValue="false", required=true)
    boolean allowIndexDefinitions;
    private static final Pattern FILENAME_PATTERN_WITHOUT_VERSION_IN_GROUP1 = Pattern.compile("((?!-\\d).*-)\\d.*");

    public GenerateMetadataMojo() {
        this.iso8601DateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void setPackageType(String type) throws MojoFailureException {
        try {
            this.packageType = PackageType.valueOf((String)type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException("Invalid package type specified: " + type + ".\nMust be empty or one of 'application', 'content', 'container', 'mixed'");
        }
    }

    public void setAccessControlHandling(String type) throws MojoFailureException {
        try {
            this.accessControlHandling = AccessControlHandling.valueOf((String)type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException("Invalid accessControlHandling specified: " + type + ".\nMust be empty or one of '" + StringUtils.join((Object[])AccessControlHandling.values(), (String)"','") + "'.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.buildContext.isIncremental()) {
            this.getLog().debug((CharSequence)"Incremental build");
            if (this.filterSource == null) {
                this.getLog().debug((CharSequence)"No file change would be relevant therefore cancelling build");
                return;
            }
            if (!this.buildContext.hasDelta(this.filterSource)) {
                this.getLog().debug((CharSequence)("'" + this.filterSource + "' unchanged therefore cancelling build"));
                return;
            }
            this.getLog().debug((CharSequence)("Detecting a change on '" + this.filterSource + "' therefore not cancelling build"));
        }
        if (!this.failOnEmptyFilter) {
            this.getLog().warn((CharSequence)"The parameter 'failOnEmptyFilter' is no longer supported and ignored. Every package must have a non-empty filter!");
        }
        File vaultDir = this.getGeneratedVaultDir();
        vaultDir.mkdirs();
        GenerateMetadataMojo.getArtifactWorkDirectoryLookup(this.getPluginContext()).put(this.getModuleArtifactKey(this.project.getArtifact()), this.workDirectory);
        try {
            File metaInfDirectory = this.getMetaInfVaultSourceDirectory();
            String sourceFilters = this.computeFilters(metaInfDirectory);
            this.computeImportPackage();
            if (this.packageType == null) {
                this.packageType = this.computePackageType();
            }
            Map<String, File> embeddedFiles = this.getEmbeddeds();
            embeddedFiles.putAll(this.getSubPackages());
            this.setEmbeddedFilesMap(embeddedFiles);
            String dependenciesString = this.computeDependencies();
            String dependenciesLocations = this.computeDependenciesLocations();
            Properties vaultProperties = this.computeProperties(dependenciesString, dependenciesLocations);
            try (FileOutputStream fos = new FileOutputStream(new File(vaultDir, "properties.xml"));){
                vaultProperties.storeToXML(fos, this.project.getName());
            }
            this.writeFilters(sourceFilters);
            this.copyFile("/vault/config.xml", new File(vaultDir, "config.xml"));
            this.copyFile("/vault/settings.xml", new File(vaultDir, "settings.xml"));
            if (this.thumbnailImage != null && this.thumbnailImage.exists()) {
                File vaultDefinitionFolder = new File(vaultDir, "definition");
                if (!vaultDefinitionFolder.exists()) {
                    vaultDefinitionFolder.mkdir();
                }
                this.copyFile("/vault/definition/.content.xml", new File(vaultDefinitionFolder, ".content.xml"));
                FileUtils.copyFile((File)this.thumbnailImage, (File)new File(vaultDefinitionFolder, "thumbnail.png"));
            }
            this.writeManifest(this.getGeneratedManifestFile(), dependenciesString, dependenciesLocations, vaultProperties);
        }
        catch (IOException | ConfigurationException | DependencyResolutionRequiredException | ManifestException e) {
            throw new MojoExecutionException(e.toString(), (Exception)e);
        }
        this.buildContext.refresh(vaultDir);
    }

    void writeManifest(File file, String dependenciesString, String dependenciesLocations, Properties vaultProperties) throws ManifestException, DependencyResolutionRequiredException, IOException, FileNotFoundException {
        MavenArchiver mavenArchiver = new MavenArchiver();
        mavenArchiver.setCreatedBy("Apache Jackrabbit FileVault - Package Maven Plugin", "org.apache.jackrabbit", "filevault-package-maven-plugin");
        Manifest manifest = mavenArchiver.getManifest(this.session, this.project, this.getMavenArchiveConfiguration(vaultProperties, dependenciesString, dependenciesLocations));
        try (FileOutputStream out = new FileOutputStream(file);){
            manifest.write(out);
        }
    }

    private String computeFilters(File vaultMetaDir) throws IOException, MojoExecutionException {
        File metaFilterFile;
        File filterFile = this.getGeneratedFilterFile();
        if (filterFile.exists() && filterFile.lastModified() != 0L) {
            if (!this.filters.getFilterSets().isEmpty()) {
                this.getLog().error((CharSequence)"Refuse to merge inline filters and non-sourced filter.xml. If this is intended, specify the filter.xml via the 'filterSource' property.");
                throw new MojoExecutionException("Conflicting filters, look at above log for details.");
            }
            try {
                this.filters.load(filterFile);
            }
            catch (ConfigurationException e) {
                throw new IOException("Error loading filter file '" + filterFile + "'", e);
            }
            this.getLog().warn((CharSequence)"The project is using a filter.xml provided via the resource plugin.");
            this.getLog().warn((CharSequence)"This is deprecated and might no longer be supported in future versions.");
            this.getLog().warn((CharSequence)"Use the 'filterSource' property to specify the filter or use inline filters.");
            return null;
        }
        if (filterFile.exists() && filterFile.lastModified() == 0L) {
            try {
                Files.delete(filterFile.toPath());
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Unable to delete previously generated filter.xml. re-run the goals with a clean setup.");
                throw new MojoExecutionException("Unable to delete file.", (Exception)e);
            }
        }
        if (vaultMetaDir != null && (metaFilterFile = new File(vaultMetaDir, "filter.xml")).exists()) {
            if (this.filterSource != null && !this.filterSource.equals(metaFilterFile)) {
                this.getLog().error((CharSequence)"Project contains filter.xml in META-INF/vault but also specifies a filter source.");
                throw new MojoExecutionException("Conflicting filters, look at above log for details.");
            }
            this.filterSource = metaFilterFile;
        }
        DefaultWorkspaceFilter sourceFilters = new DefaultWorkspaceFilter();
        if (this.filterSource != null && this.filterSource.exists()) {
            this.getLog().info((CharSequence)("Loading filter from " + this.filterSource.getPath()));
            try {
                sourceFilters.load(this.filterSource);
            }
            catch (ConfigurationException e) {
                throw new IOException(e);
            }
            if (!this.filters.getFilterSets().isEmpty()) {
                this.getLog().info((CharSequence)"Merging inline filters.");
                this.mergeFilters(sourceFilters, (WorkspaceFilter)this.filters);
            }
            try (InputStream serializedFilters = sourceFilters.getSource();){
                this.filters.load(serializedFilters);
            }
            catch (ConfigurationException e) {
                throw new IllegalStateException("cloning filters failed.", e);
            }
            sourceFilters = new DefaultWorkspaceFilter();
            try {
                sourceFilters.load(this.filterSource);
            }
            catch (ConfigurationException e) {
                throw new IOException("Error loading filter file '" + this.filterSource + "'", e);
            }
        }
        if (this.filters.getFilterSets().isEmpty() && this.prefix.length() > 0) {
            this.filters.add(new PathFilterSet(this.prefix));
        }
        return sourceFilters.getSourceAsString();
    }

    private void mergeFilters(DefaultWorkspaceFilter dst, WorkspaceFilter src) {
        for (PathFilterSet fs : src.getFilterSets()) {
            for (PathFilterSet mfs : dst.getFilterSets()) {
                if (!mfs.getRoot().equals(fs.getRoot())) continue;
                throw new IllegalArgumentException("Merging of equal filter roots not allowed for: " + fs.getRoot());
            }
            dst.add(fs);
        }
    }

    private void writeFilters(String sourceFilters) throws IOException, MojoExecutionException {
        if (this.filters.getFilterSets().isEmpty()) {
            throw new MojoExecutionException("No workspace filter defined!");
        }
        File filterFile = this.getGeneratedFilterFile();
        if (this.filterSource != null && this.filters.getSourceAsString().equals(sourceFilters)) {
            FileUtils.copyFile((File)this.filterSource, (File)filterFile);
        } else {
            this.getLog().info((CharSequence)"Generating filter.xml from plugin configuration");
            FileUtils.fileWrite((String)filterFile.getAbsolutePath(), (String)this.filters.getSourceAsString());
        }
        if (!filterFile.setLastModified(0L)) {
            this.getLog().warn((CharSequence)"Unable to set last modified of filters file. make sure to clean the project before next run.");
        }
    }

    private void computeImportPackage() throws IOException {
        String importPackageStr;
        TreeMap importParams = new TreeMap();
        if (this.generatedImportPackage.exists() && (importPackageStr = FileUtils.fileRead((File)this.generatedImportPackage)).length() > 0) {
            importParams.putAll(new Parameters(importPackageStr));
        }
        if (this.importPackage != null) {
            this.getLog().debug((CharSequence)("merging analyzer-packages with:\n" + this.importPackage + "\n"));
            for (Map.Entry entry : new Parameters(this.importPackage).entrySet()) {
                boolean delete = false;
                String pkg = (String)entry.getKey();
                if ("-*".equals(pkg)) {
                    importParams.clear();
                    continue;
                }
                if (pkg.charAt(0) == '-') {
                    pkg = pkg.substring(1);
                    delete = true;
                }
                if (pkg.endsWith("*")) {
                    String pkgDot = pkg.substring(0, pkg.length() - 1);
                    if (!pkgDot.endsWith(".")) {
                        pkg = pkgDot;
                        pkgDot = pkg + ".";
                    }
                    Iterator iter = importParams.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry e = iter.next();
                        String pkgName = (String)e.getKey();
                        if (!pkgName.equals(pkg) && !pkgName.startsWith(pkgDot)) continue;
                        if (delete) {
                            iter.remove();
                            continue;
                        }
                        e.setValue(entry.getValue());
                    }
                    continue;
                }
                if (delete) {
                    importParams.remove(pkg);
                    continue;
                }
                importParams.put(pkg, entry.getValue());
            }
        }
        this.importPackage = Processor.printClauses(importParams);
        if (!this.importPackage.isEmpty()) {
            this.getLog().info((CharSequence)"Merged detected packages from analyzer with 'importPackage':");
            for (Map.Entry e : importParams.entrySet()) {
                StringBuilder report = new StringBuilder();
                report.append("  ").append((String)e.getKey());
                try {
                    Processor.printClause((Map)((Map)e.getValue()), (StringBuilder)report);
                }
                catch (IOException e1) {
                    throw new IllegalStateException("Internal error while generating report", e1);
                }
                this.getLog().info((CharSequence)report);
            }
            this.getLog().info((CharSequence)"");
        }
    }

    private String computeDependencies() throws IOException {
        String dependenciesString = null;
        if (!this.dependencies.isEmpty()) {
            MavenBasedPackageDependency.resolve(this.project, this.getLog(), this.dependencies);
            Dependency[] vaultDependencies = (Dependency[])this.dependencies.stream().map(MavenBasedPackageDependency::getPackageDependency).toArray(Dependency[]::new);
            dependenciesString = Dependency.toString((Dependency[])vaultDependencies);
        }
        return dependenciesString;
    }

    private String computeDependenciesLocations() throws IOException {
        String dependenciesLocations = null;
        if (!this.dependencies.isEmpty()) {
            MavenBasedPackageDependency.resolve(this.project, this.getLog(), this.dependencies);
            dependenciesLocations = this.dependencies.stream().map(a -> a.getInfo().getId().toString() + "=" + a.getLocation()).collect(Collectors.joining(","));
        }
        return dependenciesLocations;
    }

    static final String escapeManifestValue(String value) {
        return value.replaceAll("\n", "\n ").replaceAll("\r(?!\n)", "\r ");
    }

    private MavenArchiveConfiguration getMavenArchiveConfiguration(Properties vaultProperties, String dependenciesString, String dependenciesLocations) throws IOException {
        if (this.archive == null) {
            this.archive = new MavenArchiveConfiguration();
            this.archive.setManifest(new ManifestConfiguration());
            this.archive.setAddMavenDescriptor(true);
            this.archive.setCompress(true);
            this.archive.setIndex(false);
            this.archive.getManifest().setAddDefaultSpecificationEntries(false);
            this.archive.getManifest().setAddDefaultImplementationEntries(true);
            PackageId id = new PackageId(this.group, this.name, this.version);
            this.archive.addManifestEntry("Content-Package-Type", GenerateMetadataMojo.escapeManifestValue(this.packageType.name().toLowerCase()));
            this.archive.addManifestEntry("Content-Package-Id", GenerateMetadataMojo.escapeManifestValue(id.toString()));
            this.archive.addManifestEntry("Content-Package-Description", GenerateMetadataMojo.escapeManifestValue(vaultProperties.getProperty("description", "")));
            if (dependenciesString != null && dependenciesString.length() > 0) {
                this.archive.addManifestEntry("Content-Package-Dependencies", GenerateMetadataMojo.escapeManifestValue(dependenciesString));
                if (dependenciesLocations != null && dependenciesLocations.length() > 0) {
                    this.archive.addManifestEntry("Content-Package-Dependencies-Locations", GenerateMetadataMojo.escapeManifestValue(dependenciesLocations));
                }
            }
            TreeSet<String> rts = new TreeSet<String>();
            for (PathFilterSet p : this.filters.getFilterSets()) {
                rts.add(p.getRoot());
            }
            Object[] roots = rts.toArray(new String[rts.size()]);
            Arrays.sort(roots);
            this.archive.addManifestEntry("Content-Package-Roots", GenerateMetadataMojo.escapeManifestValue(StringUtils.join((Object[])roots, (String)",")));
            if (StringUtils.isNotEmpty((String)this.importPackage)) {
                this.archive.addManifestEntry("Import-Package", GenerateMetadataMojo.escapeManifestValue(StringUtils.deleteWhitespace((String)this.importPackage)));
            }
        }
        return this.archive;
    }

    private Properties computeProperties(String dependenciesString, String dependenciesLocations) {
        MavenArchiver archiver;
        Date createdDate;
        Properties props = new Properties();
        String description = this.project.getDescription();
        if (description == null && (description = this.project.getName()) == null) {
            description = this.project.getArtifactId();
        }
        props.put("description", description);
        for (Object o : this.properties.keySet()) {
            if (this.properties.get(o) != null) continue;
            this.properties.put(o, "");
        }
        props.putAll((Map<?, ?>)this.properties);
        props.put("group", this.group);
        props.put("name", this.name);
        props.put("version", this.version);
        props.put("groupId", this.project.getGroupId());
        props.put("artifactId", this.project.getArtifactId());
        if (dependenciesString != null && dependenciesString.length() > 0) {
            props.put("dependencies", dependenciesString);
            if (dependenciesLocations != null && dependenciesLocations.length() > 0) {
                props.put("dependencies-locations", dependenciesLocations);
            }
        }
        if ((createdDate = (archiver = new MavenArchiver()).parseOutputTimestamp(this.outputTimestamp)) == null) {
            createdDate = new Date();
        }
        props.put("created", this.iso8601DateFormat.format(createdDate));
        props.put("requiresRoot", String.valueOf(this.requiresRoot));
        props.put("allowIndexDefinitions", String.valueOf(this.allowIndexDefinitions));
        props.put("packageType", this.packageType.name().toLowerCase());
        if (this.accessControlHandling != null) {
            props.put("acHandling", this.accessControlHandling.name().toLowerCase());
        }
        return props;
    }

    private Map<String, File> getEmbeddeds() throws MojoFailureException, ConfigurationException {
        HashMap<String, File> fileMap = new HashMap<String, File>();
        for (Embedded emb : this.embeddeds) {
            String targetPath;
            Collection<Artifact> artifacts = emb.getMatchingArtifacts(this.project);
            if (artifacts.isEmpty()) {
                if (this.failOnMissingEmbed) {
                    throw new MojoFailureException("Embedded artifact specified " + emb + ", but no matching dependency artifact found. Add the missing dependency or fix the embed definition.");
                }
                this.getLog().warn((CharSequence)("No matching artifacts for " + emb));
                continue;
            }
            if (emb.getDestFileName() != null && artifacts.size() > 1) {
                this.getLog().warn((CharSequence)("destFileName defined but several artifacts match for " + emb));
            }
            if ((targetPath = emb.getTarget()) == null && (targetPath = this.embeddedTarget) == null) {
                String loc = this.prefix.length() == 0 ? "/apps/" : this.prefix;
                targetPath = loc + "bundles/install/";
                this.getLog().info((CharSequence)("No target path set on " + emb + "; assuming default " + targetPath));
            }
            targetPath = this.makeAbsolutePath(targetPath);
            targetPath = "jcr_root/" + targetPath;
            if (!(targetPath = FileUtils.normalize((String)targetPath)).endsWith("/")) {
                targetPath = targetPath + "/";
            }
            this.getLog().info((CharSequence)("Embedding --- " + emb + " ---"));
            for (Artifact artifact : artifacts) {
                File source = artifact.getFile();
                String destFileName = emb.getDestFileName();
                if (destFileName == null) {
                    if (!source.isDirectory()) {
                        destFileName = source.getName();
                    } else {
                        String layoutBaseName = Text.getName((String)this.embedArtifactLayout.pathOf(artifact));
                        MavenProject peerModule = this.findModuleForArtifact(artifact);
                        if (peerModule != null) {
                            Artifact attached = peerModule.getArtifact();
                            String defaultFinalName = attached.getArtifactId() + "-" + attached.getVersion();
                            String peerFinalName = peerModule.getBuild().getFinalName();
                            if (peerFinalName != null) {
                                destFileName = peerFinalName + layoutBaseName.substring(defaultFinalName.length());
                            }
                        }
                        if (destFileName == null) {
                            destFileName = layoutBaseName;
                        }
                    }
                }
                String targetPathName = targetPath + destFileName;
                String targetNodePathName = targetPathName.substring("jcr_root".length());
                this.getLog().info((CharSequence)String.format("Embedding %s (from %s) -> %s", artifact.getId(), source.getAbsolutePath(), targetPathName));
                fileMap.put(targetPathName, source);
                if (!emb.isFilter()) continue;
                this.addEmbeddedFileToFilter(targetNodePathName, emb.isAllVersionsFilter());
            }
        }
        return fileMap;
    }

    private Map<String, File> getSubPackages() throws MojoFailureException, ConfigurationException {
        String propsRelPath = "META-INF/vault/properties.xml";
        HashMap<String, File> fileMap = new HashMap<String, File>();
        for (SubPackage pack : this.subPackages) {
            Collection<Artifact> artifacts = pack.getMatchingArtifacts(this.project);
            if (artifacts.isEmpty()) {
                this.getLog().warn((CharSequence)("No matching artifacts for sub package " + pack));
                continue;
            }
            this.getLog().info((CharSequence)("Embedding subpackage --- " + pack + " ---"));
            for (Artifact artifact : artifacts) {
                File source;
                Properties props;
                block48: {
                    Throwable throwable;
                    Object otherProject;
                    props = new Properties();
                    source = artifact.getFile();
                    if (source.isDirectory()) {
                        File propsXml;
                        PluginDescriptor pluginDescriptor;
                        File otherWorkDirectory = null;
                        otherProject = this.findModuleForArtifact(artifact);
                        if (otherProject != null && (pluginDescriptor = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor")) != null) {
                            Map otherContext = this.session.getPluginContext(pluginDescriptor, (MavenProject)otherProject);
                            otherWorkDirectory = GenerateMetadataMojo.getArtifactWorkDirectoryLookup(otherContext).get(this.getModuleArtifactKey(artifact));
                        }
                        if (otherWorkDirectory == null) {
                            otherWorkDirectory = source;
                        }
                        if (!(propsXml = new File(otherWorkDirectory, "META-INF/vault/properties.xml")).exists()) {
                            propsXml = new File(otherWorkDirectory.getParent(), this.workDirectory.getName() + "/" + "META-INF/vault/properties.xml");
                        }
                        try {
                            throwable = null;
                            try (FileInputStream input = new FileInputStream(propsXml);){
                                props.loadFromXML(input);
                                break block48;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                        }
                        catch (IOException e) {
                            throw new MojoFailureException("Could not read META-INF/vault/properties.xml from directory '" + otherWorkDirectory + "' to extract metadata: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    try {
                        ZipFile zip = new ZipFile(source);
                        otherProject = null;
                        try {
                            ZipEntry e = zip.getEntry("META-INF/vault/properties.xml");
                            if (e == null) {
                                throw new IOException("Package does not contain 'META-INF/vault/properties.xml'");
                            }
                            throwable = null;
                            try (InputStream in = zip.getInputStream(e);){
                                props.loadFromXML(in);
                            }
                            catch (Throwable throwable3) {
                                throwable = throwable3;
                                throw throwable3;
                            }
                        }
                        catch (Throwable e) {
                            otherProject = e;
                            throw e;
                        }
                        finally {
                            if (zip != null) {
                                if (otherProject != null) {
                                    try {
                                        zip.close();
                                    }
                                    catch (Throwable e) {
                                        ((Throwable)otherProject).addSuppressed(e);
                                    }
                                } else {
                                    zip.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new MojoFailureException("Could not open subpackage '" + source + "' to extract metadata: " + e.getMessage(), (Throwable)e);
                    }
                }
                PackageId pid = new PackageId(props.getProperty("group"), props.getProperty("name"), props.getProperty("version"));
                String targetNodePathName = pid.getInstallationPath() + ".zip";
                String targetPathName = "jcr_root" + targetNodePathName;
                this.getLog().info((CharSequence)String.format("Embedding %s (from %s) -> %s", artifact.getId(), source.getAbsolutePath(), targetPathName));
                fileMap.put(targetPathName, source);
                if (!pack.isFilter()) continue;
                this.addEmbeddedFileToFilter(targetNodePathName, pack.isAllVersionsFilter());
            }
        }
        return fileMap;
    }

    static Map<String, File> getArtifactWorkDirectoryLookup(Map pluginContext) {
        String workDirectoryLookupKey = "workDirectoryLookup";
        if (!pluginContext.containsKey("workDirectoryLookup")) {
            pluginContext.put("workDirectoryLookup", new ConcurrentHashMap());
        }
        return (Map)pluginContext.get("workDirectoryLookup");
    }

    MavenProject findModuleForArtifact(Artifact artifact) {
        for (MavenProject otherProject : this.session.getProjects()) {
            if (otherProject == this.project) continue;
            Artifact otherArtifact = otherProject.getArtifact();
            if (!this.getModuleArtifactKey(artifact).equals(this.getModuleArtifactKey(otherArtifact))) continue;
            return otherProject;
        }
        return null;
    }

    String getModuleArtifactKey(Artifact artifact) {
        return this.embedArtifactLayout.pathOf(artifact);
    }

    private void addEmbeddedFileToFilter(String embeddedFile, boolean includeAllVersions) throws ConfigurationException {
        this.filters.add(GenerateMetadataMojo.getPathFilterSetForEmbeddedFile(embeddedFile, includeAllVersions));
    }

    static PathFilterSet getPathFilterSetForEmbeddedFile(String embeddedFile, boolean includeAllVersions) throws ConfigurationException {
        PathFilterSet pathFilterSet;
        if (includeAllVersions) {
            String filename = FilenameUtils.getName((String)embeddedFile);
            String rootName = StringUtils.chomp((String)embeddedFile, (String)"/");
            String extension = FilenameUtils.getExtension((String)filename);
            Matcher matcher = FILENAME_PATTERN_WITHOUT_VERSION_IN_GROUP1.matcher(filename);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Could not figure out version part in filename '" + filename + "'. For this artifact you cannot use 'isAllVersionsFilter=true'");
            }
            String pattern = Pattern.quote(matcher.group(1)) + ".*\\." + extension + "(/.*)?";
            if (!filename.matches(pattern)) {
                throw new IllegalArgumentException("Detected pattern '" + pattern + "' does not even match given filename '" + filename + "'. For this artifact you cannot use 'isAllVersionsFilter=true'");
            }
            pathFilterSet = new PathFilterSet(rootName);
            pathFilterSet.addInclude((Filter)new DefaultPathFilter(pattern));
        } else {
            pathFilterSet = new PathFilterSet(embeddedFile);
        }
        return pathFilterSet;
    }

    private String makeAbsolutePath(String relPath) {
        String absPath;
        if (!relPath.startsWith("/")) {
            absPath = (this.prefix.length() == 0 ? "/" : this.prefix) + relPath;
            this.getLog().info((CharSequence)("Relative path resolved to " + absPath));
        } else {
            absPath = relPath;
        }
        return absPath;
    }

    private PackageType computePackageType() {
        boolean hasApps = false;
        boolean hasOther = false;
        for (PathFilterSet p : this.filters.getFilterSets()) {
            if ("cleanup".equals(p.getType())) continue;
            String root = p.getRoot();
            if ("/apps".equals(root) || root.startsWith("/apps/") || "/libs".equals(root) || root.startsWith("/libs/")) {
                hasApps = true;
                this.getLog().debug((CharSequence)("Detected /apps or /libs filter entry: " + p));
                continue;
            }
            hasOther = true;
            this.getLog().debug((CharSequence)("Detected filter entry outside /apps and /libs: " + p));
        }
        this.getLog().debug((CharSequence)("Detected " + this.embeddeds.length + " bundle(s) and " + this.subPackages.length + " sub package(s)."));
        PackageType packageType = this.embeddeds.length == 0 && this.subPackages.length == 0 ? (hasApps && !hasOther ? PackageType.APPLICATION : (hasOther && !hasApps ? PackageType.CONTENT : PackageType.MIXED)) : (!hasApps && !hasOther ? PackageType.CONTAINER : PackageType.MIXED);
        this.getLog().info((CharSequence)("Auto-detected package type: " + packageType.toString().toLowerCase()));
        return packageType;
    }

    private void copyFile(String source, File target) throws IOException {
        block26: {
            if (target.exists()) {
                return;
            }
            target.getParentFile().mkdirs();
            try (InputStream ins = ((Object)((Object)this)).getClass().getResourceAsStream(source);
                 FileOutputStream out = new FileOutputStream(target);){
                if (ins != null) {
                    IOUtil.copy((InputStream)ins, (OutputStream)out);
                    break block26;
                }
                throw new IllegalArgumentException("Could not find resource " + source);
            }
        }
    }
}

