/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.filevault.maven.packaging.AbstractValidateMojo;
import org.apache.jackrabbit.filevault.maven.packaging.validator.impl.context.ArchiveValidationContextImpl;
import org.apache.jackrabbit.filevault.maven.packaging.validator.impl.context.SubPackageValidationContext;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.ZipArchive;
import org.apache.jackrabbit.vault.fs.io.ZipStreamArchive;
import org.apache.jackrabbit.vault.validation.ValidationExecutor;
import org.apache.jackrabbit.vault.validation.ValidationViolation;
import org.apache.jackrabbit.vault.validation.spi.ValidationContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.xml.sax.SAXException;

@Mojo(name="validate-package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=false, threadSafe=true)
public class ValidatePackageMojo
extends AbstractValidateMojo {
    @Parameter(property="vault.packageToValidate", defaultValue="${project.artifact.file}", required=true)
    private File packageFile;
    @Parameter(required=true, defaultValue="false")
    private boolean enforceRecursiveSubpackageValidation;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        try {
            this.validatePackage(this.packageFile);
            this.validationHelper.failBuildInCaseOfViolations(this.failOnValidationWarnings);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new MojoExecutionException("Could not validate package '" + this.packageFile + "': " + e.getMessage(), e);
        }
    }

    private void validatePackage(File file) throws IOException, ParserConfigurationException, SAXException, MojoExecutionException {
        this.getLog().info((CharSequence)("Start validating package '" + file + "'..."));
        try (ZipArchive archive = new ZipArchive(file);){
            archive.open(true);
            ArchiveValidationContextImpl context = new ArchiveValidationContextImpl((Archive)archive, file.toPath(), this.resolver, this.getLog());
            ValidationExecutor executor = this.validationExecutorFactory.createValidationExecutor((ValidationContext)context, false, this.enforceRecursiveSubpackageValidation, this.validatorsSettings);
            if (executor == null) {
                throw new MojoExecutionException("No registered validators found!");
            }
            this.validationHelper.printUsedValidators(this.getLog(), executor, context, true);
            this.validateArchive((Archive)archive, file.toPath(), context, executor);
            this.getLog().debug((CharSequence)("End validating package '" + file + "'."));
        }
    }

    private void validateArchive(Archive archive, Path path, ArchiveValidationContextImpl context, ValidationExecutor executor) throws IOException, SAXException, ParserConfigurationException {
        this.validateEntry(archive, archive.getRoot(), Paths.get("", new String[0]), path, context, executor);
        this.validationHelper.printMessages(executor.done(), this.getLog(), this.buildContext, this.packageFile.toPath());
    }

    private void validateEntry(Archive archive, Archive.Entry entry, Path entryPath, Path packagePath, ArchiveValidationContextImpl context, ValidationExecutor executor) throws IOException, SAXException, ParserConfigurationException {
        for (Archive.Entry childEntry : entry.getChildren()) {
            if (childEntry.isDirectory()) {
                this.validateEntry(archive, childEntry, entryPath.resolve(childEntry.getName()), packagePath, context, executor);
                continue;
            }
            InputStream input = archive.openInputStream(childEntry);
            Throwable throwable = null;
            try {
                this.validateInputStream(input, entryPath.resolve(childEntry.getName()), packagePath, context, executor);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (input == null) continue;
                if (throwable != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                input.close();
            }
        }
    }

    private void validateInputStream(InputStream inputStream, Path entryPath, Path packagePath, ArchiveValidationContextImpl context, ValidationExecutor executor) throws IOException, SAXException, ParserConfigurationException {
        LinkedList<ValidationViolation> messages = new LinkedList<ValidationViolation>();
        if (entryPath.startsWith("META-INF")) {
            messages.addAll(executor.validateMetaInf(inputStream, Paths.get("META-INF", new String[0]).relativize(entryPath), packagePath.resolve("META-INF")));
        } else if (entryPath.startsWith("jcr_root")) {
            Path relativeJcrPath = Paths.get("jcr_root", new String[0]).relativize(entryPath);
            messages.addAll(executor.validateJcrRoot(inputStream, relativeJcrPath, packagePath.resolve("jcr_root")));
            if (entryPath.getFileName().toString().endsWith(".zip")) {
                Path subPackagePath = context.getPackageRootPath().resolve(entryPath);
                this.getLog().info((CharSequence)("Start validating sub package '" + subPackagePath + "'..."));
                ZipStreamArchive subArchive = new ZipStreamArchive(inputStream);
                subArchive.open(true);
                SubPackageValidationContext subPackageValidationContext = new SubPackageValidationContext(context, (Archive)subArchive, subPackagePath, this.resolver, this.getLog());
                ValidationExecutor subPackageValidationExecutor = this.validationExecutorFactory.createValidationExecutor((ValidationContext)subPackageValidationContext, true, this.enforceRecursiveSubpackageValidation, this.validatorsSettings);
                if (subPackageValidationExecutor != null) {
                    this.validationHelper.printUsedValidators(this.getLog(), executor, subPackageValidationContext, false);
                    this.validateArchive((Archive)subArchive, subPackagePath, subPackageValidationContext, subPackageValidationExecutor);
                } else {
                    this.getLog().debug((CharSequence)"Skip validating sub package as no validator is interested in it.");
                }
                this.getLog().info((CharSequence)"End validating sub package.");
            }
        } else {
            messages.add(new ValidationViolation(ValidationMessageSeverity.WARN, "Found unexpected file outside of jcr_root and META-INF", entryPath, packagePath, null, 0, 0, null));
        }
        this.validationHelper.printMessages(messages, this.getLog(), this.buildContext, this.packageFile.toPath());
    }
}

