/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.validator.impl.context;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import org.apache.jackrabbit.filevault.maven.packaging.validator.impl.context.DependencyResolver;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.packaging.PackageInfo;
import org.apache.jackrabbit.vault.packaging.PackageProperties;
import org.apache.jackrabbit.vault.validation.spi.ValidationContext;
import org.apache.maven.plugin.logging.Log;

public class ArchiveValidationContextImpl
implements ValidationContext {
    private final WorkspaceFilter filter;
    private final PackageProperties properties;
    private final Path archivePath;
    private final Collection<PackageInfo> resolvedDependencies;

    public ArchiveValidationContextImpl(Archive archive, Path archivePath, DependencyResolver resolver, Log log) throws IOException {
        this.archivePath = archivePath;
        this.properties = archive.getMetaInf().getPackageProperties();
        this.filter = archive.getMetaInf().getFilter();
        if (this.filter == null) {
            throw new IllegalStateException("Archive '" + archivePath + "' does not contain a filter.xml.");
        }
        this.resolvedDependencies = resolver.resolve(this.getProperties().getDependencies(), this.getProperties().getDependenciesLocations(), log);
    }

    public PackageProperties getProperties() {
        return this.properties;
    }

    public WorkspaceFilter getFilter() {
        return this.filter;
    }

    public ValidationContext getContainerValidationContext() {
        return null;
    }

    public Path getPackageRootPath() {
        return this.archivePath;
    }

    public Collection<PackageInfo> getDependenciesPackageInfo() {
        return this.resolvedDependencies;
    }
}

