/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageInfo;
import org.apache.jackrabbit.vault.packaging.VersionRange;
import org.apache.jackrabbit.vault.packaging.impl.DefaultPackageInfo;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenBasedPackageDependency {
    private String group;
    private String groupId;
    private String name;
    private String artifactId;
    private String classifier;
    private String version;
    private PackageInfo info;
    private Dependency dependency;
    private boolean isResolved;
    private String mavenVersion;
    private static final String MAVEN_REPOSITORY_SCHEME = "maven";

    static MavenBasedPackageDependency fromGroupNameAndVersion(String group, String name, String version) {
        MavenBasedPackageDependency dependency = new MavenBasedPackageDependency();
        dependency.group = group;
        dependency.name = name;
        dependency.version = version;
        return dependency;
    }

    public static void resolve(MavenProject project, Log log, Collection<MavenBasedPackageDependency> dependencies) throws IOException {
        for (MavenBasedPackageDependency dependency : dependencies) {
            dependency.resolve(project, log);
        }
    }

    private void resolve(MavenProject project, Log log) throws IOException {
        if (this.isResolved) {
            return;
        }
        this.isResolved = true;
        if (!StringUtils.isEmpty((String)this.group) || !StringUtils.isEmpty((String)this.name)) {
            log.warn((CharSequence)("Using package id in dependencies is deprecated. Use Maven coordinates (given via 'groupId' and 'artifactId') instead of '" + this.group + ":" + this.name + "'!"));
        }
        if (!StringUtils.isEmpty((String)this.groupId) && !StringUtils.isEmpty((String)this.artifactId)) {
            boolean foundMavenDependency = false;
            if (project != null) {
                for (Artifact a : project.getDependencyArtifacts()) {
                    if (!a.getArtifactId().equals(this.artifactId) || !a.getGroupId().equals(this.groupId) || !StringUtils.equals((String)a.getClassifier(), (String)this.classifier)) continue;
                    try {
                        this.readMetaData(a.getFile(), log);
                        this.mavenVersion = a.getVersion();
                        foundMavenDependency = true;
                        break;
                    }
                    catch (IOException e) {
                        log.warn((CharSequence)("Could not resolve dependency '" + this + "'"), (Throwable)e);
                        return;
                    }
                }
                if (!foundMavenDependency) {
                    throw new IOException("Specified dependency '" + this + "' was not found among the Maven dependencies of this project!");
                }
            } else {
                log.warn((CharSequence)("Dependency '" + this + "' was given via Maven coordinates but there is no Maven project connected which allows to resolve those."));
                return;
            }
        }
        if (StringUtils.isEmpty((String)this.group) || StringUtils.isEmpty((String)this.name)) {
            throw new IOException("Specified dependency " + this + " is not qualified (group and name or groupId and artifactId is missing)!");
        }
        VersionRange range = StringUtils.isEmpty((String)this.version) ? VersionRange.INFINITE : VersionRange.fromString((String)this.version);
        this.dependency = new Dependency(this.group, this.name, range);
    }

    public void readMetaData(File file, Log log) throws IOException {
        PackageInfo info;
        if (file.isDirectory()) {
            log.info((CharSequence)("Trying to extract package info from folder '" + file + "' as no package is availabe for the given dependency " + this));
            info = DefaultPackageInfo.read((File)file);
            if (info == null) {
                File fallbackDirectory = new File(file.getParent(), "vault-work");
                log.info((CharSequence)("Trying to extract package info from fallback folder '" + fallbackDirectory + "' as no package is availabe for the given dependency " + this));
                info = DefaultPackageInfo.read((File)fallbackDirectory);
            }
        } else {
            info = DefaultPackageInfo.read((File)file);
        }
        if (info != null) {
            PackageId id = info.getId();
            this.group = id.getGroup();
            this.name = id.getName();
            if (StringUtils.isEmpty((String)this.version)) {
                log.debug((CharSequence)("No explicit version range given for dependency '" + this + "'. Using default version range derived from the Maven dependency"));
                this.version = new VersionRange(id.getVersion(), true, null, false).toString();
            }
        } else {
            throw new IOException("Dependency at '" + file + "' does not contain mandatory metadata for a content-package");
        }
        this.info = info;
    }

    @Nullable
    public PackageInfo getInfo() {
        return this.info;
    }

    @Nullable
    public Dependency getPackageDependency() {
        return this.dependency;
    }

    @Nullable
    public URI getLocation() {
        if (this.groupId != null && this.artifactId != null && this.mavenVersion != null) {
            return MavenBasedPackageDependency.mavenCoordinatesToUri(this.groupId, this.artifactId, this.mavenVersion, this.classifier);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Dependency{");
        sb.append("group='").append(this.group).append('\'');
        sb.append(", groupId='").append(this.groupId).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", artifactId='").append(this.artifactId).append('\'');
        sb.append(", version='").append(this.version).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static URI mavenCoordinatesToUri(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, String classifier) {
        StringBuilder ssp = new StringBuilder();
        ssp.append(groupId).append(":").append(artifactId).append(":").append(version).append(":zip");
        if (StringUtils.isNotEmpty((String)classifier)) {
            ssp.append(":").append(classifier);
        }
        try {
            return new URI(MAVEN_REPOSITORY_SCHEME, ssp.toString(), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not create uri from string " + ssp.toString(), e);
        }
    }

    public static Artifact uriToMavenCoordinates(URI uri) {
        if (!MAVEN_REPOSITORY_SCHEME.equals(uri.getScheme())) {
            return null;
        }
        if (!uri.isOpaque()) {
            throw new IllegalArgumentException("Only opaque Maven URIs are supported");
        }
        String[] parts = uri.getSchemeSpecificPart().split(":");
        if (parts.length < 2) {
            throw new IllegalArgumentException("At least group id and artifact id need to be given separatedby ':'");
        }
        String groupId = parts[0];
        String artifactId = parts[1];
        String version = "default";
        if (parts.length > 2) {
            version = parts[2];
        }
        String type = "zip";
        if (parts.length > 3) {
            type = parts[3];
        }
        String classifier = "";
        if (parts.length > 4) {
            type = parts[4];
        }
        return new DefaultArtifact(groupId, artifactId, version, null, type, classifier, null);
    }
}

