/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.filevault.maven.packaging.AbstractMetadataPackageMojo;
import org.apache.jackrabbit.filevault.maven.packaging.AbstractSourceAndMetadataPackageMojo;
import org.apache.jackrabbit.filevault.maven.packaging.AbstractValidateMojo;
import org.apache.jackrabbit.filevault.maven.packaging.ValidationHelper;
import org.apache.jackrabbit.filevault.maven.packaging.validator.impl.context.DirectoryValidationContext;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.validation.ValidationExecutor;
import org.apache.jackrabbit.vault.validation.spi.ValidationContext;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.LifecycleNotFoundException;
import org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.Scanner;

@Mojo(name="validate-files", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class ValidateFilesMojo
extends AbstractValidateMojo {
    @Parameter(property="vault.metaInfVaultDirectory", required=true, defaultValue="${project.basedir}/META-INF/vault,${project.basedir}/src/main/META-INF/vault,${project.basedir}/src/main/content/META-INF/vault,${project.basedir}/src/content/META-INF/vault")
    File[] metaInfVaultDirectory;
    @Parameter(defaultValue="${project.build.directory}/vault-work", required=true)
    File workDirectory;
    @Deprecated
    @Parameter
    private File builtContentDirectory;
    @Parameter(property="vault.jcrRootSourceDirectory", required=true, defaultValue="${project.basedir}/jcr_root,${project.basedir}/src/main/jcr_root,${project.basedir}/src/main/content/jcr_root,${project.basedir}/src/content/jcr_root,${project.build.outputDirectory}")
    private File[] jcrRootSourceDirectory;
    @Parameter(property="vault.excludes", defaultValue="**/.vlt,**/.vltignore", required=true)
    protected String[] excludes;
    @Component
    protected LifecycleExecutor lifecycleExecutor;
    private static final String PLUGIN_KEY = "org.apache.jackrabbit:filevault-package-maven-plugin";

    @Override
    protected boolean shouldSkip() {
        List<String> allGoals;
        if (this.session != null) {
            allGoals = this.session.getGoals();
            this.getLog().debug((CharSequence)("Following goals are detected: " + StringUtils.join(allGoals, (String)", ")));
        } else {
            this.getLog().debug((CharSequence)"MavenSession not available. Maybe executed by m2e.");
            allGoals = Collections.emptyList();
        }
        try {
            if (!this.buildContext.isIncremental() && this.isMojoGoalExecuted(this.lifecycleExecutor, "validate-package", allGoals.toArray(new String[0]))) {
                this.getLog().info((CharSequence)"Skip this mojo as this is not an incremental build and 'validate-package' is executed later on!");
                return true;
            }
        }
        catch (LifecycleNotFoundException | LifecyclePhaseNotFoundException | InvalidPluginDescriptorException | MojoNotFoundException | PluginDescriptorParsingException | PluginManagerException | PluginNotFoundException | PluginResolutionException | NoPluginFoundForPrefixException | PluginVersionResolutionException e1) {
            this.getLog().warn((CharSequence)"Could not determine plugin executions", e1);
        }
        return false;
    }

    @Override
    public void doExecute(ValidationHelper validationHelper) throws MojoExecutionException, MojoFailureException {
        this.disableChecksOnlyWorkingForPackages();
        try {
            File metaInfoVaultSourceDirectory = AbstractMetadataPackageMojo.getMetaInfVaultSourceDirectory(this.metaInfVaultDirectory, this.getLog());
            File metaInfRootDirectory = null;
            if (metaInfoVaultSourceDirectory != null) {
                metaInfRootDirectory = metaInfoVaultSourceDirectory.getParentFile();
            }
            File generatedMetaInfRootDirectory = new File(this.workDirectory, "META-INF");
            this.getLog().info((CharSequence)("Validate files in generatedMetaInfRootDirectory " + this.getProjectRelativeFilePath(generatedMetaInfRootDirectory) + " and metaInfRootDir " + this.getProjectRelativeFilePath(generatedMetaInfRootDirectory)));
            DirectoryValidationContext context = new DirectoryValidationContext(generatedMetaInfRootDirectory, metaInfRootDirectory, this.resolver, this.getLog());
            ValidationExecutor executor = this.validationExecutorFactory.createValidationExecutor((ValidationContext)context, false, false, this.getValidatorSettingsForPackage(context.getProperties().getId(), false));
            if (executor == null) {
                throw new MojoExecutionException("No registered validators found!");
            }
            validationHelper.printUsedValidators(this.getLog(), executor, context, true);
            if (metaInfRootDirectory != null) {
                this.validateDirectory(validationHelper, executor, metaInfRootDirectory, true);
            }
            this.validateDirectory(validationHelper, executor, generatedMetaInfRootDirectory, true);
            File jcrSourceDirectory = AbstractSourceAndMetadataPackageMojo.getJcrSourceDirectory(this.jcrRootSourceDirectory, this.builtContentDirectory, this.getLog());
            if (jcrSourceDirectory != null) {
                this.validateDirectory(validationHelper, executor, jcrSourceDirectory, false);
            }
            validationHelper.printMessages(executor.done(), this.getLog(), this.buildContext, this.project.getBasedir().toPath());
        }
        catch (IOException | ConfigurationException e) {
            throw new MojoFailureException("Could not execute validation", e);
        }
        validationHelper.failBuildInCaseOfViolations(this.failOnValidationWarnings);
    }

    private void validateDirectory(ValidationHelper validationHelper, ValidationExecutor executor, File baseDir, boolean isMetaInf) {
        Scanner scanner = this.buildContext.newScanner(baseDir);
        scanner.setExcludes(this.excludes);
        scanner.addDefaultExcludes();
        scanner.scan();
        this.getLog().info((CharSequence)("Scanning baseDir " + this.getProjectRelativeFilePath(baseDir) + "..."));
        List<String> sortedFileNames = Arrays.asList(scanner.getIncludedFiles());
        sortedFileNames.sort(new AbstractValidateMojo.DotContentXmlFirstComparator());
        for (String fileName : sortedFileNames) {
            this.validateFile(validationHelper, executor, baseDir, isMetaInf, fileName);
        }
        for (String relativeFile : scanner.getIncludedDirectories()) {
            this.validateFolder(validationHelper, executor, baseDir, isMetaInf, relativeFile);
        }
    }

    private void validateFile(ValidationHelper validationHelper, ValidationExecutor executor, File baseDir, boolean isMetaInf, String relativeFile) {
        File absoluteFile = new File(baseDir, relativeFile);
        validationHelper.clearPreviousValidationMessages(this.buildContext, absoluteFile);
        this.getLog().debug((CharSequence)("Validating file " + this.getProjectRelativeFilePath(absoluteFile) + "..."));
        try (FileInputStream input = new FileInputStream(absoluteFile);){
            this.validateInputStream(validationHelper, executor, input, baseDir, isMetaInf, relativeFile);
        }
        catch (FileNotFoundException e) {
            this.getLog().error((CharSequence)("Could not find file " + this.getProjectRelativeFilePath(absoluteFile)), (Throwable)e);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Could not validate file " + this.getProjectRelativeFilePath(absoluteFile)), (Throwable)e);
        }
    }

    private void validateFolder(ValidationHelper validationHelper, ValidationExecutor executor, File baseDir, boolean isMetaInf, String relativeFile) {
        File absoluteFile = new File(baseDir, relativeFile);
        validationHelper.clearPreviousValidationMessages(this.buildContext, absoluteFile);
        this.getLog().debug((CharSequence)("Validating folder " + this.getProjectRelativeFilePath(absoluteFile) + "..."));
        try {
            this.validateInputStream(validationHelper, executor, null, baseDir, isMetaInf, relativeFile);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Could not validate folder " + this.getProjectRelativeFilePath(absoluteFile)), (Throwable)e);
        }
    }

    private void validateInputStream(ValidationHelper validationHelper, ValidationExecutor executor, InputStream input, File baseDir, boolean isMetaInf, String relativeFile) throws IOException {
        Collection messages = isMetaInf ? executor.validateMetaInf(input, Paths.get(relativeFile, new String[0]), baseDir.toPath()) : executor.validateJcrRoot(input, Paths.get(relativeFile, new String[0]), baseDir.toPath());
        validationHelper.printMessages(messages, this.getLog(), this.buildContext, this.project.getBasedir().toPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMojoGoalExecuted(LifecycleExecutor lifecycleExecutor, String mojoGoal, String ... goals) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginManagerException {
        if (goals.length == 0) {
            return false;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            MavenExecutionPlan executionPlan = lifecycleExecutor.calculateExecutionPlan(this.session, goals);
            for (MojoExecution mojoExecution : executionPlan.getMojoExecutions()) {
                if (ValidateFilesMojo.isMojoGoalExecuted(mojoExecution, mojoGoal)) {
                    boolean bl = true;
                    return bl;
                }
                lifecycleExecutor.calculateForkedExecutions(mojoExecution, this.session);
                if (!mojoExecution.getForkedExecutions().values().stream().flatMap(Collection::stream).anyMatch(t -> ValidateFilesMojo.isMojoGoalExecuted(t, mojoGoal))) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private static boolean isMojoGoalExecuted(MojoExecution mojoExecution, String mojoGoal) {
        return PLUGIN_KEY.equals(mojoExecution.getPlugin().getKey()) && mojoGoal.equals(mojoExecution.getGoal());
    }
}

