/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.filevault.maven.packaging.MavenBasedPackageDependency;
import org.apache.jackrabbit.filevault.maven.packaging.ValidationHelper;
import org.apache.jackrabbit.filevault.maven.packaging.ValidatorSettings;
import org.apache.jackrabbit.filevault.maven.packaging.ValidatorSettingsKey;
import org.apache.jackrabbit.filevault.maven.packaging.validator.impl.context.DependencyResolver;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageInfo;
import org.apache.jackrabbit.vault.validation.ValidationExecutorFactory;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.repository.DefaultRepositoryRequest;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.osgi.framework.Version;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractValidateMojo
extends AbstractMojo {
    public static final String IGNORE_GAV = "ignore";
    @Parameter(property="vault.skipValidation", defaultValue="false", required=true)
    boolean skipValidation;
    @Parameter
    private Map<String, ValidatorSettings> validatorsSettings;
    @Deprecated
    @Parameter(property="vault.failOnDependencyErrors", defaultValue="true", required=true)
    private boolean failOnDependencyErrors;
    @Parameter(property="project", readonly=true, required=false)
    protected MavenProject project;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    protected MojoExecution mojoExecution;
    @Parameter(defaultValue="${session}", readonly=true, required=false)
    protected MavenSession session;
    @Parameter(property="vault.failOnValidationWarning", defaultValue="false")
    protected boolean failOnValidationWarnings;
    @Parameter(property="vault.dependencies")
    protected Collection<MavenBasedPackageDependency> dependencies = new LinkedList<MavenBasedPackageDependency>();
    @Parameter(property="vault.repository.structure.packages")
    protected Collection<MavenBasedPackageDependency> repositoryStructurePackages = new LinkedList<MavenBasedPackageDependency>();
    @Parameter(property="vault.package.dependency.to.maven.ga")
    protected Collection<String> mapPackageDependencyToMavenGa;
    @Parameter(property="vault.validation.csvReportFile")
    protected File csvReportFile;
    @Component
    protected RepositorySystem repositorySystem;
    @Component
    protected ResolutionErrorHandler resolutionErrorHandler;
    @Component
    protected BuildContext buildContext;
    protected final ValidationExecutorFactory validationExecutorFactory = new ValidationExecutorFactory(((Object)((Object)this)).getClass().getClassLoader());
    protected DependencyResolver resolver;
    public static final Artifact IGNORE_ARTIFACT = new DefaultArtifact("ignore", "ignore", "1.0", "", "", "", null);
    private static Version fileVaultValidationBundleVersion = null;
    private static final Version VERSION_3_5_4 = Version.parseVersion((String)"3.5.4");

    protected String getProjectRelativeFilePath(Path file) {
        return "'" + this.project.getBasedir().toPath().relativize(file).toString() + "'";
    }

    static Map<Dependency, Artifact> resolveMap(Collection<String> mapPackageDependencyToMavenGa) {
        return mapPackageDependencyToMavenGa.stream().map(s -> s.split("=", 2)).peek(p -> {
            if (((String[])p).length != 2) {
                throw new IllegalArgumentException("Could not parse value");
            }
        }).collect(Collectors.toMap(a -> Dependency.fromString((String)a[0]), a -> {
            if (a[1].equalsIgnoreCase(IGNORE_GAV)) {
                return IGNORE_ARTIFACT;
            }
            String[] mavenGA = a[1].split(":", 2);
            if (mavenGA.length != 2) {
                throw new IllegalArgumentException("Could not parse Maven group Id and artifact Id (must be separated by ':')");
            }
            return new DefaultArtifact(mavenGA[0], mavenGA[1], "", "", "", "", null);
        }));
    }

    protected boolean shouldSkip() {
        return false;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.shouldSkip()) {
            return;
        }
        if (this.skipValidation) {
            this.getLog().info((CharSequence)"Skipping validation");
            return;
        }
        this.translateLegacyParametersToValidatorParameters();
        try {
            this.fixWrongDefaultForValidatorParameters();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Could not fix the default values of validators because retrieving the FileVault validation bundle version failed: " + e.getMessage()), (Throwable)e);
        }
        LinkedList<PackageInfo> resolvedDependencies = new LinkedList<PackageInfo>();
        try (ValidationHelper validationHelper = new ValidationHelper();){
            if (this.csvReportFile != null) {
                validationHelper.setCsvFile(this.csvReportFile, StandardCharsets.UTF_8, CSVFormat.EXCEL);
            }
            if (this.project != null) {
                this.getLog().debug((CharSequence)("Clear markers in " + this.project.getBasedir()));
                validationHelper.clearPreviousValidationMessages(this.buildContext, this.project.getBasedir());
            }
            try {
                LinkedList<String> validRoots = new LinkedList<String>();
                for (PackageInfo packageInfo : this.getPackageInfoFromMavenBasedDependencies(this.repositoryStructurePackages)) {
                    for (PathFilterSet set : packageInfo.getFilter().getFilterSets()) {
                        validRoots.add(set.getRoot());
                    }
                }
                if (!validRoots.isEmpty()) {
                    ValidatorSettings settings = null;
                    if (this.validatorsSettings != null) {
                        settings = this.validatorsSettings.get("jackrabbit-filter");
                    } else {
                        this.validatorsSettings = new HashMap<String, ValidatorSettings>();
                    }
                    if (settings == null) {
                        settings = new ValidatorSettings();
                        settings.addOption("validRoots", StringUtils.join(validRoots, (String)","));
                        this.validatorsSettings.put("jackrabbit-filter", settings);
                    } else {
                        String oldValidRoots = settings.getOptions().get("validRoots");
                        settings.addOption("validRoots", oldValidRoots + "," + StringUtils.join(validRoots, (String)","));
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not get meta information for repositoryStructurePackages '" + StringUtils.join(this.repositoryStructurePackages, (String)",") + "': " + e.getMessage(), (Exception)e);
            }
            try {
                resolvedDependencies.addAll(this.getPackageInfoFromMavenBasedDependencies(this.dependencies));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not get meta information for dependencies '" + StringUtils.join(this.dependencies, (String)",") + "': " + e.getMessage(), (Exception)e);
            }
            this.resolver = new DependencyResolver(DefaultRepositoryRequest.getRepositoryRequest((MavenSession)this.session, (MavenProject)this.project), this.repositorySystem, this.resolutionErrorHandler, AbstractValidateMojo.resolveMap(this.mapPackageDependencyToMavenGa), resolvedDependencies);
            this.doExecute(validationHelper);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create/write to CSV File", (Exception)e);
        }
    }

    private Collection<PackageInfo> getPackageInfoFromMavenBasedDependencies(Collection<MavenBasedPackageDependency> dependencies) throws IOException {
        LinkedList<PackageInfo> packageInfos = new LinkedList<PackageInfo>();
        MavenBasedPackageDependency.resolve(this.project, this.getLog(), dependencies);
        for (MavenBasedPackageDependency dependency : dependencies) {
            if (dependency.getInfo() == null) continue;
            packageInfos.add(dependency.getInfo());
        }
        return packageInfos;
    }

    private void translateLegacyParametersToValidatorParameters() throws MojoExecutionException {
        if (!this.failOnDependencyErrors) {
            ValidatorSettings filterValidatorSettings;
            this.getLog().warn((CharSequence)"Deprecated parameter 'failOnDependencyErrors' used.");
            if (this.validatorsSettings != null) {
                if (this.validatorsSettings.containsKey("jackrabbit-dependencies")) {
                    throw new MojoExecutionException("Can not set parameters 'failOnDependencyErrors' and 'validationSettings' for 'jackrabbit-dependencies' at the same time");
                }
            } else {
                this.validatorsSettings = new HashMap<String, ValidatorSettings>();
            }
            ValidatorSettings dependencyValidatorSettings = new ValidatorSettings();
            dependencyValidatorSettings.setDefaultSeverity(ValidationMessageSeverity.DEBUG);
            this.validatorsSettings.put("jackrabbit-dependencies", dependencyValidatorSettings);
            ValidatorSettings validatorSettings = filterValidatorSettings = this.validatorsSettings.containsKey("jackrabbit-filter") ? this.validatorsSettings.get("jackrabbit-filter") : new ValidatorSettings();
            if (filterValidatorSettings.getOptions().containsKey("severityForUncoveredAncestorNodes")) {
                throw new MojoExecutionException("Can not set parameters 'failOnDependencyErrors' and 'validationSettings' for 'jackrabbit-dependencies' with option'severityForUncoveredAncestorNodes' at the same time");
            }
            filterValidatorSettings.addOption("severityForUncoveredAncestorNodes", ValidationMessageSeverity.DEBUG.toString().toLowerCase(Locale.ROOT));
        }
    }

    private void fixWrongDefaultForValidatorParameters() throws IOException {
        if (AbstractValidateMojo.getFileVaultValidationBundleVersion().equals((Object)VERSION_3_5_4)) {
            ValidatorSettings packageTypeValidatorSettings;
            if (this.validatorsSettings == null) {
                this.validatorsSettings = new HashMap<String, ValidatorSettings>();
            }
            if ((packageTypeValidatorSettings = this.validatorsSettings.get("jackrabbit-packagetype")) == null) {
                packageTypeValidatorSettings = new ValidatorSettings();
                this.validatorsSettings.put("jackrabbit-packagetype", packageTypeValidatorSettings);
            }
            if (!packageTypeValidatorSettings.getOptions().containsKey("additionalJcrInstallerFileNodePathRegex")) {
                packageTypeValidatorSettings.addOption("additionalJcrInstallerFileNodePathRegex", ".*\\.(config|cfg|cfg\\.json|jar)");
                this.getLog().info((CharSequence)"Overriding wrong default value for validator option 'additionalJcrInstallerFileNodePathRegex' (see https://issues.apache.org/jira/browse/JCRVLT-564)");
            }
        }
    }

    static synchronized Version getFileVaultValidationBundleVersion() throws IOException {
        if (fileVaultValidationBundleVersion == null) {
            URL url = AbstractValidateMojo.class.getClassLoader().getResource("org/apache/jackrabbit/vault/validation/ValidationExecutor.class");
            if (url == null) {
                throw new IllegalStateException("This classloader does not see the ValidationExecutor class from FileVault Validation");
            }
            URLConnection connection = url.openConnection();
            fileVaultValidationBundleVersion = connection instanceof JarURLConnection ? Version.parseVersion((String)((JarURLConnection)connection).getMainAttributes().getValue("Bundle-Version")) : Version.emptyVersion;
        }
        return fileVaultValidationBundleVersion;
    }

    public abstract void doExecute(ValidationHelper var1) throws MojoExecutionException, MojoFailureException;

    protected Map<String, ValidatorSettings> getValidatorSettingsForPackage(PackageId packageId, boolean isSubPackage) throws MojoFailureException {
        try {
            return AbstractValidateMojo.getValidatorSettingsForPackage(this.getLog(), this.validatorsSettings, packageId, isSubPackage);
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException("Invalid value for 'validatorsSettings': " + e.getMessage(), (Throwable)e);
        }
    }

    protected static Map<String, ValidatorSettings> getValidatorSettingsForPackage(Log log, Map<String, ValidatorSettings> validatorsSettings, PackageId packageId, boolean isSubPackage) {
        HashMap<String, ValidatorSettings> validatorSettingsById = new HashMap<String, ValidatorSettings>();
        if (validatorsSettings == null) {
            return validatorSettingsById;
        }
        List sortedKeys = validatorsSettings.keySet().stream().map(ValidatorSettingsKey::fromString).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        for (ValidatorSettingsKey key : sortedKeys) {
            if (!key.matchesForPackage(packageId, isSubPackage)) continue;
            ValidatorSettings settings = (ValidatorSettings)validatorSettingsById.get(key.getValidatorId());
            settings = settings != null ? settings.merge(validatorsSettings.get(key.getKey())) : validatorsSettings.get(key.getKey());
            validatorSettingsById.put(key.getValidatorId(), settings);
        }
        return validatorSettingsById;
    }

    static final class DotContentXmlFirstComparator
    implements Comparator<String> {
        DotContentXmlFirstComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (".content.xml".equals(s1) && ".content.xml".equals(s2)) {
                return 0;
            }
            if (".content.xml".equals(s1)) {
                return -1;
            }
            if (".content.xml".equals(s2)) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    }
}

