/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jackrabbit.filevault.maven.packaging.AbstractSourceAndMetadataPackageMojo;
import org.apache.jackrabbit.vault.fs.io.DocViewFormat;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.Scanner;
import org.jetbrains.annotations.NotNull;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="format-xml", defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true)
public class FormatDocviewXmlMojo
extends AbstractMojo {
    @Parameter(property="vault.jcrRootSourceDirectory", required=true, defaultValue="${project.basedir}/jcr_root,${project.basedir}/src/main/jcr_root,${project.basedir}/src/main/content/jcr_root,${project.basedir}/src/content/jcr_root,${project.build.outputDirectory}")
    private File[] jcrRootSourceDirectory;
    @Parameter
    protected Set<String> includes = new HashSet<String>();
    @Parameter
    protected Set<String> excludes = new HashSet<String>();
    @Parameter(defaultValue="false")
    private boolean validateOnly;
    @Parameter(defaultValue="false")
    private boolean enableForIncrementalBuild;
    @Component
    protected BuildContext buildContext;
    private static final String MSG_MALFORMED_FILE = "Malformed according to DocView format";
    private static final String MSG_COUNTERMEASURE = "Use either your IDE with JCR-VLT integration to sync files with the repository or use vlt-cli to apply the docview format (http://jackrabbit.apache.org/filevault/usage.html).";

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.buildContext.isIncremental() && !this.enableForIncrementalBuild) {
            this.getLog().info((CharSequence)"Skip executing mojo 'format-xml' for incremental builds as parameter 'enableForIncrementalBuilds' is set to 'false'");
        } else {
            File jcrSourceDirectory = AbstractSourceAndMetadataPackageMojo.getFirstExistingDirectory(this.jcrRootSourceDirectory);
            if (jcrSourceDirectory != null) {
                this.executeInternal(jcrSourceDirectory);
            } else if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("None of the configured jcrRootSourceDirectory directories exists, skipping: " + Arrays.stream(this.jcrRootSourceDirectory).map(File::toString).collect(Collectors.joining(", "))));
            }
        }
    }

    protected void executeInternal(@NotNull File sourceDirectory) throws MojoExecutionException, MojoFailureException {
        if (this.includes.isEmpty()) {
            this.includes.add("**/*.xml");
        }
        Log log = this.getLog();
        LinkedList<File> malformedFiles = new LinkedList<File>();
        DocViewFormat docViewFormat = new DocViewFormat();
        Scanner directoryScanner = this.buildContext.newScanner(sourceDirectory);
        directoryScanner.setIncludes(this.includes.toArray(new String[this.includes.size()]));
        directoryScanner.setExcludes(this.excludes.toArray(new String[this.excludes.size()]));
        directoryScanner.scan();
        for (String subpath : directoryScanner.getIncludedFiles()) {
            File toCheck = new File(sourceDirectory, subpath);
            try {
                if (docViewFormat.format(toCheck, this.validateOnly)) {
                    if (this.validateOnly) {
                        malformedFiles.add(toCheck);
                        this.buildContext.addMessage(toCheck, 0, 0, "Malformed according to DocView format. Use either your IDE with JCR-VLT integration to sync files with the repository or use vlt-cli to apply the docview format (http://jackrabbit.apache.org/filevault/usage.html).", 2, null);
                        log.error((CharSequence)("Malformed according to DocView format:" + toCheck.getCanonicalPath()));
                        continue;
                    }
                    log.info((CharSequence)("Reformatted file '" + toCheck.getCanonicalPath() + "'."));
                    continue;
                }
                this.buildContext.removeMessages(toCheck);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to read " + toCheck, (Exception)ex);
            }
        }
        if (!malformedFiles.isEmpty()) {
            String message = "Found " + malformedFiles.size() + " files being malformed according to DocView format: Please check error message emitted above.\n\n" + MSG_COUNTERMEASURE;
            throw new MojoFailureException(message);
        }
    }
}

