/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;

public class ValidatorSettings
implements org.apache.jackrabbit.vault.validation.spi.ValidatorSettings {
    private Boolean isDisabled;
    private ValidationMessageSeverity defaultSeverity;
    private final Map<String, String> options = new HashMap<String, String>();

    public ValidatorSettings merge(ValidatorSettings otherSettings) {
        ValidatorSettings mergedSettings = new ValidatorSettings();
        mergedSettings.isDisabled = this.isDisabled != null ? this.isDisabled : otherSettings.isDisabled;
        mergedSettings.defaultSeverity = this.defaultSeverity != null ? this.defaultSeverity : otherSettings.defaultSeverity;
        mergedSettings.options.putAll(this.options);
        for (Map.Entry<String, String> entry : otherSettings.getOptions().entrySet()) {
            if (this.options.containsKey(entry.getKey())) continue;
            mergedSettings.addOption(entry.getKey(), entry.getValue());
        }
        return mergedSettings;
    }

    public ValidatorSettings setDefaultSeverity(String defaultSeverity) {
        if (defaultSeverity != null) {
            this.defaultSeverity = ValidationMessageSeverity.valueOf((String)defaultSeverity.toUpperCase());
        }
        return this;
    }

    public void setDefaultSeverity(ValidationMessageSeverity defaultSeverity) {
        this.defaultSeverity = defaultSeverity;
    }

    protected ValidatorSettings addOption(String key, String value) {
        this.options.put(key, value);
        return this;
    }

    public ValidationMessageSeverity getDefaultSeverity() {
        return this.defaultSeverity != null ? this.defaultSeverity : ValidationMessageSeverity.ERROR;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public boolean isDisabled() {
        return this.isDisabled != null && this.isDisabled != false;
    }

    public void setIsDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public String toString() {
        return "ValidatorSettings [" + (this.isDisabled != null ? "isDisabled=" + this.isDisabled + ", " : "") + (this.defaultSeverity != null ? "defaultSeverity=" + this.defaultSeverity + ", " : "") + (this.options != null ? "options=" + this.options : "") + "]";
    }

    public int hashCode() {
        return Objects.hash(this.defaultSeverity, this.isDisabled, this.options);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidatorSettings other = (ValidatorSettings)obj;
        return this.defaultSeverity == other.defaultSeverity && Objects.equals(this.isDisabled, other.isDisabled) && Objects.equals(this.options, other.options);
    }
}

