/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import java.util.Objects;
import org.apache.jackrabbit.vault.packaging.PackageId;

public class ValidatorSettingsKey
implements Comparable<ValidatorSettingsKey> {
    private static final int LESS_THAN = -1;
    private static final int GREATER_THEN = 1;
    private static final String WILDCARD_FILTER_VALUE = "*";
    final String key;
    final String validatorId;
    final boolean isForSubPackagesOnly;
    final String packageNameFilter;
    final String packageGroupFilter;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ValidatorSettingsKey fromString(String key) {
        String[] parts = key.split(":", 3);
        String validatorId = parts[0];
        boolean isForSubPackagesOnly = false;
        String packageGroupFilter = null;
        String packageNameFilter = null;
        if (parts.length == 2) {
            if (!parts[1].equals("subpackage")) throw new IllegalArgumentException("Invalid validatorSettings key '" + key + "'");
            isForSubPackagesOnly = true;
            return new ValidatorSettingsKey(key, validatorId, isForSubPackagesOnly, packageGroupFilter, packageNameFilter);
        } else {
            if (parts.length != 3) return new ValidatorSettingsKey(key, validatorId, isForSubPackagesOnly, packageGroupFilter, packageNameFilter);
            packageGroupFilter = parts[1];
            packageNameFilter = parts[2];
        }
        return new ValidatorSettingsKey(key, validatorId, isForSubPackagesOnly, packageGroupFilter, packageNameFilter);
    }

    ValidatorSettingsKey(String key, String validatorId, boolean isForSubPackagesOnly, String packageGroupFilter, String packageNameFilter) {
        this.key = key;
        this.validatorId = validatorId;
        this.isForSubPackagesOnly = isForSubPackagesOnly;
        this.packageGroupFilter = packageGroupFilter;
        this.packageNameFilter = packageNameFilter;
    }

    public String getKey() {
        return this.key;
    }

    public String getValidatorId() {
        return this.validatorId;
    }

    public boolean matchesForPackage(PackageId packageId, boolean isSubPackage) {
        if (!isSubPackage && this.isForSubPackagesOnly) {
            return false;
        }
        if (this.packageNameFilter != null && !this.packageNameFilter.equals(packageId.getName())) {
            return false;
        }
        return this.packageGroupFilter == null || WILDCARD_FILTER_VALUE.equals(this.packageGroupFilter) || this.packageGroupFilter.equals(packageId.getGroup());
    }

    @Override
    public int compareTo(ValidatorSettingsKey o) {
        if (this.packageNameFilter != null && o.packageNameFilter != null) {
            if (WILDCARD_FILTER_VALUE.equals(this.packageGroupFilter)) {
                if (WILDCARD_FILTER_VALUE.equals(o.packageGroupFilter)) {
                    return this.packageNameFilter.compareTo(o.packageNameFilter);
                }
                return -1;
            }
            if (WILDCARD_FILTER_VALUE.equals(o.packageGroupFilter)) {
                return 1;
            }
            return this.packageNameFilter.compareTo(o.packageNameFilter);
        }
        if (this.packageNameFilter == null && o.packageNameFilter != null) {
            return -1;
        }
        if (this.packageNameFilter != null && o.packageNameFilter == null) {
            return 1;
        }
        if (!this.isForSubPackagesOnly && o.isForSubPackagesOnly) {
            return -1;
        }
        if (this.isForSubPackagesOnly && !o.isForSubPackagesOnly) {
            return 1;
        }
        return this.validatorId.compareTo(o.validatorId);
    }

    public int hashCode() {
        return Objects.hash(this.isForSubPackagesOnly, this.key, this.packageGroupFilter, this.packageNameFilter, this.validatorId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidatorSettingsKey other = (ValidatorSettingsKey)obj;
        return this.isForSubPackagesOnly == other.isForSubPackagesOnly && Objects.equals(this.key, other.key) && Objects.equals(this.packageGroupFilter, other.packageGroupFilter) && Objects.equals(this.packageNameFilter, other.packageNameFilter) && Objects.equals(this.validatorId, other.validatorId);
    }

    public String toString() {
        return "ValidatorSettingsKey [" + (this.key != null ? "key=" + this.key + ", " : "") + (this.validatorId != null ? "validatorId=" + this.validatorId + ", " : "") + "isForSubPackagesOnly=" + this.isForSubPackagesOnly + ", " + (this.packageNameFilter != null ? "packageNameFilter=" + this.packageNameFilter + ", " : "") + (this.packageGroupFilter != null ? "packageGroupFilter=" + this.packageGroupFilter : "") + "]";
    }
}

