/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.impl;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.PackageInfo;
import org.apache.jackrabbit.vault.packaging.impl.DefaultPackageInfo;
import org.apache.jackrabbit.vault.validation.context.AbstractDependencyResolver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.repository.RepositorySystem;
import org.jetbrains.annotations.Nullable;

public class DependencyResolver
extends AbstractDependencyResolver {
    private final RepositoryRequest repositoryRequest;
    private final RepositorySystem repositorySystem;
    private final ResolutionErrorHandler resolutionErrorHandler;
    private final Log log;

    public DependencyResolver(RepositoryRequest repositoryRequest, RepositorySystem repositorySystem, ResolutionErrorHandler resolutionErrorHandler, Map<Dependency, Artifact> mapPackageDependencyToMavenArtifact, Collection<PackageInfo> knownPackageInfos, Log log) {
        super(knownPackageInfos);
        this.repositoryRequest = repositoryRequest;
        this.repositorySystem = repositorySystem;
        this.resolutionErrorHandler = resolutionErrorHandler;
        this.log = log;
    }

    @Nullable
    private File resolve(Artifact artifact, Log log) {
        ArtifactResolutionRequest resolutionRequest = new ArtifactResolutionRequest(this.repositoryRequest);
        resolutionRequest.setArtifact(artifact);
        ArtifactResolutionResult result = this.repositorySystem.resolve(resolutionRequest);
        if (result.isSuccess()) {
            log.debug((CharSequence)("Successfully resolved artifact " + artifact.getArtifactId()));
            Artifact resolvedArtifact = (Artifact)result.getArtifacts().iterator().next();
            return resolvedArtifact.getFile();
        }
        try {
            this.resolutionErrorHandler.throwErrors(resolutionRequest, result);
        }
        catch (ArtifactResolutionException e) {
            log.debug((Throwable)e);
        }
        return null;
    }

    @Nullable
    public PackageInfo resolvePackageInfo(AbstractDependencyResolver.MavenCoordinates mavenCoordinates) throws IOException {
        Artifact artifact = mavenCoordinates.getClassifier() != null ? this.repositorySystem.createArtifactWithClassifier(mavenCoordinates.getGroupId(), mavenCoordinates.getArtifactId(), mavenCoordinates.getVersion(), mavenCoordinates.getPackaging(), mavenCoordinates.getClassifier()) : this.repositorySystem.createArtifact(mavenCoordinates.getGroupId(), mavenCoordinates.getArtifactId(), mavenCoordinates.getVersion(), mavenCoordinates.getPackaging());
        File file = this.resolve(artifact, this.log);
        if (file != null) {
            return DefaultPackageInfo.read((File)file);
        }
        return null;
    }
}

