/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import org.apache.jackrabbit.filevault.maven.packaging.impl.DependencyResolver;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.packaging.PackageInfo;
import org.apache.jackrabbit.vault.packaging.PackageProperties;
import org.apache.jackrabbit.vault.packaging.impl.DefaultPackageProperties;
import org.apache.jackrabbit.vault.validation.spi.ValidationContext;
import org.apache.maven.plugin.logging.Log;
import org.jetbrains.annotations.NotNull;

public class DirectoryValidationContext
implements ValidationContext {
    private final PackageProperties properties;
    private final DefaultWorkspaceFilter filter;
    private Collection<PackageInfo> resolvedDependencies;
    private final boolean isIncremental;
    private static final Path RELATIVE_PROPERTIES_XML_PATH = Paths.get("vault", "properties.xml");

    public DirectoryValidationContext(boolean isIncremental, @NotNull File generatedMetaInfRootDirectory, File metaInfRootDirectory, DependencyResolver resolver, @NotNull Log log) throws IOException, ConfigurationException {
        Path propertiesPath = null;
        if (!"META-INF".equals(generatedMetaInfRootDirectory.getName())) {
            throw new IllegalArgumentException("The workDir must end with 'META-INF' but is '" + generatedMetaInfRootDirectory + "'");
        }
        if (metaInfRootDirectory != null) {
            if (!"META-INF".equals(metaInfRootDirectory.getName())) {
                throw new IllegalArgumentException("The metaInfRootDirectory must end with 'META-INF' but is '" + metaInfRootDirectory + "'");
            }
            propertiesPath = metaInfRootDirectory.toPath().resolve("vault").resolve("properties.xml");
        }
        if (propertiesPath == null || !Files.exists(propertiesPath, new LinkOption[0])) {
            propertiesPath = generatedMetaInfRootDirectory.toPath().resolve(RELATIVE_PROPERTIES_XML_PATH);
            if (!Files.exists(propertiesPath, new LinkOption[0])) {
                throw new IllegalStateException("No '" + RELATIVE_PROPERTIES_XML_PATH + "' found in either '" + metaInfRootDirectory + "' or '" + generatedMetaInfRootDirectory + "'");
            }
            log.debug((CharSequence)("Using '" + RELATIVE_PROPERTIES_XML_PATH + "' from directory " + generatedMetaInfRootDirectory));
        } else {
            log.debug((CharSequence)("Using '" + RELATIVE_PROPERTIES_XML_PATH + "' from directory " + metaInfRootDirectory));
        }
        this.properties = DefaultPackageProperties.fromFile((Path)propertiesPath);
        this.filter = new DefaultWorkspaceFilter();
        File filterFile = new File(generatedMetaInfRootDirectory, "vault/filter.xml");
        if (!filterFile.exists()) {
            throw new IllegalStateException("No mandatory 'vault/filter.xml' found in " + generatedMetaInfRootDirectory + "'");
        }
        this.filter.load(filterFile);
        this.resolvedDependencies = resolver.resolvePackageInfo(this.getProperties().getDependencies(), this.getProperties().getDependenciesLocations());
        this.isIncremental = isIncremental;
    }

    public PackageProperties getProperties() {
        return this.properties;
    }

    public WorkspaceFilter getFilter() {
        return this.filter;
    }

    public ValidationContext getContainerValidationContext() {
        return null;
    }

    public Path getPackageRootPath() {
        return null;
    }

    public Collection<PackageInfo> getDependenciesPackageInfo() {
        return this.resolvedDependencies;
    }

    public boolean isIncremental() {
        return this.isIncremental;
    }
}

