/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.mojo;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jackrabbit.filevault.maven.packaging.Filters;
import org.apache.jackrabbit.filevault.maven.packaging.impl.ContentPackageArchiver;
import org.apache.jackrabbit.filevault.maven.packaging.impl.PlexusIoNonExistingDirectoryResource;
import org.apache.jackrabbit.filevault.maven.packaging.mojo.AbstractSourceAndMetadataPackageMojo;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.shared.utils.io.MatchPatterns;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.jetbrains.annotations.NotNull;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class VaultMojo
extends AbstractSourceAndMetadataPackageMojo {
    private static final String PACKAGE_TYPE = "zip";
    public static final String PACKAGE_EXT = ".zip";
    private static final Collection<File> STATIC_META_INF_FILES = Arrays.asList(new File("META-INF/vault", "config.xml"), new File("META-INF/vault", "settings.xml"));
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Parameter(property="vault.metaInfDirectory", required=false)
    File metaInfDirectory;
    @Parameter(property="vault.failOnUncoveredSourceFiles", required=true, defaultValue="false")
    private boolean failOnUncoveredSourceFiles;
    @Parameter(property="vault.failOnDuplicateEntries", required=true, defaultValue="true")
    private boolean failOnDuplicateEntries;
    @Parameter(property="vault.finalName", defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter(property="vault.outputDirectory", defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(property="vault.enableMetaInfFiltering", defaultValue="false")
    private boolean enableMetaInfFiltering;
    @Parameter(property="vault.enableJcrRootFiltering", defaultValue="false")
    private boolean enableJcrRootFiltering;
    @Parameter(property="vault.delimiters")
    private LinkedHashSet<String> delimiters;
    @Parameter(property="vault.useDefaultDelimiters", defaultValue="true")
    private boolean useDefaultDelimiters;
    @Parameter(property="vault.resourceEncoding", defaultValue="${project.build.sourceEncoding}")
    private String resourceEncoding;
    @Parameter(property="vault.filters")
    private List<String> filterFiles;
    @Parameter(property="vault.escapeString")
    protected String escapeString;
    @Parameter(property="vault.escapedBackslashesInFilePath", defaultValue="false")
    private boolean escapedBackslashesInFilePath;
    @Parameter(property="vault.nonFilteredFileExtensions")
    private List<String> nonFilteredFileExtensions;
    @Parameter(property="vault.filteredFilePatterns")
    private List<String> filteredFilePatterns;
    @Parameter(property="vault.supportMultiLineFiltering", defaultValue="false")
    private boolean supportMultiLineFiltering;
    @Parameter(defaultValue="${session}", readonly=true, required=false)
    protected MavenSession session;
    @Parameter
    private MavenArchiveConfiguration archive;
    @Component(role=MavenResourcesFiltering.class, hint="default")
    MavenResourcesFiltering mavenResourcesFiltering;
    @Component
    private MavenProjectHelper projectHelper;
    private Map<File, File> protectedFiles = new HashMap<File, File>();

    @NotNull
    protected DefaultFileSet createFileSet(@NotNull File directory, @NotNull String prefix) {
        return this.createFileSet(directory, prefix, null);
    }

    @NotNull
    protected DefaultFileSet createFileSet(@NotNull File directory, @NotNull String prefix, List<String> additionalExcludes) {
        LinkedList<String> excludes = new LinkedList<String>(this.excludes);
        if (additionalExcludes != null) {
            excludes.addAll(additionalExcludes);
        }
        DefaultFileSet fileSet = (DefaultFileSet)((DefaultFileSet)((DefaultFileSet)DefaultFileSet.fileSet((File)directory).prefixed(prefix)).includeExclude(null, excludes.toArray(new String[0]))).includeEmptyDirs(true);
        fileSet.setUsingDefaultExcludes(this.addDefaultExcludes);
        return fileSet;
    }

    protected void addFileToArchive(MavenResourcesExecution mavenResourcesExecution, ContentPackageArchiver archiver, File sourceFile, String destFileName) throws MavenFilteringException {
        Path destFile = Paths.get(destFileName, new String[0]);
        if (destFile.startsWith("jcr_root") && this.enableJcrRootFiltering || destFile.startsWith("META-INF") && this.enableMetaInfFiltering) {
            MatchPatterns matchPatterns = MatchPatterns.from((String[])this.filteredFilePatterns.toArray(new String[0]));
            if (this.filteredFilePatterns == null || matchPatterns.matches(sourceFile.toString(), true)) {
                this.getLog().info((CharSequence)("Apply filtering to " + this.getProjectRelativeFilePath(sourceFile)));
                Resource resource = new Resource();
                resource.setDirectory(sourceFile.getParent());
                resource.setIncludes(Collections.singletonList(sourceFile.getName()));
                resource.setFiltering(true);
                File newTargetDirectory = this.applyFiltering(destFile.getParent().toString(), mavenResourcesExecution, resource);
                sourceFile = new File(newTargetDirectory, sourceFile.getName());
            }
        }
        this.getLog().debug((CharSequence)("Adding file " + this.getProjectRelativeFilePath(sourceFile) + " to package at " + destFileName + "'"));
        archiver.addFile(sourceFile, destFileName);
    }

    protected void addFileSetToArchive(MavenResourcesExecution mavenResourcesExecution, ContentPackageArchiver archiver, DefaultFileSet fileSet) throws MavenFilteringException {
        if (fileSet.getPrefix().startsWith("jcr_root") && this.enableJcrRootFiltering || fileSet.getPrefix().startsWith("META-INF") && this.enableMetaInfFiltering) {
            this.getLog().info((CharSequence)("Apply filtering to FileSet below " + this.getProjectRelativeFilePath(fileSet.getDirectory())));
            Resource filteringSourceResource = new Resource();
            filteringSourceResource.setDirectory(fileSet.getDirectory().getPath());
            if (this.filteredFilePatterns != null && !this.filteredFilePatterns.isEmpty()) {
                if (fileSet.getIncludes() != null) {
                    throw new IllegalStateException("FileSet can not have includes set, as those are used for filteredFileExtensions");
                }
                DefaultFileSet unfilteredFileSet = VaultMojo.cloneFileSet(fileSet);
                String[] excludes = (String[])Stream.of(Arrays.asList(fileSet.getExcludes()), this.filteredFilePatterns).flatMap(x -> x.stream()).toArray(String[]::new);
                unfilteredFileSet.setExcludes(excludes);
                this.getLog().debug((CharSequence)("Adding unfiltered fileSet '" + VaultMojo.getString((FileSet)unfilteredFileSet) + "' to package"));
                archiver.addFileSet((FileSet)unfilteredFileSet);
                filteringSourceResource.setIncludes(this.filteredFilePatterns);
            } else if (fileSet.getIncludes() != null) {
                filteringSourceResource.setIncludes(Arrays.asList(fileSet.getIncludes()));
            }
            if (fileSet.getExcludes() != null) {
                filteringSourceResource.setExcludes(Arrays.asList(fileSet.getExcludes()));
            }
            filteringSourceResource.setFiltering(true);
            File newTargetDirectory = this.applyFiltering(fileSet.getPrefix(), mavenResourcesExecution, filteringSourceResource);
            if (newTargetDirectory.exists()) {
                fileSet.setDirectory(newTargetDirectory);
                this.getLog().debug((CharSequence)("Adding filtered fileSet '" + VaultMojo.getString((FileSet)fileSet) + "' to package"));
                archiver.addFileSet((FileSet)fileSet);
            }
        } else {
            this.getLog().debug((CharSequence)("Adding fileSet '" + VaultMojo.getString((FileSet)fileSet) + "' to package"));
            archiver.addFileSet((FileSet)fileSet);
        }
    }

    static DefaultFileSet cloneFileSet(DefaultFileSet defaultFileSet) {
        DefaultFileSet newFileSet = new DefaultFileSet(defaultFileSet.getDirectory());
        newFileSet.setCaseSensitive(defaultFileSet.isCaseSensitive());
        newFileSet.setExcludes(defaultFileSet.getExcludes());
        newFileSet.setFileMappers(defaultFileSet.getFileMappers());
        newFileSet.setFileSelectors(defaultFileSet.getFileSelectors());
        newFileSet.setIncludes(defaultFileSet.getIncludes());
        newFileSet.setIncludingEmptyDirectories(defaultFileSet.isIncludingEmptyDirectories());
        newFileSet.setPrefix(defaultFileSet.getPrefix());
        newFileSet.setStreamTransformer(defaultFileSet.getStreamTransformer());
        newFileSet.setUsingDefaultExcludes(defaultFileSet.isUsingDefaultExcludes());
        return newFileSet;
    }

    private static String getString(FileSet fileSet) {
        StringBuilder sb = new StringBuilder("FileSet [");
        sb.append("directory=").append(fileSet.getDirectory());
        sb.append(" prefix=").append(fileSet.getPrefix());
        sb.append(" excludes=").append(StringUtils.join((Object[])fileSet.getExcludes(), (String)", "));
        sb.append("]");
        return sb.toString();
    }

    @NotNull
    private File applyFiltering(String prefix, MavenResourcesExecution mavenResourcesExecution, Resource resource) throws MavenFilteringException {
        File targetPath = new File(this.project.getBuild().getDirectory(), "filteredFiles");
        mavenResourcesExecution.setOutputDirectory(targetPath);
        targetPath = new File(targetPath, prefix);
        this.getLog().debug((CharSequence)("Applying filtering to resource " + resource));
        resource.setTargetPath(targetPath.getPath());
        mavenResourcesExecution.setResources(Collections.singletonList(resource));
        this.mavenResourcesFiltering.filterResources(mavenResourcesExecution);
        return targetPath;
    }

    private boolean isOverwritingProtectedFile(File zipFile, File sourceFile, boolean isProtected) {
        if (this.protectedFiles.containsKey(zipFile)) {
            return true;
        }
        if (isProtected) {
            this.protectedFiles.put(zipFile, sourceFile);
        }
        return false;
    }

    private Map<File, File> getOverwrittenProtectedFiles(FileSet fileSet, boolean isProtected) {
        String[] files;
        String[] exc;
        HashMap<File, File> overwrittenFiles = new HashMap<File, File>();
        DirectoryScanner ds = new DirectoryScanner();
        File dir = fileSet.getDirectory();
        ds.setBasedir(dir);
        String[] inc = fileSet.getIncludes();
        if (inc != null && inc.length > 0) {
            ds.setIncludes(inc);
        }
        if ((exc = fileSet.getExcludes()) != null && exc.length > 0) {
            ds.setExcludes(exc);
        }
        if (fileSet.isUsingDefaultExcludes()) {
            ds.addDefaultExcludes();
        }
        ds.setCaseSensitive(fileSet.isCaseSensitive());
        ds.setFollowSymlinks(false);
        ds.scan();
        for (String file : files = ds.getIncludedFiles()) {
            File sourceFile;
            File zipFileEntry = new File(fileSet.getPrefix() + file);
            if (!this.isOverwritingProtectedFile(zipFileEntry, sourceFile = new File(fileSet.getDirectory(), file), isProtected)) continue;
            overwrittenFiles.put(zipFileEntry, sourceFile);
        }
        return overwrittenFiles;
    }

    protected MavenResourcesExecution setupMavenResourcesExecution() {
        MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution();
        mavenResourcesExecution.setEncoding(this.resourceEncoding);
        mavenResourcesExecution.setEscapeString(this.escapeString);
        mavenResourcesExecution.setSupportMultiLineFiltering(this.supportMultiLineFiltering);
        mavenResourcesExecution.setMavenProject(this.project);
        mavenResourcesExecution.setDelimiters(this.delimiters, this.useDefaultDelimiters);
        if (this.nonFilteredFileExtensions != null) {
            mavenResourcesExecution.setNonFilteredFileExtensions(this.nonFilteredFileExtensions);
        }
        if (this.filterFiles == null) {
            this.filterFiles = this.project.getBuild().getFilters();
        }
        mavenResourcesExecution.setFilters(this.filterFiles);
        mavenResourcesExecution.setEscapedBackslashesInFilePath(this.escapedBackslashesInFilePath);
        mavenResourcesExecution.setMavenSession(this.session);
        mavenResourcesExecution.setEscapeString(this.escapeString);
        mavenResourcesExecution.setSupportMultiLineFiltering(this.supportMultiLineFiltering);
        mavenResourcesExecution.setAddDefaultExcludes(this.addDefaultExcludes);
        mavenResourcesExecution.setOverwrite(true);
        mavenResourcesExecution.setUseDefaultFilterWrappers(true);
        return mavenResourcesExecution;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File finalFile = this.getZipFile(this.outputDirectory, this.finalName, this.classifier);
        MavenResourcesExecution mavenResourcesExecution = this.setupMavenResourcesExecution();
        try {
            DefaultFileSet fileSet;
            ContentPackageArchiver contentPackageArchiver = new ContentPackageArchiver();
            contentPackageArchiver.setEncoding(this.resourceEncoding);
            if (this.metaInfDirectory != null) {
                if (this.metaInfDirectory.exists() && this.metaInfDirectory.isDirectory()) {
                    DefaultFileSet fileSet2 = this.createFileSet(this.metaInfDirectory, "META-INF/", Collections.singletonList("vault"));
                    this.addFileSetToArchive(mavenResourcesExecution, contentPackageArchiver, fileSet2);
                    this.getLog().info((CharSequence)("Include additional META-INF files/folders from " + this.getProjectRelativeFilePath(this.metaInfDirectory) + " in package."));
                } else {
                    this.getLog().warn((CharSequence)("Given metaInfDirectory " + this.getProjectRelativeFilePath(this.metaInfDirectory) + " does not exist or is no directory. It won't be included in the package."));
                }
            }
            File metaInfVaultDirectory = this.getMetaInfVaultSourceDirectory();
            Filters filters = this.loadGeneratedFilterFile();
            Map<String, File> embeddedFiles = this.getEmbeddedFilesMap();
            HashMap<File, File> duplicateFiles = new HashMap<File, File>();
            contentPackageArchiver.setIncludeEmptyDirs(true);
            if (metaInfVaultDirectory != null) {
                fileSet = this.createFileSet(metaInfVaultDirectory, "META-INF/vault/", Collections.singletonList("filter.xml"));
                duplicateFiles.putAll(this.getOverwrittenProtectedFiles((FileSet)fileSet, true));
                this.addFileSetToArchive(mavenResourcesExecution, contentPackageArchiver, fileSet);
            }
            fileSet = this.createFileSet(this.getWorkDirectory(false), "");
            Map<File, File> overwrittenWorkFiles = this.getOverwrittenProtectedFiles((FileSet)fileSet, true);
            for (Map.Entry<File, File> entry : overwrittenWorkFiles.entrySet()) {
                String message = "Found duplicate file '" + entry.getKey() + "' from sources " + this.getProjectRelativeFilePath(this.protectedFiles.get(entry.getKey())) + " and " + this.getProjectRelativeFilePath(entry.getValue()) + ".";
                if (STATIC_META_INF_FILES.contains(entry.getKey())) {
                    this.getLog().info((CharSequence)message);
                    continue;
                }
                this.getLog().warn((CharSequence)message);
            }
            this.addFileSetToArchive(mavenResourcesExecution, contentPackageArchiver, fileSet);
            for (Map.Entry<Object, File> entry : embeddedFiles.entrySet()) {
                this.protectedFiles.put(new File((String)entry.getKey()), entry.getValue());
                this.addFileToArchive(mavenResourcesExecution, contentPackageArchiver, entry.getValue(), (String)entry.getKey());
            }
            File jcrSourceDirectory = this.getJcrSourceDirectory();
            if (jcrSourceDirectory != null && jcrSourceDirectory.exists()) {
                Collection<File> uncoveredFiles;
                this.getLog().info((CharSequence)("Packaging content from " + this.getProjectRelativeFilePath(jcrSourceDirectory)));
                Map<File, File> map = this.addSourceDirectory(mavenResourcesExecution, contentPackageArchiver, jcrSourceDirectory, filters, embeddedFiles);
                duplicateFiles.putAll(map);
                if (!duplicateFiles.isEmpty()) {
                    for (Map.Entry entry : duplicateFiles.entrySet()) {
                        String message = "Found duplicate file '" + entry.getKey() + "' from sources " + this.getProjectRelativeFilePath(this.protectedFiles.get(entry.getKey())) + " and " + this.getProjectRelativeFilePath((File)entry.getValue()) + ".";
                        if (this.failOnDuplicateEntries) {
                            this.getLog().error((CharSequence)message);
                            continue;
                        }
                        this.getLog().warn((CharSequence)message);
                    }
                    if (this.failOnDuplicateEntries) {
                        throw new MojoFailureException("Found " + duplicateFiles.size() + " duplicate file(s) in content package, see above errors for details.");
                    }
                }
                if (!(uncoveredFiles = VaultMojo.getUncoveredFiles(jcrSourceDirectory, this.excludes, this.prefix, contentPackageArchiver.getFiles().keySet())).isEmpty()) {
                    for (File uncoveredFile : uncoveredFiles) {
                        String message = "File " + this.getProjectRelativeFilePath(uncoveredFile) + " not covered by a filter rule and therefore not contained in the resulting package";
                        if (this.failOnUncoveredSourceFiles) {
                            this.getLog().error((CharSequence)message);
                            continue;
                        }
                        this.getLog().warn((CharSequence)message);
                    }
                    if (this.failOnUncoveredSourceFiles) {
                        throw new MojoFailureException("The following files are not covered by a filter rule: \n" + StringUtils.join(uncoveredFiles.iterator(), (String)",\n"));
                    }
                }
            }
            if (!contentPackageArchiver.getFiles().containsKey("jcr_root/")) {
                contentPackageArchiver.addResource((PlexusIoResource)new PlexusIoNonExistingDirectoryResource("jcr_root"), "jcr_root", 0);
            }
            MavenArchiver mavenArchiver = new MavenArchiver();
            mavenArchiver.setArchiver((JarArchiver)contentPackageArchiver);
            mavenArchiver.setOutputFile(finalFile);
            mavenArchiver.configureReproducible(this.outputTimestamp);
            mavenArchiver.createArchive(null, this.project, this.getMavenArchiveConfiguration(this.getGeneratedManifestFile(false)));
            if (StringUtils.isNotEmpty((String)this.classifier)) {
                this.projectHelper.attachArtifact(this.project, finalFile, this.classifier);
            } else {
                Artifact projectArtifact = this.project.getArtifact();
                projectArtifact.setFile(finalFile);
                projectArtifact.setArtifactHandler(this.artifactHandlerManager.getArtifactHandler(PACKAGE_TYPE));
            }
        }
        catch (IOException | IllegalStateException | ConfigurationException | DependencyResolutionRequiredException | MavenFilteringException | ManifestException e) {
            throw new MojoExecutionException(e.toString(), (Exception)e);
        }
    }

    private File getZipFile(File basedir, String resultFinalName, String classifier) {
        if (basedir == null) {
            throw new IllegalArgumentException("basedir is not allowed to be null");
        }
        if (resultFinalName == null) {
            throw new IllegalArgumentException("finalName is not allowed to be null");
        }
        StringBuilder fileName = new StringBuilder(resultFinalName);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)classifier)) {
            fileName.append("-").append(classifier);
        }
        fileName.append(PACKAGE_EXT);
        return new File(basedir, fileName.toString());
    }

    private Map<File, File> addSourceDirectory(MavenResourcesExecution mavenResourcesExecution, ContentPackageArchiver contentPackageArchiver, File jcrSourceDirectory, Filters filters, Map<String, File> embeddedFiles) throws MavenFilteringException {
        HashMap<File, File> duplicateFiles = new HashMap<File, File>();
        List filterSets = filters.getFilterSets();
        if (filterSets.isEmpty()) {
            DefaultFileSet fileSet = this.createFileSet(jcrSourceDirectory, "jcr_root" + this.prefix);
            duplicateFiles.putAll(this.getOverwrittenProtectedFiles((FileSet)fileSet, false));
            this.addFileSetToArchive(mavenResourcesExecution, contentPackageArchiver, fileSet);
        } else {
            for (PathFilterSet filterSet : filterSets) {
                String relPath = PlatformNameFormat.getPlatformPath((String)filterSet.getRoot());
                String destPath = FileUtils.normalize((String)("jcr_root" + this.prefix + relPath));
                if (embeddedFiles.containsKey(destPath)) continue;
                File sourceFile = new File(jcrSourceDirectory, relPath + ".xml");
                if (sourceFile.isFile()) {
                    destPath = FileUtils.normalize((String)("jcr_root" + this.prefix + relPath + ".xml"));
                    if (this.isOverwritingProtectedFile(new File(destPath), sourceFile, false)) {
                        duplicateFiles.put(new File(destPath), sourceFile);
                    }
                    this.addFileToArchive(mavenResourcesExecution, contentPackageArchiver, sourceFile, destPath);
                    this.addAncestors(contentPackageArchiver, sourceFile, jcrSourceDirectory, destPath);
                    continue;
                }
                sourceFile = new File(jcrSourceDirectory, relPath);
                while (!(sourceFile.exists() && sourceFile.isDirectory() || jcrSourceDirectory.equals(sourceFile))) {
                    sourceFile = sourceFile.getParentFile();
                    relPath = StringUtils.chomp((String)relPath, (String)"/");
                }
                if (jcrSourceDirectory.equals(sourceFile)) continue;
                destPath = FileUtils.normalize((String)("jcr_root" + this.prefix + relPath));
                DefaultFileSet fileSet = this.createFileSet(sourceFile, destPath + "/");
                duplicateFiles.putAll(this.getOverwrittenProtectedFiles((FileSet)fileSet, false));
                this.addFileSetToArchive(mavenResourcesExecution, contentPackageArchiver, fileSet);
                this.addAncestors(contentPackageArchiver, sourceFile, jcrSourceDirectory, destPath);
            }
        }
        return duplicateFiles;
    }

    private void addAncestors(ContentPackageArchiver contentPackageArchiver, File inputFile, File inputRootFile, String destFile) {
        if (!inputFile.getAbsolutePath().startsWith(inputRootFile.getAbsolutePath())) {
            return;
        }
        File genericAggregate = new File(inputFile, ".content.xml");
        if (genericAggregate.exists()) {
            this.getLog().debug((CharSequence)("Adding ancestor file " + this.getProjectRelativeFilePath(genericAggregate) + " to package at '" + destFile + "/" + ".content.xml" + "'"));
            contentPackageArchiver.addFile(genericAggregate, destFile + "/" + ".content.xml");
        }
        this.addAncestors(contentPackageArchiver, inputFile.getParentFile(), inputRootFile, StringUtils.chomp((String)destFile, (String)"/"));
    }

    protected static Collection<File> getUncoveredFiles(File sourceDirectory, Collection<String> excludes, String prefix, Collection<String> coveredFileNames) {
        Collection coveredFiles = coveredFileNames.stream().map(File::new).collect(Collectors.toList());
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDirectory);
        scanner.setExcludes(excludes.toArray(new String[0]));
        scanner.addDefaultExcludes();
        scanner.scan();
        Collection allFiles = Stream.of(scanner.getIncludedFiles()).map(File::new).collect(Collectors.toList());
        return VaultMojo.getUncoveredFiles(sourceDirectory, prefix, allFiles, coveredFiles);
    }

    private static Collection<File> getUncoveredFiles(File sourceDirectory, String prefix, Collection<File> allFiles, Collection<File> coveredFiles) {
        ArrayList<File> uncoveredFiles = new ArrayList<File>();
        for (File file : allFiles) {
            if (coveredFiles.contains(new File("jcr_root" + prefix, file.getPath()))) continue;
            uncoveredFiles.add(new File(sourceDirectory, file.getPath()));
        }
        return uncoveredFiles;
    }

    private MavenArchiveConfiguration getMavenArchiveConfiguration(File manifestFile) {
        if (this.archive == null) {
            this.archive = new MavenArchiveConfiguration();
            this.archive.setAddMavenDescriptor(true);
            this.archive.setCompress(true);
            this.archive.setIndex(false);
        }
        this.archive.setManifestFile(manifestFile);
        return this.archive;
    }
}

