/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.jackrabbit.filevault.maven.packaging.PackageRestriction;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.jetbrains.annotations.NotNull;

public class ValidatorSettings
implements org.apache.jackrabbit.vault.validation.spi.ValidatorSettings,
Comparable<ValidatorSettings> {
    private Boolean isDisabled;
    private ValidationMessageSeverity defaultSeverity;
    private final Map<String, String> options = new HashMap<String, String>();
    private PackageRestriction packageRestriction;

    public ValidatorSettings merge(ValidatorSettings otherSettings) {
        ValidatorSettings mergedSettings = new ValidatorSettings();
        mergedSettings.isDisabled = this.isDisabled != null ? this.isDisabled : otherSettings.isDisabled;
        mergedSettings.defaultSeverity = this.defaultSeverity != null ? this.defaultSeverity : otherSettings.defaultSeverity;
        mergedSettings.options.putAll(this.options);
        for (Map.Entry<String, String> entry : otherSettings.getOptions().entrySet()) {
            if (this.options.containsKey(entry.getKey())) continue;
            mergedSettings.addOption(entry.getKey(), entry.getValue());
        }
        return mergedSettings;
    }

    public ValidatorSettings setDefaultSeverity(String defaultSeverity) {
        if (defaultSeverity != null) {
            this.defaultSeverity = ValidationMessageSeverity.valueOf((String)defaultSeverity.toUpperCase());
        }
        return this;
    }

    public ValidatorSettings addOption(String key, String value) {
        this.options.put(key, value);
        return this;
    }

    public ValidatorSettings setPackageRestriction(PackageRestriction packageRestriction) {
        this.packageRestriction = packageRestriction;
        return this;
    }

    @NotNull
    public ValidationMessageSeverity getDefaultSeverity() {
        return this.defaultSeverity != null ? this.defaultSeverity : ValidationMessageSeverity.ERROR;
    }

    @NotNull
    public Map<String, String> getOptions() {
        return this.options;
    }

    public boolean isDisabled() {
        return this.isDisabled != null && this.isDisabled != false;
    }

    public void setIsDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public String toString() {
        return "ValidatorSettings [isDisabled=" + this.isDisabled + ", defaultSeverity=" + this.defaultSeverity + ", options=" + this.options + "]";
    }

    public int hashCode() {
        return Objects.hash(this.defaultSeverity, this.isDisabled, this.options);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidatorSettings other = (ValidatorSettings)obj;
        return this.defaultSeverity == other.defaultSeverity && Objects.equals(this.isDisabled, other.isDisabled) && Objects.equals(this.options, other.options);
    }

    @Override
    public int compareTo(ValidatorSettings o) {
        if (this.packageRestriction == null) {
            if (o.packageRestriction == null) {
                return 0;
            }
            return 1;
        }
        if (o.packageRestriction == null) {
            return -1;
        }
        return this.packageRestriction.compareTo(o.packageRestriction);
    }

    public boolean isApplicable(PackageId packageId, boolean isSubPackage) {
        if (this.packageRestriction == null) {
            return true;
        }
        if (this.packageRestriction.name != null && !this.packageRestriction.name.equals(packageId.getName())) {
            return false;
        }
        if (this.packageRestriction.group != null && !this.packageRestriction.group.equals(packageId.getGroup())) {
            return false;
        }
        return !this.packageRestriction.subPackageOnly || isSubPackage;
    }
}

