/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.mojo;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.filevault.maven.packaging.impl.DirectoryValidationContext;
import org.apache.jackrabbit.filevault.maven.packaging.impl.ValidationMessagePrinter;
import org.apache.jackrabbit.filevault.maven.packaging.mojo.AbstractMetadataPackageMojo;
import org.apache.jackrabbit.filevault.maven.packaging.mojo.AbstractSourceAndMetadataPackageMojo;
import org.apache.jackrabbit.filevault.maven.packaging.mojo.AbstractValidateMojo;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.validation.ValidationExecutor;
import org.apache.jackrabbit.vault.validation.spi.ValidationContext;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.LifecycleNotFoundException;
import org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.Scanner;

@Mojo(name="validate-files", defaultPhase=LifecyclePhase.PROCESS_TEST_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class ValidateFilesMojo
extends AbstractValidateMojo {
    @Parameter(property="vault.metaInfVaultDirectory", required=true, defaultValue="${project.basedir}/META-INF/vault,${project.basedir}/src/main/META-INF/vault,${project.basedir}/src/main/content/META-INF/vault,${project.basedir}/src/content/META-INF/vault")
    File[] metaInfVaultDirectory;
    @Parameter(defaultValue="${project.build.directory}/vault-work", required=true)
    File workDirectory;
    @Parameter(property="vault.classifier")
    protected String classifier = "";
    @Deprecated
    @Parameter
    private File builtContentDirectory;
    @Parameter(property="vault.jcrRootSourceDirectory", required=true, defaultValue="${project.basedir}/jcr_root,${project.basedir}/src/main/jcr_root,${project.basedir}/src/main/content/jcr_root,${project.basedir}/src/content/jcr_root,${project.build.outputDirectory}")
    private File[] jcrRootSourceDirectory;
    @Parameter(property="vault.excludes", defaultValue="**/.vlt,**/.vltignore,**/.gitignore,**/.gitattributes", required=true)
    protected String[] excludes;
    @Parameter(defaultValue="true")
    protected boolean addDefaultExcludes;
    @Component
    protected LifecycleExecutor lifecycleExecutor;
    private static final String PLUGIN_KEY = "org.apache.jackrabbit:filevault-package-maven-plugin";

    @Override
    protected boolean shouldSkip() {
        List<String> allGoals;
        if (this.session != null) {
            allGoals = this.session.getGoals();
            this.getLog().debug((CharSequence)("Following goals are detected: " + StringUtils.join(allGoals, (String)", ")));
        } else {
            this.getLog().debug((CharSequence)"MavenSession not available. Maybe executed by m2e.");
            allGoals = Collections.emptyList();
        }
        try {
            if (!this.buildContext.isIncremental() && this.isMojoGoalExecuted(this.lifecycleExecutor, "validate-package", allGoals.toArray(new String[0]))) {
                this.getLog().info((CharSequence)"Skip this goal as this is not an incremental build and 'validate-package' is executed later on!");
                return true;
            }
        }
        catch (LifecycleNotFoundException | LifecyclePhaseNotFoundException | InvalidPluginDescriptorException | MojoNotFoundException | PluginDescriptorParsingException | PluginManagerException | PluginNotFoundException | PluginResolutionException | NoPluginFoundForPrefixException | PluginVersionResolutionException e1) {
            this.getLog().warn((CharSequence)"Could not determine plugin executions", e1);
        }
        return false;
    }

    @Override
    public void doExecute(ValidationMessagePrinter validationHelper) throws MojoExecutionException, MojoFailureException {
        try {
            File metaInfoVaultSourceDirectory = AbstractMetadataPackageMojo.getMetaInfVaultSourceDirectory(this.metaInfVaultDirectory, this.getLog());
            File metaInfRootDirectory = null;
            if (metaInfoVaultSourceDirectory != null) {
                metaInfRootDirectory = metaInfoVaultSourceDirectory.getParentFile();
            }
            File generatedMetaInfRootDirectory = new File(AbstractMetadataPackageMojo.getWorkDirectory(this.getLog(), false, this.workDirectory, this.classifier), "META-INF");
            this.getLog().info((CharSequence)("Validate files in generatedMetaInfRootDirectory " + this.getProjectRelativeFilePath(generatedMetaInfRootDirectory.toPath()) + " and metaInfRootDir " + this.getProjectRelativeFilePath(generatedMetaInfRootDirectory.toPath())));
            File jcrSourceDirectory = AbstractSourceAndMetadataPackageMojo.getJcrSourceDirectory(this.jcrRootSourceDirectory, this.builtContentDirectory, this.getLog());
            Path packageRootDirectory = jcrSourceDirectory == null ? this.jcrRootSourceDirectory[0].toPath().getParent() : jcrSourceDirectory.getParentFile().toPath();
            DirectoryValidationContext context = new DirectoryValidationContext(this.buildContext.isIncremental(), generatedMetaInfRootDirectory.toPath(), metaInfRootDirectory != null ? metaInfRootDirectory.toPath() : null, packageRootDirectory, this.resolver, this.getLog());
            ValidationExecutor executor = this.validationExecutorFactory.createValidationExecutor((ValidationContext)context, false, false, this.getEffectiveValidatorSettingsForPackage(context.getProperties().getId(), false));
            if (executor == null) {
                throw new MojoExecutionException("No registered validators found!");
            }
            validationHelper.printUsedValidators(this.getLog(), executor, context, true);
            if (metaInfRootDirectory != null) {
                this.validateDirectoryRecursively(validationHelper, executor, metaInfRootDirectory.toPath(), true);
            }
            this.validateDirectoryRecursively(validationHelper, executor, generatedMetaInfRootDirectory.toPath(), true);
            if (jcrSourceDirectory != null) {
                this.validateDirectoryRecursively(validationHelper, executor, jcrSourceDirectory.toPath(), false);
            }
            validationHelper.printMessages(executor.done(), this.buildContext, this.project.getBasedir().toPath());
        }
        catch (IOException | ConfigurationException e) {
            throw new MojoFailureException("Could not execute validation", e);
        }
        validationHelper.failBuildInCaseOfViolations(this.failOnValidationWarnings);
    }

    private void validateDirectoryRecursively(ValidationMessagePrinter validationHelper, ValidationExecutor executor, Path baseDir, boolean isMetaInf) {
        Scanner scanner = this.buildContext.newScanner(baseDir.toFile());
        scanner.setExcludes(this.excludes);
        if (this.addDefaultExcludes) {
            scanner.addDefaultExcludes();
        }
        scanner.scan();
        this.getLog().info((CharSequence)("Scanning baseDir " + this.getProjectRelativeFilePath(baseDir) + "..."));
        SortedSet<Path> sortedFileAndFolderNames = ValidateFilesMojo.sortAndEnrichFilesAndDirectories(baseDir, scanner.getIncludedFiles(), scanner.getIncludedDirectories());
        for (Path fileOrFolder : sortedFileAndFolderNames) {
            this.getLog().info((CharSequence)("Scanning path " + this.getProjectRelativeFilePath(baseDir.resolve(fileOrFolder)) + "..."));
            if (Files.isDirectory(baseDir.resolve(fileOrFolder), new LinkOption[0])) {
                this.validateDirectory(validationHelper, executor, baseDir, isMetaInf, fileOrFolder);
                continue;
            }
            this.validateFile(validationHelper, executor, baseDir, isMetaInf, fileOrFolder);
        }
    }

    static SortedSet<Path> sortAndEnrichFilesAndDirectories(Path baseDir, String[] files, String[] directories) {
        TreeSet<Path> paths = new TreeSet<Path>(new ParentAndDotContentXmlFirstComparator());
        for (String file : files) {
            paths.add(Paths.get(file, new String[0]));
        }
        for (String directory : directories) {
            paths.add(Paths.get(directory, new String[0]));
        }
        Iterator pathIterator = paths.descendingIterator();
        HashSet<Path> additionalPaths = new HashSet<Path>();
        while (pathIterator.hasNext()) {
            Path extendedFileAggregateContentXml;
            Path parentContentXml;
            Path path = (Path)pathIterator.next();
            Path parent = path.getParent();
            if (parent == null) continue;
            if (!paths.contains(parent) && !additionalPaths.contains(parent) && Files.isDirectory(baseDir.resolve(parent), new LinkOption[0])) {
                additionalPaths.add(parent);
            }
            if (!paths.contains(parentContentXml = parent.resolve(".content.xml")) && !additionalPaths.contains(parentContentXml) && Files.exists(baseDir.resolve(parentContentXml), new LinkOption[0])) {
                additionalPaths.add(parentContentXml);
            }
            if (paths.contains(extendedFileAggregateContentXml = parent.resolve(path.getFileName().toString() + ".dir").resolve(".content.xml")) || additionalPaths.contains(extendedFileAggregateContentXml) || !Files.exists(baseDir.resolve(extendedFileAggregateContentXml), new LinkOption[0])) continue;
            additionalPaths.add(parentContentXml);
        }
        paths.addAll(additionalPaths);
        return paths;
    }

    private void validateFile(ValidationMessagePrinter validationHelper, ValidationExecutor executor, Path baseDir, boolean isMetaInf, Path relativeFile) {
        Path absoluteFile = baseDir.resolve(relativeFile);
        validationHelper.clearPreviousValidationMessages(this.buildContext, absoluteFile.toFile());
        this.getLog().debug((CharSequence)("Validating file " + this.getProjectRelativeFilePath(absoluteFile) + "..."));
        try (InputStream input = Files.newInputStream(absoluteFile, new OpenOption[0]);){
            this.validateInputStream(validationHelper, executor, input, baseDir, isMetaInf, relativeFile);
        }
        catch (FileNotFoundException e) {
            this.getLog().error((CharSequence)("Could not find file " + this.getProjectRelativeFilePath(absoluteFile)), (Throwable)e);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Could not validate file " + this.getProjectRelativeFilePath(absoluteFile)), (Throwable)e);
        }
    }

    private void validateDirectory(ValidationMessagePrinter validationHelper, ValidationExecutor executor, Path baseDir, boolean isMetaInf, Path relativeFolder) {
        Path absoluteFolder = baseDir.resolve(relativeFolder);
        validationHelper.clearPreviousValidationMessages(this.buildContext, absoluteFolder.toFile());
        this.getLog().debug((CharSequence)("Validating directory " + this.getProjectRelativeFilePath(absoluteFolder) + "..."));
        try {
            this.validateInputStream(validationHelper, executor, null, baseDir, isMetaInf, relativeFolder);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Could not validate directory " + this.getProjectRelativeFilePath(absoluteFolder)), (Throwable)e);
        }
    }

    private void validateInputStream(ValidationMessagePrinter validationHelper, ValidationExecutor executor, InputStream input, Path baseDir, boolean isMetaInf, Path relativeFile) throws IOException {
        Collection messages = isMetaInf ? executor.validateMetaInf(input, relativeFile, baseDir) : executor.validateJcrRoot(input, relativeFile, baseDir);
        validationHelper.printMessages(messages, this.buildContext, this.project.getBasedir().toPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMojoGoalExecuted(LifecycleExecutor lifecycleExecutor, String mojoGoal, String ... goals) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginManagerException {
        if (goals.length == 0) {
            return false;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            MavenExecutionPlan executionPlan = lifecycleExecutor.calculateExecutionPlan(this.session, goals);
            for (MojoExecution mojoExecution : executionPlan.getMojoExecutions()) {
                if (ValidateFilesMojo.isMojoGoalExecuted(mojoExecution, mojoGoal)) {
                    boolean bl = true;
                    return bl;
                }
                lifecycleExecutor.calculateForkedExecutions(mojoExecution, this.session);
                if (!mojoExecution.getForkedExecutions().values().stream().flatMap(Collection::stream).anyMatch(t -> ValidateFilesMojo.isMojoGoalExecuted(t, mojoGoal))) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private static boolean isMojoGoalExecuted(MojoExecution mojoExecution, String mojoGoal) {
        return PLUGIN_KEY.equals(mojoExecution.getPlugin().getKey()) && mojoGoal.equals(mojoExecution.getGoal());
    }

    static final class ParentAndDotContentXmlFirstComparator
    implements Comparator<Path> {
        private final AbstractValidateMojo.DotContentXmlFirstComparator dotXmlFirstComparator = new AbstractValidateMojo.DotContentXmlFirstComparator();

        @Override
        public int compare(Path s1, Path s2) {
            if (s1.getNameCount() < s2.getNameCount()) {
                return -1;
            }
            if (s1.getNameCount() > s2.getNameCount()) {
                return 1;
            }
            if (s1.getParent() != null && s1.getParent().equals(s2.getParent())) {
                return this.dotXmlFirstComparator.compare(s1.getFileName().toString(), s2.getFileName().toString());
            }
            return s1.compareTo(s2);
        }
    }
}

