/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.impl;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.filevault.maven.packaging.mojo.AbstractValidateMojo;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.PackageInfo;
import org.apache.jackrabbit.vault.packaging.VersionRange;
import org.apache.jackrabbit.vault.packaging.impl.DefaultPackageInfo;
import org.apache.jackrabbit.vault.validation.context.AbstractDependencyResolver;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.version.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyResolver
extends AbstractDependencyResolver {
    private final RepositorySystemSession repositorySession;
    private final RepositorySystem repositorySystem;
    private final Log log;
    private final Map<Dependency, Artifact> mapPackageDependencyToMavenArtifact;
    private final List<RemoteRepository> repositories;

    public DependencyResolver(RepositorySystemSession repositorySession, RepositorySystem repositorySystem, List<RemoteRepository> repositories, Map<Dependency, Artifact> mapPackageDependencyToMavenArtifact, Collection<PackageInfo> knownPackageInfos, Log log) {
        this.repositorySession = repositorySession;
        this.repositorySystem = repositorySystem;
        this.repositories = repositories;
        this.mapPackageDependencyToMavenArtifact = mapPackageDependencyToMavenArtifact;
        this.log = log;
    }

    public PackageInfo resolvePackageInfo(@NotNull AbstractDependencyResolver.MavenCoordinates mavenCoordinates) throws IOException {
        DefaultArtifact artifact = new DefaultArtifact(mavenCoordinates.getGroupId(), mavenCoordinates.getArtifactId(), mavenCoordinates.getClassifier(), mavenCoordinates.getPackaging(), mavenCoordinates.getVersion());
        return this.resolvePackageInfo((Artifact)artifact);
    }

    @Nullable
    private File resolve(Artifact artifact, Log log) {
        ArtifactRequest request = new ArtifactRequest(artifact, this.repositories, null);
        try {
            ArtifactResult result = this.repositorySystem.resolveArtifact(this.repositorySession, request);
            log.debug((CharSequence)("Successfully resolved artifact " + artifact.getArtifactId()));
            return result.getArtifact().getFile();
        }
        catch (ArtifactResolutionException e) {
            log.warn((CharSequence)("Could not resolve artifact '" + artifact + "': " + e.getMessage()));
            return null;
        }
    }

    @Nullable
    protected PackageInfo resolvePackageInfo(@NotNull Dependency dependency) throws IOException {
        Artifact artifact = this.mapPackageDependencyToMavenArtifact.get(new Dependency(dependency.getGroup(), dependency.getName(), null));
        if (artifact == AbstractValidateMojo.IGNORE_ARTIFACT) {
            this.log.info((CharSequence)("Ignoring package dependency '" + dependency + "' as it is marked to be ignored."));
            return null;
        }
        if (artifact == null) {
            artifact = new DefaultArtifact(dependency.getGroup(), dependency.getName(), "zip", null);
        }
        this.log.info((CharSequence)("Trying to resolve package dependency '" + dependency + "' from Maven artifact '" + artifact + "'"));
        String version = this.resolveVersion(artifact, dependency.getRange());
        if (version == null) {
            return null;
        }
        PackageInfo info = this.resolvePackageInfo(artifact = artifact.setVersion(version));
        if (info == null) {
            this.log.warn((CharSequence)("Could not resolve Maven artifact '" + artifact + "' in any repository"));
            return null;
        }
        return info;
    }

    private String resolveVersion(Artifact artifact, VersionRange dependencyVersionRange) {
        block6: {
            if (VersionRange.INFINITE.equals((Object)dependencyVersionRange)) {
                VersionRequest request = new VersionRequest(artifact.setVersion("LATEST"), this.repositories, null);
                try {
                    return this.repositorySystem.resolveVersion(this.repositorySession, request).getVersion();
                }
                catch (Exception e) {
                    this.log.warn((CharSequence)("Could not resolve version for artifact '" + artifact + "': " + e.getMessage()));
                    break block6;
                }
            }
            VersionRangeRequest request = new VersionRangeRequest(artifact.setVersion(DependencyResolver.convertToMavenVersionRange(dependencyVersionRange)), this.repositories, null);
            try {
                Version highestVersion = this.repositorySystem.resolveVersionRange(this.repositorySession, request).getHighestVersion();
                if (highestVersion != null) {
                    return highestVersion.toString();
                }
            }
            catch (Exception e) {
                this.log.warn((CharSequence)("Could not resolve version range for artifact '" + artifact + "': " + e.getMessage()));
            }
        }
        return null;
    }

    static String convertToMavenVersionRange(VersionRange packageVersionRange) {
        if (packageVersionRange.getLow() == null && packageVersionRange.getHigh() == null) {
            throw new IllegalArgumentException("Cannot convert infinite version range to Maven version range");
        }
        StringBuilder versionRange = new StringBuilder();
        versionRange.append(packageVersionRange.isLowInclusive() ? "[" : "(");
        if (packageVersionRange.getLow() != null) {
            versionRange.append(packageVersionRange.getLow());
        }
        versionRange.append(",");
        if (packageVersionRange.getHigh() != null) {
            versionRange.append(packageVersionRange.getHigh());
        }
        versionRange.append(packageVersionRange.isHighInclusive() ? "]" : ")");
        return versionRange.toString();
    }

    @Nullable
    protected PackageInfo resolvePackageInfo(Artifact artifact) throws IOException {
        File file = this.resolve(artifact, this.log);
        if (file != null) {
            return DefaultPackageInfo.read((File)file);
        }
        return null;
    }
}

