/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.mojo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.jackrabbit.filevault.maven.packaging.Embedded;
import org.apache.jackrabbit.filevault.maven.packaging.mojo.AbstractMetadataPackageMojo;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.animal_sniffer.ClassListBuilder;
import org.codehaus.mojo.animal_sniffer.SignatureChecker;
import org.codehaus.mojo.animal_sniffer.logging.Logger;
import org.codehaus.mojo.animal_sniffer.maven.MavenLogger;
import org.codehaus.mojo.animal_sniffer.maven.Signature;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="check-signature", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class CheckSignatureMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter
    private Embedded[] embeddeds = new Embedded[0];
    @Parameter(property="vault.failOnMissingEmbed", defaultValue="false", required=true)
    private boolean failOnMissingEmbed;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repositories;
    @Parameter(property="project.compileClasspathElements", required=true, readonly=true)
    private List<String> classpathElements;
    @Parameter
    private String[] ignores;
    @Parameter
    private Signature signature;
    @Parameter(property="vault.checksignature.skip", defaultValue="false")
    private boolean skipCheckSignature;
    private final RepositorySystem repoSystem;

    @Inject
    public CheckSignatureMojo(RepositorySystem repoSystem) {
        this.repoSystem = repoSystem;
    }

    private Set<String> buildPackageList() throws IOException {
        ClassListBuilder plb = new ClassListBuilder((Logger)new MavenLogger(this.getLog()));
        for (String classpathElement : this.classpathElements) {
            plb.process(new File(classpathElement));
        }
        return plb.getPackages();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipCheckSignature) {
            this.getLog().info((CharSequence)"Skipping signature check.");
            return;
        }
        if (this.signature == null) {
            this.getLog().info((CharSequence)"No signature defined. Skipping signature check.");
            return;
        }
        try {
            this.getLog().info((CharSequence)("Checking unresolved references to " + this.signature));
            DefaultArtifact artifact = new DefaultArtifact(this.signature.getGroupId(), this.signature.getArtifactId(), "signature", this.signature.getVersion());
            File signatureFile = AbstractMetadataPackageMojo.resolveArtifact((Artifact)artifact, this.repoSystem, this.repoSession, this.repositories);
            Set<String> ignoredPackages = this.buildPackageList();
            if (this.ignores != null) {
                for (String ignore : this.ignores) {
                    if (ignore == null) continue;
                    ignoredPackages.add(ignore.replace('.', '/'));
                }
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)ignoredPackages.toString());
            }
            try (FileInputStream signatureInput = new FileInputStream(signatureFile);){
                SignatureChecker signatureChecker = new SignatureChecker((InputStream)signatureInput, ignoredPackages, (Logger)new MavenLogger(this.getLog()));
                signatureChecker.setCheckJars(true);
                signatureChecker.setSourcePath(Collections.singletonList(new File(this.project.getBuild().getSourceDirectory())));
                signatureChecker.process(this.getEmbeddeds().toArray(new File[0]));
                if (signatureChecker.isSignatureBroken()) {
                    throw new MojoFailureException("Signature errors found. Verify them and put @IgnoreJRERequirement on them.");
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to check signatures", (Exception)e);
        }
    }

    private Collection<File> getEmbeddeds() throws MojoFailureException {
        HashSet<File> files = new HashSet<File>();
        for (Embedded emb : this.embeddeds) {
            Collection<org.apache.maven.artifact.Artifact> artifacts = emb.getMatchingArtifacts(this.project);
            if (artifacts.isEmpty()) {
                if (this.failOnMissingEmbed) {
                    throw new MojoFailureException("Embedded artifact specified " + emb + ", but no matching dependency artifact found. Add the missing dependency or fix the embed definition.");
                }
                this.getLog().warn((CharSequence)("No matching artifacts for " + emb));
                continue;
            }
            for (org.apache.maven.artifact.Artifact artifact : artifacts) {
                File source = artifact.getFile();
                files.add(source);
            }
        }
        return files;
    }
}

