/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.aws.ext;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    public static final String DEFAULT_CONFIG_FILE = "aws.properties";
    private static final String DELETE_CONFIG_SUFFIX = ";burn";
    public static final String DEFAULT_AWS_BUCKET_REGION = "us-standard";
    public static final String AWSDOTCOM = "amazonaws.com";
    public static final String S3 = "s3";
    public static final String DOT = ".";
    public static final String DASH = "-";

    private Utils() {
    }

    public static AmazonS3Client openService(Properties prop) {
        String accessKey = prop.getProperty("accessKey");
        String secretKey = prop.getProperty("secretKey");
        AmazonS3Client s3service = null;
        if (StringUtils.isNullOrEmpty((String)accessKey) || StringUtils.isNullOrEmpty((String)secretKey)) {
            LOG.info("Configuring Amazon Client from environment");
            s3service = new AmazonS3Client(Utils.getClientConfiguration(prop));
        } else {
            LOG.info("Configuring Amazon Client from property file.");
            BasicAWSCredentials credentials = new BasicAWSCredentials(accessKey, secretKey);
            s3service = new AmazonS3Client((AWSCredentials)credentials, Utils.getClientConfiguration(prop));
        }
        String region = prop.getProperty("s3Region");
        Object endpoint = null;
        String propEndPoint = prop.getProperty("s3EndPoint");
        if (propEndPoint != null && !"".equals(propEndPoint)) {
            endpoint = propEndPoint;
        } else {
            if (StringUtils.isNullOrEmpty((String)region)) {
                Region s3Region = Regions.getCurrentRegion();
                if (s3Region != null) {
                    region = s3Region.getName();
                } else {
                    throw new AmazonClientException("parameter [s3Region] not configured and cannot be derived from environment");
                }
            }
            endpoint = DEFAULT_AWS_BUCKET_REGION.equals(region) ? "s3.amazonaws.com" : (com.amazonaws.services.s3.model.Region.EU_Ireland.toString().equals(region) ? "s3-eu-west-1.amazonaws.com" : "s3-" + region + ".amazonaws.com");
        }
        s3service.setEndpoint((String)endpoint);
        LOG.info("S3 service endpoint [{}] ", endpoint);
        s3service.setS3ClientOptions(Utils.getS3ClientOptions(prop));
        return s3service;
    }

    public static void deleteBucket(String bucketName) throws IOException {
        Properties prop = Utils.readConfig(DEFAULT_CONFIG_FILE);
        AmazonS3Client s3service = Utils.openService(prop);
        ObjectListing prevObjectListing = s3service.listObjects(bucketName);
        while (true) {
            for (S3ObjectSummary s3ObjSumm : prevObjectListing.getObjectSummaries()) {
                s3service.deleteObject(bucketName, s3ObjSumm.getKey());
            }
            if (!prevObjectListing.isTruncated()) break;
            prevObjectListing = s3service.listNextBatchOfObjects(prevObjectListing);
        }
        s3service.deleteBucket(bucketName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readConfig(String fileName) throws IOException {
        boolean delete = false;
        if (fileName.endsWith(DELETE_CONFIG_SUFFIX)) {
            delete = true;
            fileName = fileName.substring(0, fileName.length() - DELETE_CONFIG_SUFFIX.length());
        }
        if (!new File(fileName).exists()) {
            throw new IOException("Config file not found: " + fileName);
        }
        Properties prop = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(fileName);
            prop.load(in);
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (delete) {
                Utils.deleteIfPossible(new File(fileName));
            }
        }
        return prop;
    }

    private static void deleteIfPossible(File file) {
        boolean deleted = file.delete();
        if (!deleted) {
            LOG.warn("Could not delete " + file.getAbsolutePath());
        }
    }

    private static ClientConfiguration getClientConfiguration(Properties prop) {
        int connectionTimeOut = Integer.parseInt(prop.getProperty("connectionTimeout"));
        int socketTimeOut = Integer.parseInt(prop.getProperty("socketTimeout"));
        int maxConnections = Integer.parseInt(prop.getProperty("maxConnections"));
        int maxErrorRetry = Integer.parseInt(prop.getProperty("maxErrorRetry"));
        String protocol = prop.getProperty("s3ConnProtocol");
        String proxyHost = prop.getProperty("proxyHost");
        String proxyPort = prop.getProperty("proxyPort");
        ClientConfiguration cc = new ClientConfiguration();
        if (protocol != null && protocol.equalsIgnoreCase("http")) {
            cc.setProtocol(Protocol.HTTP);
        }
        if (proxyHost != null && !proxyHost.isEmpty()) {
            cc.setProxyHost(proxyHost);
        }
        if (proxyPort != null && !proxyPort.isEmpty()) {
            cc.setProxyPort(Integer.parseInt(proxyPort));
        }
        cc.setConnectionTimeout(connectionTimeOut);
        cc.setSocketTimeout(socketTimeOut);
        cc.setMaxConnections(maxConnections);
        cc.setMaxErrorRetry(maxErrorRetry);
        return cc;
    }

    private static S3ClientOptions getS3ClientOptions(Properties prop) {
        boolean pathStyleAccess = Boolean.parseBoolean(prop.getProperty("pathStyleAccess"));
        return S3ClientOptions.builder().setPathStyleAccess(pathStyleAccess).build();
    }
}

