/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.jar.Manifest;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.classloader.ClassPathEntry;
import org.apache.jackrabbit.classloader.Util;
import org.apache.jackrabbit.net.URLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClassLoaderResource {
    private static final Logger log = LoggerFactory.getLogger((Class)ClassLoaderResource.class);
    private final ClassPathEntry pathEntry;
    private final String name;
    private final Property resProperty;
    private Class loadedClass;
    private final long loadTime;
    private boolean expired;

    ClassLoaderResource(ClassPathEntry pathEntry, String name, Property resProperty) {
        this.pathEntry = pathEntry;
        this.name = name;
        this.resProperty = resProperty;
        this.loadTime = System.currentTimeMillis();
    }

    protected ClassPathEntry getClassPathEntry() {
        return this.pathEntry;
    }

    public String getName() {
        return this.name;
    }

    protected Property getProperty() {
        return this.resProperty;
    }

    protected long getLoadTime() {
        return this.loadTime;
    }

    public URL getURL() {
        try {
            return URLFactory.createURL(this.getClassPathEntry().session, this.getPath());
        }
        catch (Exception e) {
            log.warn("getURL: Cannot getURL for " + this.getPath(), (Throwable)e);
            return null;
        }
    }

    public URL getCodeSourceURL() {
        return this.getClassPathEntry().toURL();
    }

    public InputStream getInputStream() throws RepositoryException {
        return this.getProperty() != null ? this.getProperty().getStream() : null;
    }

    public int getContentLength() throws RepositoryException {
        return this.getProperty() != null ? (int)this.getProperty().getLength() : -1;
    }

    public String getPath() {
        if (this.getProperty() != null) {
            try {
                return this.getProperty().getPath();
            }
            catch (RepositoryException re) {
                log.warn("getPath: Cannot retrieve path of entry " + this.getName(), (Throwable)re);
            }
        }
        return this.getSafePath();
    }

    protected String getSafePath() {
        return this.getClassPathEntry().getPath() + this.getName();
    }

    public long getLastModificationTime() {
        if (this.getProperty() != null) {
            try {
                return Util.getLastModificationTime(this.getProperty());
            }
            catch (RepositoryException re) {
                log.info("getLastModificationTime of resource property", (Throwable)re);
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() throws IOException, RepositoryException {
        InputStream in = null;
        byte[] buf = null;
        log.debug("getBytes");
        try {
            int length;
            in = this.getInputStream();
            log.debug("getInputStream() returned {}", (Object)in);
            log.debug("getContentLength() returned {}", (Object)new Integer(length));
            if (length >= 0) {
                int read;
                buf = new byte[length];
                for (length = this.getContentLength(); length > 0; length -= read) {
                    read = in.read(buf, buf.length - length, length);
                    if (read != -1) continue;
                    throw new IOException("unexpected EOF");
                }
            } else {
                byte[] buf1;
                int read;
                buf = new byte[1024];
                int count = 0;
                while ((read = in.read(buf, count, buf.length - count)) != -1) {
                    if ((count += read) < buf.length) continue;
                    buf1 = new byte[count * 2];
                    System.arraycopy(buf, 0, buf1, 0, count);
                    buf = buf1;
                }
                if (count != buf.length) {
                    buf1 = new byte[count];
                    System.arraycopy(buf, 0, buf1, 0, count);
                    buf = buf1;
                }
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buf;
    }

    public Manifest getManifest() {
        return null;
    }

    public Certificate[] getCertificates() {
        return null;
    }

    protected Property getExpiryProperty() {
        return this.getProperty();
    }

    public boolean isExpired() {
        if (!this.expired) {
            long loadTime;
            long currentPropTime = 0L;
            Property prop = this.getExpiryProperty();
            if (prop != null) {
                try {
                    currentPropTime = Util.getLastModificationTime(prop);
                }
                catch (RepositoryException re) {
                    log.debug("expireResource: Cannot get current version for " + this.toString() + ", will expire", (Throwable)re);
                    currentPropTime = System.currentTimeMillis();
                }
            }
            boolean bl = this.expired = currentPropTime > (loadTime = this.getLoadTime());
            if (this.expired && log.isDebugEnabled()) {
                log.debug("expireResource: Resource created {} superceded by version created {}", (Object)new Date(loadTime), (Object)new Date(currentPropTime));
            }
        }
        return this.expired;
    }

    public Class getLoadedClass() {
        return this.loadedClass;
    }

    public void setLoadedClass(Class loadedClass) {
        this.loadedClass = loadedClass;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        buf.append(": path=");
        buf.append(this.getSafePath());
        buf.append(", name=");
        buf.append(this.getName());
        return buf.toString();
    }
}

