/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.jar.JarException;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.classloader.ArchiveClassPathEntry;
import org.apache.jackrabbit.classloader.ClassLoaderResource;
import org.apache.jackrabbit.classloader.DirectoryClassPathEntry;
import org.apache.jackrabbit.classloader.ExpandingArchiveClassPathEntry;
import org.apache.jackrabbit.classloader.Util;
import org.apache.jackrabbit.net.URLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ClassPathEntry {
    private static final Logger log = LoggerFactory.getLogger((Class)ClassPathEntry.class);
    protected final Session session;
    protected final String path;
    protected URL baseURL;

    protected ClassPathEntry(Session session, String path) {
        this.path = path;
        this.session = session;
    }

    protected ClassPathEntry(ClassPathEntry base) {
        this.path = base.path;
        this.session = base.session;
        this.baseURL = base.baseURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ClassPathEntry getInstance(Session session, String path) {
        try {
            session.checkPermission(path, "read");
        }
        catch (AccessControlException ace) {
            log.warn("getInstance: Access denied reading from {}, ignoring entry", (Object)path);
            return null;
        }
        catch (RepositoryException re) {
            log.error("getInstance: Cannot check permission to " + path, (Throwable)re);
        }
        if (path.endsWith("/")) return new DirectoryClassPathEntry(session, path);
        InputStream is = null;
        ZipInputStream zip = null;
        try {
            Property prop = Util.getProperty(session.getItem(path));
            if (prop != null) {
                is = prop.getStream();
                zip = new JarInputStream(is);
                if (((JarInputStream)zip).getNextJarEntry() != null) {
                    if (ExpandingArchiveClassPathEntry.canExpandArchives(session)) {
                        ExpandingArchiveClassPathEntry expandingArchiveClassPathEntry = new ExpandingArchiveClassPathEntry(prop, path);
                        return expandingArchiveClassPathEntry;
                    }
                    ArchiveClassPathEntry archiveClassPathEntry = new ArchiveClassPathEntry(prop, path);
                    return archiveClassPathEntry;
                }
                log.debug("getInstance: {} might not be a jar archive, using as directory", (Object)path);
            } else {
                log.debug("getInstance: {} does not resolve to a property, using as directory", (Object)path);
            }
        }
        catch (ItemNotFoundException infe) {
        }
        catch (PathNotFoundException pnfe) {
        }
        catch (RepositoryException re) {
            log.debug("getInstance: {} cannot be read from, using as directory", (Object)path);
        }
        catch (JarException ze) {
            log.debug("getInstance: {} does not contain an archive, using as directory", (Object)path);
        }
        catch (IOException ioe) {
            log.debug("getInstance: {} problem reading from the archive, using as directory", (Object)path);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException ignored) {}
            } else if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignored) {}
            }
        }
        path = path + "/";
        return new DirectoryClassPathEntry(session, path);
    }

    public String getPath() {
        return this.path;
    }

    public URL toURL() {
        if (this.baseURL == null) {
            try {
                this.baseURL = URLFactory.createURL(this.session, this.path);
            }
            catch (MalformedURLException mue) {
                log.warn("DirectoryClassPathEntry: Creating baseURl for " + this.path, (Throwable)mue);
            }
        }
        return this.baseURL;
    }

    abstract ClassPathEntry copy();

    public abstract ClassLoaderResource getResource(String var1);

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append(": path: ");
        buf.append(this.path);
        buf.append(", user: ");
        buf.append(this.session.getUserID());
        return buf.toString();
    }
}

