/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.classloader;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.api.JackrabbitNodeTypeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeTypeSupport {
    private static final Logger log = LoggerFactory.getLogger((Class)NodeTypeSupport.class);
    private static final String TYPE_FILE = "type.cnd";

    NodeTypeSupport() {
    }

    static boolean registerNodeType(Workspace workspace) {
        InputStream ins = NodeTypeSupport.class.getResourceAsStream(TYPE_FILE);
        if (ins == null) {
            log.error("Node type definition file type.cnd not in class path. Cannot define required node type");
            return false;
        }
        try {
            NodeTypeManager ntm = workspace.getNodeTypeManager();
            if (ntm instanceof JackrabbitNodeTypeManager) {
                log.debug("Using Jackrabbit to import node types from type.cnd");
                JackrabbitNodeTypeManager jntm = (JackrabbitNodeTypeManager)ntm;
                jntm.registerNodeTypes(ins, "text/x-jcr-cnd");
                return true;
            }
        }
        catch (IOException ioe) {
            log.error("Cannot register node types from type.cnd", (Throwable)ioe);
        }
        catch (RepositoryException re) {
            log.error("Cannot register node types from type.cnd", (Throwable)re);
        }
        log.warn("Repository is not a Jackrabbit, cannot import node types");
        return false;
    }
}

