/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.classloader;

import java.beans.Introspector;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.classloader.ClassLoaderResource;
import org.apache.jackrabbit.classloader.ClassPathEntry;
import org.apache.jackrabbit.classloader.DynamicPatternPath;
import org.apache.jackrabbit.classloader.PatternPath;
import org.apache.jackrabbit.net.JCRURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger((Class)RepositoryClassLoader.class);
    private static final URL[] NULL_PATH = new URL[0];
    static final ClassLoaderResource NOT_FOUND_RESOURCE = new ClassLoaderResource(null, "[sentinel]", null){

        public boolean isExpired() {
            return false;
        }
    };
    private ClassPathEntry[] repository;
    private PatternPath handles;
    private Session session;
    private Map cache;
    private boolean destroyed;

    public RepositoryClassLoader(Session session, String[] classPath, ClassLoader parent) {
        this(session, new DynamicPatternPath(session, classPath), parent);
    }

    RepositoryClassLoader(Session session, PatternPath handles, ClassLoader parent) {
        super(NULL_PATH, parent);
        if (session == null) {
            throw new NullPointerException("session");
        }
        if (handles == null) {
            throw new NullPointerException("handles");
        }
        this.session = session;
        this.setHandles(handles);
        this.cache = new HashMap();
        this.destroyed = false;
        this.buildRepository();
        log.debug("RepositoryClassLoader: {} ready", (Object)this);
    }

    protected boolean isDestroyed() {
        return this.destroyed;
    }

    public void destroy() {
        if (this.isDestroyed()) {
            log.debug("Instance is already destroyed");
            return;
        }
        this.destroyed = true;
        this.setRepository(null);
        this.setHandles(null);
        this.session = null;
        if (this.cache != null) {
            Iterator ci = this.cache.values().iterator();
            while (ci.hasNext()) {
                ClassLoaderResource res = (ClassLoaderResource)ci.next();
                if (res.getLoadedClass() != null) {
                    Introspector.flushFromCaches(res.getLoadedClass());
                    res.setLoadedClass(null);
                }
                ci.remove();
            }
        }
    }

    protected Class findClass(final String name) throws ClassNotFoundException {
        if (this.isDestroyed()) {
            throw new ClassNotFoundException(name + " (Classloader destroyed)");
        }
        log.debug("findClass: Try to find class {}", (Object)name);
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return RepositoryClassLoader.this.findClassPrivileged(name);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (ClassNotFoundException)pae.getException();
        }
    }

    public URL findResource(String name) {
        if (this.isDestroyed()) {
            log.warn("Destroyed class loader cannot find a resource");
            return null;
        }
        log.debug("findResource: Try to find resource {}", (Object)name);
        ClassLoaderResource res = this.findClassLoaderResource(name);
        if (res != null) {
            log.debug("findResource: Getting resource from {}, created {}", (Object)res, (Object)new Date(res.getLastModificationTime()));
            return res.getURL();
        }
        return null;
    }

    public Enumeration findResources(String name) {
        if (this.isDestroyed()) {
            log.warn("Destroyed class loader cannot find resources");
            return new Enumeration(){

                public boolean hasMoreElements() {
                    return false;
                }

                public Object nextElement() {
                    throw new NoSuchElementException("No Entries");
                }
            };
        }
        log.debug("findResources: Try to find resources for {}", (Object)name);
        LinkedList<URL> list = new LinkedList<URL>();
        for (int i = 0; i < this.repository.length; ++i) {
            ClassPathEntry cp = this.repository[i];
            log.debug("findResources: Trying {}", (Object)cp);
            ClassLoaderResource res = cp.getResource(name);
            if (res == null) continue;
            log.debug("findResources: Adding resource from {}, created {}", (Object)res, (Object)new Date(res.getLastModificationTime()));
            URL url = res.getURL();
            if (url == null) continue;
            list.add(url);
        }
        return Collections.enumeration(list);
    }

    public URL[] getURLs() {
        if (this.isDestroyed()) {
            log.warn("Destroyed class loader has no URLs any more");
            return new URL[0];
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (int i = 0; i < this.repository.length; ++i) {
            URL url = this.repository[i].toURL();
            if (url == null) continue;
            urls.add(url);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    protected void addURL(URL url) {
        if (this.isDestroyed()) {
            log.warn("Cannot add URL to destroyed class loader");
        } else if (this.checkURL(url)) {
            log.debug("addURL: Adding URL {}", (Object)url);
            try {
                JCRURLConnection conn = (JCRURLConnection)url.openConnection();
                ClassPathEntry cp = ClassPathEntry.getInstance(conn.getSession(), conn.getPath());
                this.addClassPathEntry(cp);
            }
            catch (IOException ioe) {
                log.warn("addURL: Cannot add URL " + url, (Throwable)ioe);
            }
        } else {
            log.warn("addURL: {} is not a Repository URL, ignored", (Object)url);
        }
    }

    public void addHandle(String path) {
        if (this.isDestroyed()) {
            log.warn("Cannot add handle to destroyed class loader");
            return;
        }
        log.debug("addURL: Adding Handle {}", (Object)path);
        ClassPathEntry cp = ClassPathEntry.getInstance(this.session, path);
        if (cp != null) {
            this.addClassPathEntry(cp);
        } else {
            log.debug("addHandle: Cannot get a ClassPathEntry for {}", (Object)path);
        }
    }

    void setHandles(PatternPath handles) {
        this.handles = handles;
    }

    PatternPath getHandles() {
        return this.handles;
    }

    ClassLoaderResource getCachedResource(String name) {
        Object res = this.cache.get(name);
        if (res == null || res == NOT_FOUND_RESOURCE) {
            log.debug("Resource {} not cached", (Object)name);
            return null;
        }
        return (ClassLoaderResource)res;
    }

    Iterator getCachedResources() {
        return this.cache.values().iterator();
    }

    protected void cleanCache() {
        Iterator ci = this.cache.values().iterator();
        while (ci.hasNext()) {
            if (ci.next() != NOT_FOUND_RESOURCE) continue;
            ci.remove();
        }
    }

    protected boolean hasLoadedResources() {
        return this.cache.isEmpty();
    }

    protected Session getSession() {
        return this.session;
    }

    protected void setRepository(ClassPathEntry[] classPath) {
        this.repository = classPath;
    }

    protected ClassPathEntry[] getRepository() {
        return this.repository;
    }

    protected void addClassPathEntry(ClassPathEntry cpe) {
        log.debug("addHandle: Adding path {}", (Object)cpe.getPath());
        ClassPathEntry[] oldClassPath = this.getRepository();
        ClassPathEntry[] newClassPath = this.addClassPathEntry(oldClassPath, cpe);
        this.setRepository(newClassPath);
    }

    protected ClassPathEntry[] addClassPathEntry(ClassPathEntry[] list, ClassPathEntry newEntry) {
        if (list == null) {
            return new ClassPathEntry[]{newEntry};
        }
        ClassPathEntry[] newList = new ClassPathEntry[list.length + 1];
        System.arraycopy(list, 0, newList, 0, list.length);
        newList[list.length] = newEntry;
        return newList;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        if (this.isDestroyed()) {
            buf.append(" - destroyed");
        } else {
            buf.append(": parent: { ");
            buf.append(this.getParent());
            buf.append(" }, user: ");
            buf.append(this.session.getUserID());
        }
        return buf.toString();
    }

    protected synchronized void buildRepository() {
        List handles;
        try {
            handles = this.getHandles().getExpandedPaths();
        }
        catch (RepositoryException re) {
            log.error("Cannot expand handle list", (Throwable)re);
            return;
        }
        ArrayList<ClassPathEntry> newRepository = new ArrayList<ClassPathEntry>(handles.size());
        for (int i = 0; i < handles.size(); ++i) {
            String entry = (String)handles.get(i);
            ClassPathEntry cp = null;
            if (this.getRepository() != null) {
                for (int j = 0; j < this.repository.length; ++j) {
                    ClassPathEntry tmp = this.repository[i];
                    if (!tmp.getPath().equals(entry)) continue;
                    cp = tmp;
                    break;
                }
            }
            if (cp == null) {
                cp = ClassPathEntry.getInstance(this.session, entry);
            }
            if (cp != null) {
                log.debug("Adding path {}", (Object)entry);
                newRepository.add(cp);
                continue;
            }
            log.debug("Cannot get a ClassPathEntry for {}", (Object)entry);
        }
        ClassPathEntry[] newClassPath = new ClassPathEntry[newRepository.size()];
        newRepository.toArray(newClassPath);
        this.setRepository(newClassPath);
        this.cleanCache();
    }

    private Class findClassPrivileged(String name) throws ClassNotFoundException {
        String path = name.replace('.', '/').concat(".class");
        log.debug("findClassPrivileged: Try to find path {} for class {}", (Object)path, (Object)name);
        ClassLoaderResource res = this.findClassLoaderResource(path);
        if (res != null) {
            try {
                log.debug("findClassPrivileged: Loading class from {}, created {}", (Object)res, (Object)new Date(res.getLastModificationTime()));
                Class c = this.defineClass(name, res);
                if (c == null) {
                    log.warn("defineClass returned null for class {}", (Object)name);
                    throw new ClassNotFoundException(name);
                }
                return c;
            }
            catch (IOException ioe) {
                log.debug("defineClass failed", (Throwable)ioe);
                throw new ClassNotFoundException(name, ioe);
            }
            catch (Throwable t) {
                log.debug("defineClass failed", t);
                throw new ClassNotFoundException(name, t);
            }
        }
        throw new ClassNotFoundException(name);
    }

    ClassLoaderResource findClassLoaderResource(String name) {
        ClassLoaderResource res = (ClassLoaderResource)this.cache.get(name);
        if (res == NOT_FOUND_RESOURCE) {
            log.debug("Resource '{}' known to not exist in class path", (Object)name);
            return null;
        }
        if (res != null) {
            return res;
        }
        for (int i = 0; i < this.repository.length; ++i) {
            ClassPathEntry cp = this.repository[i];
            log.debug("Checking {}", (Object)cp);
            res = cp.getResource(name);
            if (res == null) continue;
            log.debug("Found resource in {}, created ", (Object)res, (Object)new Date(res.getLastModificationTime()));
            this.cache.put(name, res);
            return res;
        }
        log.debug("No classpath entry contains {}", (Object)name);
        this.cache.put(name, NOT_FOUND_RESOURCE);
        return null;
    }

    private Class defineClass(String name, ClassLoaderResource res) throws IOException, RepositoryException {
        log.debug("defineClass({}, {})", (Object)name, (Object)res);
        Class<?> clazz = res.getLoadedClass();
        if (clazz == null) {
            int i = name.lastIndexOf(46);
            if (i != -1) {
                String pkgname = name.substring(0, i);
                Package pkg = this.getPackage(pkgname);
                URL url = res.getCodeSourceURL();
                Manifest man = res.getManifest();
                if (pkg != null) {
                    boolean ok;
                    if (pkg.isSealed()) {
                        ok = pkg.isSealed(url);
                    } else {
                        boolean bl = ok = man == null || !this.isSealed(pkgname, man);
                    }
                    if (!ok) {
                        throw new SecurityException("sealing violation");
                    }
                } else if (man != null) {
                    this.definePackage(pkgname, man, url);
                } else {
                    this.definePackage(pkgname, null, null, null, null, null, null, null);
                }
            }
            byte[] data = res.getBytes();
            clazz = this.defineClass(name, data, 0, data.length);
            res.setLoadedClass(clazz);
        }
        return clazz;
    }

    private boolean isSealed(String name, Manifest man) {
        String path = name.replace('.', '/').concat("/");
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    private boolean checkURL(URL url) {
        return "jcr".equalsIgnoreCase(url.getProtocol());
    }
}

