/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.classloader;

import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger log = LoggerFactory.getLogger((Class)Util.class);

    private Util() {
    }

    public static Property getProperty(Item item) throws ItemNotFoundException, ValueFormatException, RepositoryException {
        while (item.isNode()) {
            item = ((Node)item).getPrimaryItem();
        }
        Property prop = (Property)item;
        if (prop.getDefinition().isMultiple()) {
            log.error("{} is a multivalue property", (Object)prop.getPath());
            return null;
        }
        if (prop.getType() == 9) {
            Node node = prop.getNode();
            log.info("Property {} refers to node {}; finding primary item", (Object)prop.getPath(), (Object)node.getPath());
            return Util.getProperty((Item)node);
        }
        return prop;
    }

    public static long getLastModificationTime(Property prop) throws ItemNotFoundException, PathNotFoundException, AccessDeniedException, RepositoryException {
        Node parent = prop.getParent();
        if (parent.isNodeType("nt:resource")) {
            return parent.getProperty("jcr:lastModified").getLong();
        }
        return System.currentTimeMillis();
    }
}

