/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data.db;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.jackrabbit.core.data.AbstractDataStore;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.MultiDataStoreAware;
import org.apache.jackrabbit.core.data.db.DbDataRecord;
import org.apache.jackrabbit.core.data.db.DbInputStream;
import org.apache.jackrabbit.core.data.db.ResettableTempFileInputStream;
import org.apache.jackrabbit.core.data.db.TempFileInputStream;
import org.apache.jackrabbit.core.util.db.CheckSchemaOperation;
import org.apache.jackrabbit.core.util.db.ConnectionFactory;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.DatabaseAware;
import org.apache.jackrabbit.core.util.db.DbUtility;
import org.apache.jackrabbit.core.util.db.StreamWrapper;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbDataStore
extends AbstractDataStore
implements DatabaseAware,
MultiDataStoreAware {
    public static final int DEFAULT_MIN_RECORD_LENGTH = 100;
    public static final String STORE_TEMP_FILE = "tempFile";
    public static final String STORE_SIZE_MINUS_ONE = "-1";
    public static final String STORE_SIZE_MAX = "max";
    protected static final String TEMP_PREFIX = "TEMP_";
    private static Logger log = LoggerFactory.getLogger(DbDataStore.class);
    protected long minModifiedDate;
    protected String url;
    protected String driver;
    protected String user;
    protected String password;
    protected String databaseType;
    protected int minRecordLength = 100;
    protected String tablePrefix = "";
    protected String schemaObjectPrefix = "";
    private boolean schemaCheckEnabled = true;
    protected String dataSourceName;
    protected String tableSQL = "DATASTORE";
    protected String createTableSQL = "CREATE TABLE ${tablePrefix}${table}(ID VARCHAR(255) PRIMARY KEY, LENGTH BIGINT, LAST_MODIFIED BIGINT, DATA BLOB)";
    protected String insertTempSQL = "INSERT INTO ${tablePrefix}${table} VALUES(?, 0, ?, NULL)";
    protected String updateDataSQL = "UPDATE ${tablePrefix}${table} SET DATA=? WHERE ID=?";
    protected String updateLastModifiedSQL = "UPDATE ${tablePrefix}${table} SET LAST_MODIFIED=? WHERE ID=? AND LAST_MODIFIED<?";
    protected String updateSQL = "UPDATE ${tablePrefix}${table} SET ID=?, LENGTH=?, LAST_MODIFIED=? WHERE ID=? AND LAST_MODIFIED=?";
    protected String deleteSQL = "DELETE FROM ${tablePrefix}${table} WHERE ID=?";
    protected String deleteOlderSQL = "DELETE FROM ${tablePrefix}${table} WHERE LAST_MODIFIED<?";
    protected String selectMetaSQL = "SELECT LENGTH, LAST_MODIFIED FROM ${tablePrefix}${table} WHERE ID=?";
    protected String selectAllSQL = "SELECT ID FROM ${tablePrefix}${table}";
    protected String selectDataSQL = "SELECT ID, DATA FROM ${tablePrefix}${table} WHERE ID=?";
    protected String storeStream = "tempFile";
    protected boolean copyWhenReading = true;
    protected Map<DataIdentifier, WeakReference<DataIdentifier>> inUse = Collections.synchronizedMap(new WeakHashMap());
    protected List<String> temporaryInUse = Collections.synchronizedList(new ArrayList());
    protected ConnectionHelper conHelper;
    private ConnectionFactory connectionFactory;

    @Override
    public void setConnectionFactory(ConnectionFactory connnectionFactory) {
        this.connectionFactory = connnectionFactory;
    }

    @Override
    public DataRecord addRecord(InputStream stream) throws DataStoreException {
        DbDataRecord dbDataRecord;
        ResultSet rs;
        InputStream fileInput;
        block29: {
            fileInput = null;
            String tempId = null;
            rs = null;
            try {
                DbDataRecord record;
                long newModified;
                StreamWrapper wrapper;
                long tempModified;
                while (true) {
                    tempModified = System.currentTimeMillis();
                    String id = UUID.randomUUID().toString();
                    tempId = TEMP_PREFIX + id;
                    this.temporaryInUse.add(tempId);
                    rs = this.conHelper.query(this.selectMetaSQL, tempId);
                    boolean hasNext = rs.next();
                    DbUtility.close(rs);
                    rs = null;
                    if (!hasNext) break;
                    DbUtility.close(rs);
                    rs = null;
                }
                try {
                    this.conHelper.exec(this.insertTempSQL, tempId, tempModified);
                }
                catch (Exception e) {
                    try {
                        throw this.convert("Can not insert new record", e);
                    }
                    catch (Throwable throwable) {
                        DbUtility.close(rs);
                        rs = null;
                        throw throwable;
                    }
                }
                DbUtility.close(rs);
                rs = null;
                MessageDigest digest = this.getDigest();
                DigestInputStream dIn = new DigestInputStream(stream, digest);
                CountingInputStream in = new CountingInputStream((InputStream)dIn);
                if (STORE_SIZE_MINUS_ONE.equals(this.storeStream)) {
                    wrapper = new StreamWrapper((InputStream)in, -1L);
                } else if (STORE_SIZE_MAX.equals(this.storeStream)) {
                    wrapper = new StreamWrapper((InputStream)in, Integer.MAX_VALUE);
                } else if (STORE_TEMP_FILE.equals(this.storeStream)) {
                    File temp = this.moveToTempFile((InputStream)in);
                    long length = temp.length();
                    wrapper = new StreamWrapper(new ResettableTempFileInputStream(temp), length);
                } else {
                    throw new DataStoreException("Unsupported stream store algorithm: " + this.storeStream);
                }
                this.conHelper.exec(this.updateDataSQL, wrapper, tempId);
                long length = in.getByteCount();
                DataIdentifier identifier = new DataIdentifier(DbDataStore.encodeHexString(digest.digest()));
                this.usesIdentifier(identifier);
                String id = identifier.toString();
                while (true) {
                    newModified = System.currentTimeMillis();
                    if (this.checkExisting(tempId, length, identifier)) {
                        this.touch(identifier, newModified);
                        this.conHelper.exec(this.deleteSQL, tempId);
                        break;
                    }
                    try {
                        int count = this.conHelper.update(this.updateSQL, id, length, newModified, tempId, tempModified);
                        if (count != 0) {
                            break;
                        }
                    }
                    catch (SQLException count) {
                        // empty catch block
                    }
                    if (!(rs = this.conHelper.query(this.selectMetaSQL, tempId)).next()) {
                        String msg = this.DIGEST + " temporary entry deleted: " + " id=" + tempId + " length=" + length;
                        log.error(msg);
                        throw new DataStoreException(msg);
                    }
                    tempModified = rs.getLong(2);
                    DbUtility.close(rs);
                    rs = null;
                }
                this.usesIdentifier(identifier);
                dbDataRecord = record = new DbDataRecord(this, identifier, length, newModified);
                if (tempId == null) break block29;
                this.temporaryInUse.remove(tempId);
            }
            catch (Exception e) {
                try {
                    throw this.convert("Can not insert new record", e);
                }
                catch (Throwable throwable) {
                    if (tempId != null) {
                        this.temporaryInUse.remove(tempId);
                    }
                    DbUtility.close(rs);
                    if (fileInput != null) {
                        try {
                            fileInput.close();
                        }
                        catch (IOException e2) {
                            throw this.convert("Can not close temporary file", e2);
                        }
                    }
                    throw throwable;
                }
            }
        }
        DbUtility.close(rs);
        if (fileInput != null) {
            try {
                fileInput.close();
            }
            catch (IOException e) {
                throw this.convert("Can not close temporary file", e);
            }
        }
        return dbDataRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkExisting(String tempId, long length, DataIdentifier identifier) throws DataStoreException, SQLException {
        ResultSet rs;
        block3: {
            boolean bl;
            String id = identifier.toString();
            rs = null;
            try {
                rs = this.conHelper.query(this.selectMetaSQL, id);
                if (!rs.next()) break block3;
                long oldLength = rs.getLong(1);
                long lastModified = rs.getLong(2);
                if (oldLength != length) {
                    String msg = this.DIGEST + " collision: temp=" + tempId + " id=" + id + " length=" + length + " oldLength=" + oldLength;
                    log.error(msg);
                    throw new DataStoreException(msg);
                }
                DbUtility.close(rs);
                rs = null;
                this.touch(identifier, lastModified);
                this.conHelper.exec(this.deleteSQL, tempId);
                bl = true;
            }
            catch (Throwable throwable) {
                DbUtility.close(rs);
                throw throwable;
            }
            DbUtility.close(rs);
            return bl;
        }
        DbUtility.close(rs);
        return false;
    }

    private File moveToTempFile(InputStream in) throws IOException {
        File temp = File.createTempFile("dbRecord", null);
        this.writeToFileAndClose(in, temp);
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFileAndClose(InputStream in, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    @Override
    public synchronized void deleteRecord(DataIdentifier identifier) throws DataStoreException {
        try {
            this.conHelper.exec(this.deleteSQL, identifier.toString());
        }
        catch (Exception e) {
            throw this.convert("Can not delete record", e);
        }
    }

    @Override
    public synchronized int deleteAllOlderThan(long min) throws DataStoreException {
        try {
            ArrayList<String> touch = new ArrayList<String>();
            ArrayList<DataIdentifier> ids = new ArrayList<DataIdentifier>(this.inUse.keySet());
            for (DataIdentifier identifier : ids) {
                if (identifier == null) continue;
                touch.add(identifier.toString());
            }
            touch.addAll(this.temporaryInUse);
            for (String key : touch) {
                this.updateLastModifiedDate(key, 0L);
            }
            return this.conHelper.update(this.deleteOlderSQL, min);
        }
        catch (Exception e) {
            throw this.convert("Can not delete records", e);
        }
    }

    @Override
    public Iterator<DataIdentifier> getAllIdentifiers() throws DataStoreException {
        Object id;
        ArrayList<DataIdentifier> list = new ArrayList<DataIdentifier>();
        ResultSet rs = null;
        try {
            rs = this.conHelper.query(this.selectAllSQL, new Object[0]);
            while (rs.next()) {
                id = rs.getString(1);
                if (((String)id).startsWith(TEMP_PREFIX)) continue;
                DataIdentifier identifier = new DataIdentifier((String)id);
                list.add(identifier);
            }
            log.debug("Found " + list.size() + " identifiers.");
            id = list.iterator();
        }
        catch (Exception e) {
            try {
                throw this.convert("Can not read records", e);
            }
            catch (Throwable throwable) {
                DbUtility.close(rs);
                throw throwable;
            }
        }
        DbUtility.close(rs);
        return id;
    }

    @Override
    public int getMinRecordLength() {
        return this.minRecordLength;
    }

    public void setMinRecordLength(int minRecordLength) {
        this.minRecordLength = minRecordLength;
    }

    @Override
    public DataRecord getRecordIfStored(DataIdentifier identifier) throws DataStoreException {
        DbDataRecord dbDataRecord;
        ResultSet rs;
        block5: {
            this.usesIdentifier(identifier);
            rs = null;
            String id = identifier.toString();
            rs = this.conHelper.query(this.selectMetaSQL, id);
            if (rs.next()) break block5;
            DataRecord dataRecord = null;
            DbUtility.close(rs);
            return dataRecord;
        }
        try {
            long length = rs.getLong(1);
            long lastModified = rs.getLong(2);
            DbUtility.close(rs);
            rs = null;
            lastModified = this.touch(identifier, lastModified);
            dbDataRecord = new DbDataRecord(this, identifier, length, lastModified);
        }
        catch (Exception e) {
            try {
                throw this.convert("Can not read identifier " + identifier, e);
            }
            catch (Throwable throwable) {
                DbUtility.close(rs);
                throw throwable;
            }
        }
        DbUtility.close(rs);
        return dbDataRecord;
    }

    InputStream openStream(DbInputStream inputStream, DataIdentifier identifier) throws DataStoreException {
        ResultSet rs = null;
        try {
            rs = this.conHelper.query(this.selectDataSQL, identifier.toString());
            if (!rs.next()) {
                throw new DataStoreException("Record not found: " + identifier);
            }
            InputStream stream = rs.getBinaryStream(2);
            if (stream == null) {
                stream = new ByteArrayInputStream(new byte[0]);
                DbUtility.close(rs);
            } else if (this.copyWhenReading) {
                File temp = this.moveToTempFile(stream);
                stream = new BufferedInputStream(new TempFileInputStream(temp));
                DbUtility.close(rs);
            } else {
                stream = new BufferedInputStream(stream);
                inputStream.setResultSet(rs);
            }
            return stream;
        }
        catch (Exception e) {
            DbUtility.close(rs);
            throw this.convert("Retrieving database resource ", e);
        }
    }

    @Override
    public synchronized void init(String homeDir) throws DataStoreException {
        try {
            this.initDatabaseType();
            this.conHelper = this.createConnectionHelper(this.getDataSource());
            if (this.isSchemaCheckEnabled()) {
                this.createCheckSchemaOperation().run();
            }
        }
        catch (Exception e) {
            throw this.convert("Can not init data store, driver=" + this.driver + " url=" + this.url + " user=" + this.user + " schemaObjectPrefix=" + this.schemaObjectPrefix + " tableSQL=" + this.tableSQL + " createTableSQL=" + this.createTableSQL, e);
        }
    }

    private DataSource getDataSource() throws Exception {
        if (this.getDataSourceName() == null || "".equals(this.getDataSourceName())) {
            return this.connectionFactory.getDataSource(this.getDriver(), this.getUrl(), this.getUser(), this.getPassword());
        }
        return this.connectionFactory.getDataSource(this.dataSourceName);
    }

    protected ConnectionHelper createConnectionHelper(DataSource dataSrc) throws Exception {
        return new ConnectionHelper(dataSrc, false);
    }

    protected final CheckSchemaOperation createCheckSchemaOperation() {
        String tableName = this.tablePrefix + this.schemaObjectPrefix + this.tableSQL;
        return new CheckSchemaOperation(this.conHelper, new ByteArrayInputStream(this.createTableSQL.getBytes()), tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDatabaseType() throws DataStoreException {
        boolean failIfNotFound = false;
        if (this.databaseType == null) {
            if (this.dataSourceName != null) {
                try {
                    this.databaseType = this.connectionFactory.getDataBaseType(this.dataSourceName);
                }
                catch (RepositoryException e) {
                    throw new DataStoreException(e);
                }
            } else {
                if (!this.url.startsWith("jdbc:")) {
                    return;
                }
                int start = "jdbc:".length();
                int end = this.url.indexOf(58, start);
                this.databaseType = this.url.substring(start, end);
            }
        } else {
            failIfNotFound = true;
        }
        InputStream in = DbDataStore.class.getResourceAsStream(this.databaseType + ".properties");
        if (in == null) {
            if (failIfNotFound) {
                String msg = "Configuration error: The resource '" + this.databaseType + ".properties' could not be found;" + " Please verify the databaseType property";
                log.debug(msg);
                throw new DataStoreException(msg);
            }
            return;
        }
        Properties prop = new Properties();
        try {
            try {
                prop.load(in);
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            String msg = "Configuration error: Could not read properties '" + this.databaseType + ".properties'";
            log.debug(msg);
            throw new DataStoreException(msg, e);
        }
        if (this.driver == null) {
            this.driver = this.getProperty(prop, "driver", this.driver);
        }
        this.tableSQL = this.getProperty(prop, "table", this.tableSQL);
        this.createTableSQL = this.getProperty(prop, "createTable", this.createTableSQL);
        this.insertTempSQL = this.getProperty(prop, "insertTemp", this.insertTempSQL);
        this.updateDataSQL = this.getProperty(prop, "updateData", this.updateDataSQL);
        this.updateLastModifiedSQL = this.getProperty(prop, "updateLastModified", this.updateLastModifiedSQL);
        this.updateSQL = this.getProperty(prop, "update", this.updateSQL);
        this.deleteSQL = this.getProperty(prop, "delete", this.deleteSQL);
        this.deleteOlderSQL = this.getProperty(prop, "deleteOlder", this.deleteOlderSQL);
        this.selectMetaSQL = this.getProperty(prop, "selectMeta", this.selectMetaSQL);
        this.selectAllSQL = this.getProperty(prop, "selectAll", this.selectAllSQL);
        this.selectDataSQL = this.getProperty(prop, "selectData", this.selectDataSQL);
        this.storeStream = this.getProperty(prop, "storeStream", this.storeStream);
        if (!(STORE_SIZE_MINUS_ONE.equals(this.storeStream) || STORE_TEMP_FILE.equals(this.storeStream) || STORE_SIZE_MAX.equals(this.storeStream))) {
            String msg = "Unsupported Stream store mechanism: " + this.storeStream + " supported are: " + STORE_SIZE_MINUS_ONE + ", " + STORE_TEMP_FILE + ", " + STORE_SIZE_MAX;
            log.debug(msg);
            throw new DataStoreException(msg);
        }
    }

    protected String getProperty(Properties prop, String key, String defaultValue) {
        String sql = prop.getProperty(key, defaultValue);
        sql = Text.replace((String)sql, (String)"${table}", (String)this.tableSQL).trim();
        sql = Text.replace((String)sql, (String)"${tablePrefix}", (String)(this.tablePrefix + this.schemaObjectPrefix)).trim();
        return sql;
    }

    protected DataStoreException convert(String cause, Exception e) {
        log.warn(cause, (Throwable)e);
        if (e instanceof DataStoreException) {
            return (DataStoreException)((Object)e);
        }
        return new DataStoreException(cause, e);
    }

    @Override
    public void updateModifiedDateOnAccess(long before) {
        log.debug("Update modifiedDate on access before " + before);
        this.minModifiedDate = before;
    }

    long touch(DataIdentifier identifier, long lastModified) throws DataStoreException {
        this.usesIdentifier(identifier);
        return this.updateLastModifiedDate(identifier.toString(), lastModified);
    }

    private long updateLastModifiedDate(String key, long lastModified) throws DataStoreException {
        if (lastModified < this.minModifiedDate) {
            long now = System.currentTimeMillis();
            try {
                this.conHelper.update(this.updateLastModifiedSQL, now, key, now);
                return now;
            }
            catch (Exception e) {
                throw this.convert("Can not update lastModified", e);
            }
        }
        return lastModified;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public final boolean isSchemaCheckEnabled() {
        return this.schemaCheckEnabled;
    }

    public final void setSchemaCheckEnabled(boolean enabled) {
        this.schemaCheckEnabled = enabled;
    }

    @Override
    public synchronized void close() throws DataStoreException {
    }

    protected void usesIdentifier(DataIdentifier identifier) {
        this.inUse.put(identifier, new WeakReference<DataIdentifier>(identifier));
    }

    @Override
    public void clearInUse() {
        this.inUse.clear();
    }

    protected synchronized MessageDigest getDigest() throws DataStoreException {
        try {
            return MessageDigest.getInstance(this.DIGEST);
        }
        catch (NoSuchAlgorithmException e) {
            throw this.convert("No such algorithm: " + this.DIGEST, e);
        }
    }

    public int getMaxConnections() {
        return -1;
    }

    public void setMaxConnections(int maxConnections) {
    }

    public boolean getCopyWhenReading() {
        return this.copyWhenReading;
    }

    public void setCopyWhenReading(boolean copyWhenReading) {
        this.copyWhenReading = copyWhenReading;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public String getSchemaObjectPrefix() {
        return this.schemaObjectPrefix;
    }

    public void setSchemaObjectPrefix(String schemaObjectPrefix) {
        this.schemaObjectPrefix = schemaObjectPrefix;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }
}

