/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.InputStream;
import org.apache.jackrabbit.core.data.AbstractDataRecord;
import org.apache.jackrabbit.core.data.CachingDataStore;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataStoreException;

public class CachingDataRecord
extends AbstractDataRecord {
    private final CachingDataStore store;

    public CachingDataRecord(CachingDataStore store, DataIdentifier identifier) {
        super(store, identifier);
        this.store = store;
    }

    @Override
    public long getLastModified() {
        try {
            return this.store.getLastModified(this.getIdentifier());
        }
        catch (DataStoreException dse) {
            return 0L;
        }
    }

    @Override
    public long getLength() throws DataStoreException {
        return this.store.getLength(this.getIdentifier());
    }

    @Override
    public InputStream getStream() throws DataStoreException {
        return this.store.getStream(this.getIdentifier());
    }
}

