/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.AbstractDataStore;
import org.apache.jackrabbit.core.data.Backend;
import org.apache.jackrabbit.core.data.CachingDataRecord;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.LocalCache;
import org.apache.jackrabbit.core.data.MultiDataStoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CachingDataStore
extends AbstractDataStore
implements MultiDataStoreAware {
    private static final Logger LOG = LoggerFactory.getLogger(CachingDataStore.class);
    private static final String DIGEST = "SHA-1";
    private static final String DS_STORE = ".DS_Store";
    private static final String TMP = "tmp";
    protected Map<DataIdentifier, WeakReference<DataIdentifier>> inUse = Collections.synchronizedMap(new WeakHashMap());
    protected Backend backend;
    private int minRecordLength = 16384;
    private String path;
    private File directory;
    private File tmpDir;
    private String secret;
    private String config;
    private long minModifiedDate;
    private double cachePurgeTrigFactor = 0.95;
    private double cachePurgeResizeFactor = 0.85;
    private long cacheSize = 0x1000000000L;
    private LocalCache cache;

    protected abstract Backend createBackend();

    protected abstract String getMarkerFile();

    @Override
    public void init(String homeDir) throws RepositoryException {
        if (this.path == null) {
            this.path = homeDir + "/repository/datastore";
        }
        this.directory = new File(this.path);
        try {
            CachingDataStore.mkdirs(this.directory);
        }
        catch (IOException e) {
            throw new DataStoreException("Could not create directory " + this.directory.getAbsolutePath(), e);
        }
        this.tmpDir = new File(homeDir, "/repository/s3tmp");
        try {
            if (!CachingDataStore.mkdirs(this.tmpDir)) {
                FileUtils.cleanDirectory((File)this.tmpDir);
                LOG.info("tmp = " + this.tmpDir.getPath() + " cleaned");
            }
        }
        catch (IOException e) {
            throw new DataStoreException("Could not create directory " + this.tmpDir.getAbsolutePath(), e);
        }
        LOG.info("cachePurgeTrigFactor = " + this.cachePurgeTrigFactor + ", cachePurgeResizeFactor = " + this.cachePurgeResizeFactor);
        this.backend = this.createBackend();
        this.backend.init(this, this.path, this.config);
        String markerFileName = this.getMarkerFile();
        if (markerFileName != null) {
            File markerFile = new File(homeDir, markerFileName);
            if (!markerFile.exists()) {
                LOG.info("load files from local cache");
                this.loadFilesFromCache();
                try {
                    markerFile.createNewFile();
                }
                catch (IOException e) {
                    throw new DataStoreException("Could not create marker file " + markerFile.getAbsolutePath(), e);
                }
            } else {
                LOG.info("marker file = " + markerFile.getAbsolutePath() + " exists");
            }
        }
        this.cache = new LocalCache(this.path, this.tmpDir.getAbsolutePath(), this.cacheSize, this.cachePurgeTrigFactor, this.cachePurgeResizeFactor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataRecord addRecord(InputStream input) throws DataStoreException {
        File temporary = null;
        try {
            temporary = this.newTemporaryFile();
            DataIdentifier tempId = new DataIdentifier(temporary.getName());
            this.usesIdentifier(tempId);
            MessageDigest digest = MessageDigest.getInstance(DIGEST);
            DigestOutputStream output = new DigestOutputStream(new FileOutputStream(temporary), digest);
            try {
                IOUtils.copyLarge((InputStream)input, (OutputStream)output);
            }
            finally {
                ((OutputStream)output).close();
            }
            DataIdentifier identifier = new DataIdentifier(CachingDataStore.encodeHexString(digest.digest()));
            Object object = this;
            synchronized (object) {
                this.usesIdentifier(identifier);
                this.backend.write(identifier, temporary);
                String fileName = CachingDataStore.getFileName(identifier);
                this.cache.store(fileName, temporary);
            }
            this.inUse.remove(tempId);
            object = new CachingDataRecord(this, identifier);
            return object;
        }
        catch (NoSuchAlgorithmException e) {
            throw new DataStoreException("SHA-1 not available", e);
        }
        catch (IOException e) {
            throw new DataStoreException("Could not add record", e);
        }
        finally {
            if (temporary != null) {
                temporary.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataRecord getRecordIfStored(DataIdentifier identifier) throws DataStoreException {
        CachingDataStore cachingDataStore = this;
        synchronized (cachingDataStore) {
            this.usesIdentifier(identifier);
            if (!this.backend.exists(identifier)) {
                return null;
            }
            this.backend.touch(identifier, this.minModifiedDate);
            return new CachingDataRecord(this, identifier);
        }
    }

    @Override
    public void updateModifiedDateOnAccess(long before) {
        LOG.info("minModifiedDate set to: " + before);
        this.minModifiedDate = before;
    }

    @Override
    public Iterator<DataIdentifier> getAllIdentifiers() throws DataStoreException {
        return this.backend.getAllIdentifiers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRecord(DataIdentifier identifier) throws DataStoreException {
        String fileName = CachingDataStore.getFileName(identifier);
        CachingDataStore cachingDataStore = this;
        synchronized (cachingDataStore) {
            this.backend.deleteRecord(identifier);
            this.cache.delete(fileName);
        }
    }

    @Override
    public synchronized int deleteAllOlderThan(long min) throws DataStoreException {
        List<DataIdentifier> diList = this.backend.deleteAllOlderThan(min);
        for (DataIdentifier identifier : diList) {
            this.cache.delete(CachingDataStore.getFileName(identifier));
        }
        return diList.size();
    }

    InputStream getStream(DataIdentifier identifier) throws DataStoreException {
        InputStream in = null;
        try {
            String fileName = CachingDataStore.getFileName(identifier);
            InputStream cached = this.cache.getIfStored(fileName);
            if (cached != null) {
                InputStream inputStream = cached;
                return inputStream;
            }
            in = this.backend.read(identifier);
            InputStream inputStream = this.cache.store(fileName, in);
            IOUtils.closeQuietly((InputStream)in);
            return inputStream;
        }
        catch (IOException e) {
            throw new DataStoreException("IO Exception: " + identifier, e);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public long getLastModified(DataIdentifier identifier) throws DataStoreException {
        LOG.info("accessed lastModified");
        return this.backend.getLastModified(identifier);
    }

    public long getLength(DataIdentifier identifier) throws DataStoreException {
        String fileName = CachingDataStore.getFileName(identifier);
        Long length = this.cache.getFileLength(fileName);
        if (length != null) {
            return length;
        }
        return this.backend.getLength(identifier);
    }

    @Override
    protected byte[] getOrCreateReferenceKey() throws DataStoreException {
        try {
            return this.secret.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new DataStoreException(e);
        }
    }

    private File newTemporaryFile() throws IOException {
        return File.createTempFile(TMP, null, this.tmpDir);
    }

    private void loadFilesFromCache() throws RepositoryException {
        ArrayList<File> files = new ArrayList<File>();
        this.listRecursive(files, this.directory);
        long totalSize = 0L;
        for (File f : files) {
            totalSize += f.length();
        }
        long currentSize = 0L;
        long time = System.currentTimeMillis();
        for (File f : files) {
            long now = System.currentTimeMillis();
            if (now > time + 5000L) {
                LOG.info("Uploaded {" + currentSize + "}/{" + totalSize + "}");
                time = now;
            }
            currentSize += f.length();
            String name = f.getName();
            LOG.debug("upload file = " + name);
            if (name.startsWith(TMP) || name.endsWith(DS_STORE) || f.length() <= 0L) continue;
            this.loadFileToBackEnd(f);
        }
        LOG.info("Uploaded {" + currentSize + "}/{" + totalSize + "}");
    }

    private void listRecursive(List<File> list, File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.listRecursive(list, f);
                    continue;
                }
                list.add(f);
            }
        }
    }

    private void loadFileToBackEnd(File f) throws DataStoreException {
        DataIdentifier identifier = new DataIdentifier(f.getName());
        this.usesIdentifier(identifier);
        this.backend.write(identifier, f);
        LOG.debug(f.getName() + "uploaded.");
    }

    private static String getFileName(DataIdentifier identifier) {
        String name = identifier.toString();
        name = name.substring(0, 2) + "/" + name.substring(2, 4) + "/" + name.substring(4, 6) + "/" + name;
        return name;
    }

    private void usesIdentifier(DataIdentifier identifier) {
        this.inUse.put(identifier, new WeakReference<DataIdentifier>(identifier));
    }

    private static boolean mkdirs(File dir) throws IOException {
        if (dir.exists()) {
            if (dir.isFile()) {
                throw new IOException("Can not create a directory because a file exists with the same name: " + dir.getAbsolutePath());
            }
            return false;
        }
        boolean created = dir.mkdirs();
        if (!created) {
            throw new IOException("Could not create directory: " + dir.getAbsolutePath());
        }
        return created;
    }

    @Override
    public void clearInUse() {
        this.inUse.clear();
    }

    public boolean isInUse(DataIdentifier identifier) {
        return this.inUse.containsKey(identifier);
    }

    @Override
    public void close() throws DataStoreException {
        this.cache.close();
        this.backend.close();
        this.cache = null;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setMinRecordLength(int minRecordLength) {
        this.minRecordLength = minRecordLength;
    }

    @Override
    public int getMinRecordLength() {
        return this.minRecordLength;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public double getCachePurgeTrigFactor() {
        return this.cachePurgeTrigFactor;
    }

    public void setCachePurgeTrigFactor(double cachePurgeTrigFactor) {
        this.cachePurgeTrigFactor = cachePurgeTrigFactor;
    }

    public double getCachePurgeResizeFactor() {
        return this.cachePurgeResizeFactor;
    }

    public void setCachePurgeResizeFactor(double cachePurgeResizeFactor) {
        this.cachePurgeResizeFactor = cachePurgeResizeFactor;
    }
}

