/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.LazyFileInputStream;
import org.apache.jackrabbit.util.TransientFileFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCache {
    static final Logger LOG = LoggerFactory.getLogger(LocalCache.class);
    final Set<String> toBeDeleted = new HashSet<String>();
    LRUCache cache;
    private final File directory;
    private final File tmp;
    private long maxSize;
    private volatile boolean purgeMode;

    public LocalCache(String path, String tmpPath, long maxSize, double cachePurgeTrigFactor, double cachePurgeResizeFactor) throws RepositoryException {
        this.maxSize = maxSize;
        this.directory = new File(path);
        this.tmp = new File(tmpPath);
        this.cache = new LRUCache(maxSize, cachePurgeTrigFactor, cachePurgeResizeFactor);
        ArrayList<File> allFiles = new ArrayList<File>();
        Iterator it = FileUtils.iterateFiles((File)this.directory, null, (boolean)true);
        while (it.hasNext()) {
            File f = (File)it.next();
            allFiles.add(f);
        }
        Collections.sort(allFiles, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                long l2;
                long l1 = o1.lastModified();
                return l1 < (l2 = o2.lastModified()) ? -1 : (l1 > l2 ? 1 : 0);
            }
        });
        String dataStorePath = this.directory.getAbsolutePath();
        long time = System.currentTimeMillis();
        int count = 0;
        int deletecount = 0;
        for (File f : allFiles) {
            long now;
            if (!f.exists()) continue;
            long length = f.length();
            String name = f.getPath();
            if (name.startsWith(dataStorePath)) {
                name = name.substring(dataStorePath.length());
            }
            if ((name = name.replace("\\", "/")).startsWith("/") || name.startsWith("\\")) {
                name = name.substring(1);
            }
            if (this.cache.currentSizeInBytes + length < this.cache.maxSizeInBytes) {
                ++count;
                this.cache.put(name, length);
            } else if (this.tryDelete(name)) {
                ++deletecount;
            }
            if ((now = System.currentTimeMillis()) <= time + 5000L) continue;
            LOG.info("Processed {" + (count + deletecount) + "}/{" + allFiles.size() + "}");
            time = now;
        }
        LOG.info("Cached {" + count + "}/{" + allFiles.size() + "} , currentSizeInBytes = " + this.cache.currentSizeInBytes);
        LOG.info("Deleted {" + deletecount + "}/{" + allFiles.size() + "} files .");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized InputStream store(String fileName, InputStream in) throws IOException {
        File f;
        block8: {
            block7: {
                fileName = fileName.replace("\\", "/");
                f = this.getFile(fileName);
                long length = 0L;
                if (f.exists() && !this.isInPurgeMode()) break block7;
                BufferedOutputStream out = null;
                File transFile = null;
                try {
                    TransientFileFactory tff = TransientFileFactory.getInstance();
                    transFile = tff.createTransientFile("s3-", "tmp", this.tmp);
                    out = new BufferedOutputStream(new FileOutputStream(transFile));
                    length = IOUtils.copyLarge((InputStream)in, (OutputStream)out);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)out);
                if (this.canAdmitFile(length) && (f.getParentFile().exists() || f.getParentFile().mkdirs()) && transFile.renameTo(f) && f.exists()) {
                    if (transFile.exists() && transFile.delete()) {
                        LOG.warn("tmp file = " + transFile.getAbsolutePath() + " not deleted successfully");
                    }
                    transFile = null;
                    this.toBeDeleted.remove(fileName);
                    if (this.cache.get(fileName) == null) {
                        this.cache.put(fileName, f.length());
                    }
                } else {
                    f = transFile;
                }
                break block8;
            }
            f.setLastModified(System.currentTimeMillis());
            this.toBeDeleted.remove(fileName);
            if (this.cache.get(fileName) == null) {
                this.cache.put(fileName, f.length());
            }
        }
        this.cache.tryPurge();
        return new LazyFileInputStream(f);
    }

    public synchronized void store(String fileName, File src) throws IOException {
        fileName = fileName.replace("\\", "/");
        File dest = this.getFile(fileName);
        File parent = dest.getParentFile();
        if (src.exists() && !dest.exists() && !src.equals(dest) && this.canAdmitFile(src.length()) && (parent.exists() || parent.mkdirs()) && src.renameTo(dest)) {
            this.toBeDeleted.remove(fileName);
            if (this.cache.get(fileName) == null) {
                this.cache.put(fileName, dest.length());
            }
        } else if (dest.exists()) {
            dest.setLastModified(System.currentTimeMillis());
            this.toBeDeleted.remove(fileName);
            if (this.cache.get(fileName) == null) {
                this.cache.put(fileName, dest.length());
            }
        }
        this.cache.tryPurge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getIfStored(String fileName) throws IOException {
        fileName = fileName.replace("\\", "/");
        File f = this.getFile(fileName);
        LocalCache localCache = this;
        synchronized (localCache) {
            if (!f.exists() || this.isInPurgeMode()) {
                LocalCache.log("purgeMode true or file doesn't exists: getIfStored returned");
                return null;
            }
            f.setLastModified(System.currentTimeMillis());
            return new LazyFileInputStream(f);
        }
    }

    public synchronized void delete(String fileName) {
        if (this.isInPurgeMode()) {
            LocalCache.log("purgeMode true :delete returned");
            return;
        }
        fileName = fileName.replace("\\", "/");
        this.cache.remove(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getFileLength(String fileName) {
        fileName = fileName.replace("\\", "/");
        File f = this.getFile(fileName);
        LocalCache localCache = this;
        synchronized (localCache) {
            if (!f.exists() || this.isInPurgeMode()) {
                LocalCache.log("purgeMode true or file doesn't exists: getFileLength returned");
                return null;
            }
            f.setLastModified(System.currentTimeMillis());
            return f.length();
        }
    }

    public void close() {
        LocalCache.log("close");
        this.deleteOldFiles();
    }

    private synchronized boolean canAdmitFile(long length) {
        boolean value;
        boolean bl = value = !this.isInPurgeMode() && this.cache.canAdmitFile(length);
        if (!value) {
            LocalCache.log("cannot admit file of length=" + length + " and currentSizeInBytes=" + this.cache.currentSizeInBytes);
        }
        return value;
    }

    synchronized boolean isInPurgeMode() {
        return this.purgeMode || this.maxSize == 0L;
    }

    synchronized void setPurgeMode(boolean purgeMode) {
        this.purgeMode = purgeMode;
    }

    File getFile(String fileName) {
        return new File(this.directory, fileName);
    }

    private void deleteOldFiles() {
        int initialSize = this.toBeDeleted.size();
        int count = 0;
        for (String n : new ArrayList<String>(this.toBeDeleted)) {
            if (!this.tryDelete(n)) continue;
            ++count;
        }
        LOG.info("deleted [" + count + "]/[" + initialSize + "] files");
    }

    boolean tryDelete(String fileName) {
        LocalCache.log("cache delete " + fileName);
        File f = this.getFile(fileName);
        if (f.exists() && f.delete()) {
            LocalCache.log(fileName + "  deleted successfully");
            this.toBeDeleted.remove(fileName);
            while (!(f = f.getParentFile()).equals(this.directory) && f.list().length <= 0) {
                f.delete();
            }
            return true;
        }
        if (f.exists()) {
            LOG.info("not able to delete file = " + f.getAbsolutePath());
            this.toBeDeleted.add(fileName);
            return false;
        }
        return true;
    }

    static int maxSizeElements(long bytes) {
        int count = (int)(bytes / 65535L);
        count = Math.max(1024, count);
        count = Math.min(65536, count);
        return count;
    }

    static void log(String s) {
        LOG.debug(s);
    }

    private class PurgeJob
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LRUCache lRUCache = LocalCache.this.cache;
                synchronized (lRUCache) {
                    LOG.info(" cache purge job started");
                    int initialSize = LocalCache.this.cache.size();
                    for (String fileName : new ArrayList<String>(LocalCache.this.toBeDeleted)) {
                        LocalCache.this.cache.remove(fileName);
                    }
                    Iterator itr = LocalCache.this.cache.entrySet().iterator();
                    while (itr.hasNext()) {
                        Map.Entry entry = itr.next();
                        if (entry.getKey() == null) continue;
                        if (LocalCache.this.cache.currentSizeInBytes <= LocalCache.this.cache.cachePurgeResize) break;
                        itr.remove();
                    }
                    LOG.info(" cache purge job completed: cleaned [" + (initialSize - LocalCache.this.cache.size()) + "] files and currentSizeInBytes = [ " + LocalCache.this.cache.currentSizeInBytes + "]");
                }
            }
            catch (Exception e) {
                LOG.error("error in purge jobs:", (Throwable)e);
            }
            finally {
                LocalCache.this.setPurgeMode(false);
            }
        }
    }

    private class LRUCache
    extends LinkedHashMap<String, Long> {
        private static final long serialVersionUID = 1L;
        volatile long currentSizeInBytes;
        final long maxSizeInBytes;
        long cachePurgeResize;
        private long cachePurgeTrigSize;

        public LRUCache(long maxSizeInBytes, double cachePurgeTrigFactor, double cachePurgeResizeFactor) {
            super(LocalCache.maxSizeElements(maxSizeInBytes), 0.75f, true);
            this.maxSizeInBytes = maxSizeInBytes;
            this.cachePurgeTrigSize = new Double(cachePurgeTrigFactor * (double)maxSizeInBytes).longValue();
            this.cachePurgeResize = new Double(cachePurgeResizeFactor * (double)maxSizeInBytes).longValue();
        }

        @Override
        public synchronized Long remove(Object key) {
            String fileName = (String)key;
            fileName = fileName.replace("\\", "/");
            Long flength = null;
            if (LocalCache.this.tryDelete(fileName)) {
                flength = (Long)super.remove(key);
                if (flength != null) {
                    LocalCache.log("cache entry { " + fileName + "} with size {" + flength + "} removed.");
                    this.currentSizeInBytes -= flength.longValue();
                }
            } else if (!LocalCache.this.getFile(fileName).exists() && (flength = (Long)super.remove(key)) != null) {
                LocalCache.log(" file not exists. cache entry { " + fileName + "} with size {" + flength + "} removed.");
                this.currentSizeInBytes -= flength.longValue();
            }
            return flength;
        }

        @Override
        public synchronized Long put(String key, Long value) {
            long flength = value;
            this.currentSizeInBytes += flength;
            return super.put(key.replace("\\", "/"), value);
        }

        synchronized void tryPurge() {
            if (this.currentSizeInBytes > this.cachePurgeTrigSize && !LocalCache.this.isInPurgeMode()) {
                LocalCache.this.setPurgeMode(true);
                LOG.info("currentSizeInBytes[" + LocalCache.this.cache.currentSizeInBytes + "] exceeds (cachePurgeTrigSize)[" + LocalCache.this.cache.cachePurgeTrigSize + "]");
                new Thread(new PurgeJob()).start();
            }
        }

        synchronized boolean canAdmitFile(long length) {
            return LocalCache.this.cache.currentSizeInBytes + length < LocalCache.this.cache.maxSizeInBytes;
        }
    }
}

