/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.core.data.AsyncUploadCacheResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncUploadCache {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncUploadCache.class);
    Map<String, Long> asyncUploadMap = new HashMap<String, Long>();
    Set<String> toBeDeleted = new HashSet<String>();
    String path;
    String homeDir;
    int asyncUploadLimit;
    private File pendingUploads;
    private File toBeDeletedUploads;
    private static final String PENDIND_UPLOAD_FILE = "async-pending-uploads.ser";
    private static final String TO_BE_DELETED_UPLOAD_FILE = "async-tobedeleted-uploads.ser";

    public synchronized AsyncUploadCacheResult add(String fileName) throws IOException {
        AsyncUploadCacheResult result = new AsyncUploadCacheResult();
        if (this.asyncUploadMap.entrySet().size() >= this.asyncUploadLimit) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Async write limit [" + this.asyncUploadLimit + "] reached. File [" + fileName + "]  not added to async write cache.");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("current set =" + this.asyncUploadMap.keySet());
            }
            result.setAsyncUpload(false);
        } else {
            long startTime = System.currentTimeMillis();
            if (this.toBeDeleted.remove(fileName)) {
                this.serializeToBeDeleted();
            }
            this.asyncUploadMap.put(fileName, System.currentTimeMillis());
            this.serializeAsyncUploadMap();
            if (LOG.isDebugEnabled()) {
                LOG.debug("added file [" + fileName + "] to asyncUploadMap upoad took [" + (System.currentTimeMillis() - startTime) / 1000L + "] sec");
                LOG.debug("current set =" + this.asyncUploadMap.keySet());
            }
            result.setAsyncUpload(true);
        }
        return result;
    }

    public synchronized AsyncUploadCacheResult remove(String fileName) throws IOException {
        long startTime = System.currentTimeMillis();
        Long retVal = this.asyncUploadMap.remove(fileName);
        if (retVal != null) {
            this.serializeAsyncUploadMap();
            if (LOG.isDebugEnabled()) {
                LOG.debug("removed file [" + fileName + "] from asyncUploadMap took [" + (System.currentTimeMillis() - startTime) / 1000L + "] sec");
                LOG.debug("current set =" + this.asyncUploadMap.keySet());
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("cannot remove file [" + fileName + "] from pending upoad took [" + (System.currentTimeMillis() - startTime) / 1000L + "] sec. File not found");
            LOG.debug("current set =" + this.asyncUploadMap.keySet());
        }
        AsyncUploadCacheResult result = new AsyncUploadCacheResult();
        result.setRequiresDelete(this.toBeDeleted.contains(fileName));
        return result;
    }

    public synchronized Set<String> getAll() {
        HashSet<String> retVal = new HashSet<String>();
        retVal.addAll(this.asyncUploadMap.keySet());
        retVal.removeAll(this.toBeDeleted);
        return retVal;
    }

    public synchronized boolean hasEntry(String fileName, boolean touch) throws IOException {
        boolean contains;
        boolean bl = contains = this.asyncUploadMap.containsKey(fileName) && !this.toBeDeleted.contains(fileName);
        if (touch && contains) {
            long timeStamp = System.currentTimeMillis();
            this.asyncUploadMap.put(fileName, timeStamp);
            this.serializeAsyncUploadMap();
        }
        return contains;
    }

    public synchronized long getLastModified(String fileName) {
        return this.asyncUploadMap.get(fileName) != null && !this.toBeDeleted.contains(fileName) ? this.asyncUploadMap.get(fileName) : 0L;
    }

    public synchronized void delete(String fileName) throws IOException {
        boolean serialize = false;
        if (this.toBeDeleted.remove(fileName)) {
            serialize = true;
        }
        if (this.asyncUploadMap.containsKey(fileName) && this.toBeDeleted.add(fileName)) {
            serialize = true;
        }
        if (serialize) {
            this.serializeToBeDeleted();
        }
    }

    public synchronized Set<String> deleteOlderThan(long min) throws IOException {
        LOG.info("deleteOlderThan min =" + (min -= 1000L));
        HashSet<String> deleteSet = new HashSet<String>();
        for (Map.Entry<String, Long> entry : this.asyncUploadMap.entrySet()) {
            if (entry.getValue() >= min) continue;
            deleteSet.add(entry.getKey());
        }
        if (deleteSet.size() > 0) {
            LOG.info("deleteOlderThan set =" + deleteSet);
            this.toBeDeleted.addAll(deleteSet);
            this.serializeToBeDeleted();
        }
        return deleteSet;
    }

    public synchronized void init(String homeDir, String path, int asyncUploadLimit) throws IOException, ClassNotFoundException {
        this.homeDir = homeDir;
        this.path = path;
        this.asyncUploadLimit = asyncUploadLimit;
        LOG.info("AsynWriteCache:homeDir [" + homeDir + "], path [" + path + "], asyncUploadLimit [" + asyncUploadLimit + "].");
        this.pendingUploads = new File(homeDir + "/" + PENDIND_UPLOAD_FILE);
        if (this.pendingUploads.exists()) {
            this.deserializeAsyncUploadMap();
        } else {
            this.pendingUploads.createNewFile();
            this.asyncUploadMap = new HashMap<String, Long>();
            this.serializeAsyncUploadMap();
        }
        this.toBeDeletedUploads = new File(homeDir + "/" + TO_BE_DELETED_UPLOAD_FILE);
        if (this.toBeDeletedUploads.exists()) {
            this.deserializeToBeDeleted();
        } else {
            this.toBeDeletedUploads.createNewFile();
            this.asyncUploadMap = new HashMap<String, Long>();
            this.serializeToBeDeleted();
        }
    }

    public synchronized void reset() throws IOException {
        String filePath = this.pendingUploads.getAbsolutePath();
        if (this.pendingUploads.exists() && !this.pendingUploads.delete()) {
            throw new IOException("Failed to delete file [" + filePath + "]");
        }
        this.pendingUploads.createNewFile();
        this.asyncUploadMap = new HashMap<String, Long>();
        this.serializeAsyncUploadMap();
        filePath = this.toBeDeletedUploads.getAbsolutePath();
        if (this.toBeDeletedUploads.exists() && !this.toBeDeletedUploads.delete()) {
            throw new IOException("Failed to delete file [" + filePath + "]");
        }
        this.toBeDeletedUploads.createNewFile();
        this.toBeDeleted = new HashSet<String>();
        this.serializeToBeDeleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void serializeAsyncUploadMap() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.pendingUploads);
        BufferedOutputStream buffer = new BufferedOutputStream(fos);
        ObjectOutputStream output = new ObjectOutputStream(buffer);
        try {
            output.writeObject(this.asyncUploadMap);
        }
        finally {
            output.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void deserializeAsyncUploadMap() throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(this.pendingUploads);
        BufferedInputStream buffer = new BufferedInputStream(fis);
        ObjectInputStream input = new ObjectInputStream(buffer);
        try {
            this.asyncUploadMap = (Map)input.readObject();
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void serializeToBeDeleted() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.toBeDeletedUploads);
        BufferedOutputStream buffer = new BufferedOutputStream(fos);
        ObjectOutputStream output = new ObjectOutputStream(buffer);
        try {
            output.writeObject(this.toBeDeleted);
        }
        finally {
            output.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void deserializeToBeDeleted() throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(this.toBeDeletedUploads);
        BufferedInputStream buffer = new BufferedInputStream(fis);
        ObjectInputStream input = new ObjectInputStream(buffer);
        try {
            this.toBeDeleted = (Set)input.readObject();
        }
        finally {
            input.close();
        }
    }
}

