/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.AbstractDataStore;
import org.apache.jackrabbit.core.data.AsyncUploadCache;
import org.apache.jackrabbit.core.data.AsyncUploadCacheResult;
import org.apache.jackrabbit.core.data.AsyncUploadCallback;
import org.apache.jackrabbit.core.data.Backend;
import org.apache.jackrabbit.core.data.CachingDataRecord;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.LocalCache;
import org.apache.jackrabbit.core.data.MultiDataStoreAware;
import org.apache.jackrabbit.core.data.util.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CachingDataStore
extends AbstractDataStore
implements MultiDataStoreAware,
AsyncUploadCallback {
    private static final Logger LOG = LoggerFactory.getLogger(CachingDataStore.class);
    private static final String DIGEST = "SHA-1";
    private static final String DS_STORE = ".DS_Store";
    private static final String TMP = "tmp";
    protected Map<DataIdentifier, WeakReference<DataIdentifier>> inUse = Collections.synchronizedMap(new WeakHashMap());
    protected Backend backend;
    private int minRecordLength = 16384;
    private String path;
    private File directory;
    private File tmpDir;
    private String secret;
    private String config;
    private long minModifiedDate;
    private double cachePurgeTrigFactor = 0.95;
    private double cachePurgeResizeFactor = 0.85;
    private long cacheSize = 0x1000000000L;
    private LocalCache cache;
    private AsyncUploadCache asyncWriteCache;
    private boolean continueOnAsyncUploadFailure;
    private int concurrentUploadsThreads = 10;
    private int asyncUploadLimit = 100;

    protected abstract Backend createBackend();

    protected abstract String getMarkerFile();

    @Override
    public void init(String homeDir) throws RepositoryException {
        try {
            Set<String> fileList;
            if (this.path == null) {
                this.path = homeDir + "/repository/datastore";
                this.tmpDir = new File(homeDir, "/repository/s3tmp");
            } else {
                this.tmpDir = new File(this.path, "/repository/s3tmp");
                this.path = this.path + "/repository/datastore";
            }
            LOG.info("path=[" + this.path + ",] tmpPath= [" + this.tmpDir.getPath() + "]");
            this.directory = new File(this.path);
            CachingDataStore.mkdirs(this.directory);
            if (!CachingDataStore.mkdirs(this.tmpDir)) {
                FileUtils.cleanDirectory((File)this.tmpDir);
                LOG.info("tmp = " + this.tmpDir.getPath() + " cleaned");
            }
            this.asyncWriteCache = new AsyncUploadCache();
            this.asyncWriteCache.init(homeDir, this.path, this.asyncUploadLimit);
            this.backend = this.createBackend();
            this.backend.init(this, this.path, this.config);
            String markerFileName = this.getMarkerFile();
            if (markerFileName != null) {
                File markerFile = new File(homeDir, markerFileName);
                if (!markerFile.exists()) {
                    LOG.info("load files from local cache");
                    this.uploadFilesFromCache();
                    try {
                        markerFile.createNewFile();
                    }
                    catch (IOException e) {
                        throw new DataStoreException("Could not create marker file " + markerFile.getAbsolutePath(), e);
                    }
                } else {
                    LOG.info("marker file = " + markerFile.getAbsolutePath() + " exists");
                }
            }
            if ((fileList = this.asyncWriteCache.getAll()) != null && !fileList.isEmpty()) {
                ArrayList<String> errorFiles = new ArrayList<String>();
                LOG.info("Uploading [" + fileList + "]  and size [" + fileList.size() + "] from AsyncUploadCache.");
                long totalSize = 0L;
                ArrayList<File> files = new ArrayList<File>(fileList.size());
                for (String fileName : fileList) {
                    File f = new File(this.path, fileName);
                    if (!f.exists()) {
                        errorFiles.add(fileName);
                        LOG.error("Cannot upload pending file [" + f.getAbsolutePath() + "]. File doesn't exist.");
                        continue;
                    }
                    totalSize += f.length();
                    files.add(new File(homeDir, fileName));
                }
                new FilesUploader(files, totalSize, this.concurrentUploadsThreads, true).upload();
                if (!this.continueOnAsyncUploadFailure && errorFiles.size() > 0) {
                    LOG.error("Pending uploads of files [" + errorFiles + "] failed. Files do not exist in Local cache.");
                    LOG.error("To continue set [continueOnAsyncUploadFailure] to true in Datastore configuration in repository.xml. There would be inconsistent data in repository due the missing files. ");
                    throw new RepositoryException("Cannot upload async uploads from local cache. Files not found.");
                }
                if (errorFiles.size() > 0) {
                    LOG.error("Pending uploads of files [" + errorFiles + "] failed. Files do not exist" + " in Local cache. Continuing as [continueOnAsyncUploadFailure] is set to true.");
                }
                LOG.info("Reseting AsyncWrite Cache list.");
                this.asyncWriteCache.reset();
            }
            this.cache = new LocalCache(this.path, this.tmpDir.getAbsolutePath(), this.cacheSize, this.cachePurgeTrigFactor, this.cachePurgeResizeFactor, this.asyncWriteCache);
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataRecord addRecord(InputStream input) throws DataStoreException {
        File temporary = null;
        long startTime = System.currentTimeMillis();
        long length = 0L;
        try {
            temporary = this.newTemporaryFile();
            DataIdentifier tempId = new DataIdentifier(temporary.getName());
            this.usesIdentifier(tempId);
            MessageDigest digest = MessageDigest.getInstance(DIGEST);
            DigestOutputStream output = new DigestOutputStream(new FileOutputStream(temporary), digest);
            try {
                length = IOUtils.copyLarge((InputStream)input, (OutputStream)output);
            }
            finally {
                ((OutputStream)output).close();
            }
            long currTime = System.currentTimeMillis();
            DataIdentifier identifier = new DataIdentifier(CachingDataStore.encodeHexString(digest.digest()));
            if (LOG.isDebugEnabled()) {
                LOG.debug("getting SHA1 hash  [" + identifier + "] length [" + length + "],   in [" + (currTime - startTime) + "] ms.");
            }
            String fileName = CachingDataStore.getFileName(identifier);
            AsyncUploadCacheResult result = null;
            Object object = this;
            synchronized (object) {
                this.usesIdentifier(identifier);
                if (!this.asyncWriteCache.hasEntry(fileName, true)) {
                    result = this.cache.store(fileName, temporary, true);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("storing  [" + identifier + "] in localCache took [" + (System.currentTimeMillis() - currTime) + "] ms.");
            }
            if (result != null) {
                if (result.canAsyncUpload()) {
                    this.backend.writeAsync(identifier, result.getFile(), this);
                } else {
                    this.backend.write(identifier, result.getFile());
                }
            }
            this.inUse.remove(tempId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("write [" + identifier + "] length [" + length + "],   in [" + (System.currentTimeMillis() - startTime) + "] ms.");
            }
            object = new CachingDataRecord(this, identifier);
            return object;
        }
        catch (NoSuchAlgorithmException e) {
            throw new DataStoreException("SHA-1 not available", e);
        }
        catch (IOException e) {
            throw new DataStoreException("Could not add record", e);
        }
        finally {
            if (temporary != null) {
                temporary.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataRecord getRecord(DataIdentifier identifier) throws DataStoreException {
        String fileName = CachingDataStore.getFileName(identifier);
        boolean touch = this.minModifiedDate > 0L;
        CachingDataStore cachingDataStore = this;
        synchronized (cachingDataStore) {
            try {
                if (this.asyncWriteCache.hasEntry(fileName, touch)) {
                    this.usesIdentifier(identifier);
                    return new CachingDataRecord(this, identifier);
                }
                if (this.cache.getFileIfStored(fileName) != null) {
                    if (touch) {
                        this.backend.exists(identifier, touch);
                    }
                    this.usesIdentifier(identifier);
                    return new CachingDataRecord(this, identifier);
                }
                if (this.backend.exists(identifier, touch)) {
                    this.usesIdentifier(identifier);
                    return new CachingDataRecord(this, identifier);
                }
            }
            catch (IOException ioe) {
                throw new DataStoreException("error in getting record [" + identifier + "]", ioe);
            }
        }
        throw new DataStoreException("Record not found: " + identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataRecord getRecordIfStored(DataIdentifier identifier) throws DataStoreException {
        String fileName = CachingDataStore.getFileName(identifier);
        boolean touch = this.minModifiedDate > 0L;
        CachingDataStore cachingDataStore = this;
        synchronized (cachingDataStore) {
            try {
                if (this.asyncWriteCache.hasEntry(fileName, touch) || this.backend.exists(identifier, touch)) {
                    this.usesIdentifier(identifier);
                    return new CachingDataRecord(this, identifier);
                }
            }
            catch (IOException ioe) {
                throw new DataStoreException(ioe);
            }
        }
        return null;
    }

    @Override
    public void updateModifiedDateOnAccess(long before) {
        LOG.info("minModifiedDate set to: " + before);
        this.minModifiedDate = before;
    }

    @Override
    public Iterator<DataIdentifier> getAllIdentifiers() throws DataStoreException {
        HashSet<DataIdentifier> ids = new HashSet<DataIdentifier>();
        for (String fileName : this.asyncWriteCache.getAll()) {
            ids.add(CachingDataStore.getIdentifier(fileName));
        }
        Iterator<DataIdentifier> itr = this.backend.getAllIdentifiers();
        while (itr.hasNext()) {
            ids.add(itr.next());
        }
        return ids.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRecord(DataIdentifier identifier) throws DataStoreException {
        String fileName = CachingDataStore.getFileName(identifier);
        CachingDataStore cachingDataStore = this;
        synchronized (cachingDataStore) {
            try {
                this.asyncWriteCache.delete(fileName);
                this.backend.deleteRecord(identifier);
                this.cache.delete(fileName);
            }
            catch (IOException ioe) {
                throw new DataStoreException(ioe);
            }
        }
    }

    @Override
    public synchronized int deleteAllOlderThan(long min) throws DataStoreException {
        Set<DataIdentifier> diSet = this.backend.deleteAllOlderThan(min);
        for (DataIdentifier identifier : diSet) {
            this.cache.delete(CachingDataStore.getFileName(identifier));
        }
        try {
            for (String fileName : this.asyncWriteCache.deleteOlderThan(min)) {
                diSet.add(CachingDataStore.getIdentifier(fileName));
            }
        }
        catch (IOException e) {
            throw new DataStoreException(e);
        }
        LOG.info("deleteAllOlderThan  exit. Deleted [" + diSet + "] records. Number of records deleted [" + diSet.size() + "]");
        return diSet.size();
    }

    InputStream getStream(DataIdentifier identifier) throws DataStoreException {
        InputStream in = null;
        try {
            String fileName = CachingDataStore.getFileName(identifier);
            InputStream cached = this.cache.getIfStored(fileName);
            if (cached != null) {
                InputStream inputStream = cached;
                return inputStream;
            }
            in = this.backend.read(identifier);
            InputStream inputStream = this.cache.store(fileName, in);
            IOUtils.closeQuietly((InputStream)in);
            return inputStream;
        }
        catch (IOException e) {
            throw new DataStoreException("IO Exception: " + identifier, e);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public long getLastModified(DataIdentifier identifier) throws DataStoreException {
        String fileName;
        long lastModified;
        if (LOG.isDebugEnabled()) {
            LOG.debug("accessed lastModified of identifier:" + identifier);
        }
        if ((lastModified = this.asyncWriteCache.getLastModified(fileName = CachingDataStore.getFileName(identifier))) != 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getlastModified of identifier [" + identifier + "] from AsyncUploadCache = " + lastModified);
            }
            return lastModified;
        }
        return this.backend.getLastModified(identifier);
    }

    public long getLength(DataIdentifier identifier) throws DataStoreException {
        String fileName = CachingDataStore.getFileName(identifier);
        Long length = this.cache.getFileLength(fileName);
        if (length != null) {
            return length;
        }
        InputStream in = null;
        InputStream cachedStream = null;
        try {
            in = this.backend.read(identifier);
            cachedStream = this.cache.store(fileName, in);
        }
        catch (IOException e) {
            try {
                throw new DataStoreException("IO Exception: " + identifier, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(cachedStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((InputStream)cachedStream);
        length = this.cache.getFileLength(fileName);
        if (length != null) {
            return length;
        }
        return this.backend.getLength(identifier);
    }

    @Override
    protected byte[] getOrCreateReferenceKey() throws DataStoreException {
        try {
            return this.secret.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new DataStoreException(e);
        }
    }

    public Set<String> getPendingUploads() {
        return this.asyncWriteCache.getAll();
    }

    @Override
    public void call(DataIdentifier identifier, File file, AsyncUploadCallback.RESULT resultCode) {
        String fileName = CachingDataStore.getFileName(identifier);
        if (AsyncUploadCallback.RESULT.SUCCESS.equals((Object)resultCode)) {
            try {
                AsyncUploadCacheResult result;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Upload completed. [" + identifier + "].");
                }
                if ((result = this.asyncWriteCache.remove(fileName)).doRequiresDelete()) {
                    this.deleteRecord(identifier);
                }
            }
            catch (IOException ie) {
                LOG.warn("Cannot remove pending file upload. Dataidentifer [ " + identifier + "], file [" + file.getAbsolutePath() + "]", (Throwable)ie);
            }
            catch (DataStoreException dse) {
                LOG.warn("Cannot remove pending file upload. Dataidentifer [ " + identifier + "], file [" + file.getAbsolutePath() + "]", (Throwable)((Object)dse));
            }
        } else if (AsyncUploadCallback.RESULT.FAILED.equals((Object)resultCode)) {
            LOG.error("Async Upload failed. Dataidentifer [ " + identifier + "], file [" + file.getAbsolutePath() + "]");
        } else if (AsyncUploadCallback.RESULT.ABORTED.equals((Object)resultCode)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Async Upload Aborted. Dataidentifer [ " + identifier + "], file [" + file.getAbsolutePath() + "]");
            }
            try {
                this.asyncWriteCache.remove(fileName);
                LOG.info("Async Upload Aborted. Dataidentifer [ " + identifier + "], file [" + file.getAbsolutePath() + "] removed.");
            }
            catch (IOException ie) {
                LOG.warn("Cannot remove pending file upload. Dataidentifer [ " + identifier + "], file [" + file.getAbsolutePath() + "]", (Throwable)ie);
            }
        }
    }

    private File newTemporaryFile() throws IOException {
        return File.createTempFile(TMP, null, this.tmpDir);
    }

    private void uploadFilesFromCache() throws RepositoryException {
        ArrayList<File> files = new ArrayList<File>();
        CachingDataStore.listRecursive(files, this.directory);
        long totalSize = 0L;
        for (File f : files) {
            totalSize += f.length();
        }
        if (this.concurrentUploadsThreads > 1) {
            new FilesUploader(files, totalSize, this.concurrentUploadsThreads, false).upload();
        } else {
            this.uploadFilesInSingleThread(files, totalSize);
        }
    }

    private void uploadFilesInSingleThread(List<File> files, long totalSize) throws RepositoryException {
        long startTime = System.currentTimeMillis();
        LOG.info("Upload:  {" + files.size() + "} files in single thread.");
        long currentCount = 0L;
        long currentSize = 0L;
        long time = System.currentTimeMillis();
        for (File f : files) {
            long now = System.currentTimeMillis();
            if (now > time + 5000L) {
                LOG.info("Uploaded:  {" + currentCount + "}/{" + files.size() + "} files, {" + currentSize + "}/{" + totalSize + "} size data");
                time = now;
            }
            String name = f.getName();
            if (LOG.isDebugEnabled()) {
                LOG.debug("upload file = " + name);
            }
            if (!name.startsWith(TMP) && !name.endsWith(DS_STORE) && f.length() > 0L) {
                this.uploadFileToBackEnd(f, false);
            }
            currentSize += f.length();
            ++currentCount;
        }
        long endTime = System.currentTimeMillis();
        LOG.info("Uploaded:  {" + currentCount + "}/{" + files.size() + "} files, {" + currentSize + "}/{" + totalSize + "} size data, time taken {" + (endTime - startTime) / 1000L + "} sec");
    }

    private static void listRecursive(List<File> list, File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    CachingDataStore.listRecursive(list, f);
                    continue;
                }
                list.add(f);
            }
        }
    }

    private void uploadFileToBackEnd(File f, boolean updateAsyncUploadCache) throws DataStoreException {
        try {
            DataIdentifier identifier = new DataIdentifier(f.getName());
            this.usesIdentifier(identifier);
            this.backend.write(identifier, f);
            if (updateAsyncUploadCache) {
                String fileName = CachingDataStore.getFileName(identifier);
                this.asyncWriteCache.remove(fileName);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(f.getName() + "uploaded.");
            }
        }
        catch (IOException ioe) {
            throw new DataStoreException(ioe);
        }
    }

    private static String getFileName(DataIdentifier identifier) {
        String name = identifier.toString();
        return CachingDataStore.getFileName(name);
    }

    private static String getFileName(String name) {
        return name.substring(0, 2) + "/" + name.substring(2, 4) + "/" + name.substring(4, 6) + "/" + name;
    }

    private static DataIdentifier getIdentifier(String fileName) {
        return new DataIdentifier(fileName.substring(fileName.lastIndexOf("/") + 1));
    }

    private void usesIdentifier(DataIdentifier identifier) {
        this.inUse.put(identifier, new WeakReference<DataIdentifier>(identifier));
    }

    private static boolean mkdirs(File dir) throws IOException {
        if (dir.exists()) {
            if (dir.isFile()) {
                throw new IOException("Can not create a directory because a file exists with the same name: " + dir.getAbsolutePath());
            }
            return false;
        }
        boolean created = dir.mkdirs();
        if (!created) {
            throw new IOException("Could not create directory: " + dir.getAbsolutePath());
        }
        return created;
    }

    @Override
    public void clearInUse() {
        this.inUse.clear();
    }

    public boolean isInUse(DataIdentifier identifier) {
        return this.inUse.containsKey(identifier);
    }

    @Override
    public void close() throws DataStoreException {
        this.cache.close();
        this.backend.close();
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setMinRecordLength(int minRecordLength) {
        this.minRecordLength = minRecordLength;
    }

    @Override
    public int getMinRecordLength() {
        return this.minRecordLength;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public double getCachePurgeTrigFactor() {
        return this.cachePurgeTrigFactor;
    }

    public void setCachePurgeTrigFactor(double cachePurgeTrigFactor) {
        this.cachePurgeTrigFactor = cachePurgeTrigFactor;
    }

    public double getCachePurgeResizeFactor() {
        return this.cachePurgeResizeFactor;
    }

    public void setCachePurgeResizeFactor(double cachePurgeResizeFactor) {
        this.cachePurgeResizeFactor = cachePurgeResizeFactor;
    }

    public int getConcurrentUploadsThreads() {
        return this.concurrentUploadsThreads;
    }

    public void setConcurrentUploadsThreads(int concurrentUploadsThreads) {
        this.concurrentUploadsThreads = concurrentUploadsThreads;
    }

    public int getAsyncUploadLimit() {
        return this.asyncUploadLimit;
    }

    public void setAsyncUploadLimit(int asyncUploadLimit) {
        this.asyncUploadLimit = asyncUploadLimit;
    }

    public boolean isContinueOnAsyncUploadFailure() {
        return this.continueOnAsyncUploadFailure;
    }

    public void setContinueOnAsyncUploadFailure(boolean continueOnAsyncUploadFailure) {
        this.continueOnAsyncUploadFailure = continueOnAsyncUploadFailure;
    }

    public Backend getBackend() {
        return this.backend;
    }

    private class FileUploaderThread
    implements Runnable {
        final List<File> files;
        final FilesUploader filesUploader;
        final int startIndex;
        final int endIndex;
        final boolean updateAsyncCache;

        FileUploaderThread(List<File> files, int startIndex, int endIndex, FilesUploader controller, boolean updateAsyncCache) {
            this.files = files;
            this.filesUploader = controller;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.updateAsyncCache = updateAsyncCache;
        }

        @Override
        public void run() {
            block6: {
                long time = System.currentTimeMillis();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Thread [ " + Thread.currentThread().getName() + "]: Uploading files from startIndex[" + this.startIndex + "] and endIndex [" + (this.endIndex - 1) + "], both inclusive.");
                }
                int uploadCount = 0;
                long uploadSize = 0L;
                try {
                    for (File f : this.files) {
                        if (this.filesUploader.isExceptionRaised()) break;
                        String name = f.getName();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("upload file = " + name);
                        }
                        if (!name.startsWith(CachingDataStore.TMP) && !name.endsWith(CachingDataStore.DS_STORE) && f.length() > 0L) {
                            CachingDataStore.this.uploadFileToBackEnd(f, this.updateAsyncCache);
                        }
                        ++uploadCount;
                        uploadSize += f.length();
                        long now = System.currentTimeMillis();
                        if (now <= time + 15000L) continue;
                        this.filesUploader.addCurrentCount(uploadCount);
                        this.filesUploader.addCurrentSize(uploadSize);
                        uploadCount = 0;
                        uploadSize = 0L;
                        time = now;
                    }
                    this.filesUploader.addCurrentCount(uploadCount);
                    this.filesUploader.addCurrentSize(uploadSize);
                }
                catch (DataStoreException e) {
                    if (this.filesUploader.isExceptionRaised()) break block6;
                    this.filesUploader.setException(e);
                }
            }
        }
    }

    private class FilesUploader {
        final List<File> files;
        final long totalSize;
        volatile AtomicInteger currentCount = new AtomicInteger();
        volatile AtomicLong currentSize = new AtomicLong();
        volatile AtomicBoolean exceptionRaised = new AtomicBoolean();
        DataStoreException exception;
        final int threads;
        final boolean updateAsyncCache;

        FilesUploader(List<File> files, long totalSize, int threads, boolean updateAsyncCache) {
            this.files = files;
            this.threads = threads;
            this.totalSize = totalSize;
            this.updateAsyncCache = updateAsyncCache;
        }

        void addCurrentCount(int delta) {
            this.currentCount.addAndGet(delta);
        }

        void addCurrentSize(long delta) {
            this.currentSize.addAndGet(delta);
        }

        synchronized void setException(DataStoreException exception) {
            this.exceptionRaised.getAndSet(true);
            this.exception = exception;
        }

        boolean isExceptionRaised() {
            return this.exceptionRaised.get();
        }

        void logProgress() {
            LOG.info("Uploaded:  {" + this.currentCount.get() + "}/{" + this.files.size() + "} files, {" + this.currentSize.get() + "}/{" + this.totalSize + "} size data");
        }

        void upload() throws DataStoreException {
            long startTime = System.currentTimeMillis();
            LOG.info(" Uploading " + this.files.size() + " using " + this.threads + " threads.");
            ExecutorService executor = Executors.newFixedThreadPool(this.threads, new NamedThreadFactory("backend-file-upload-worker"));
            int partitionSize = this.files.size() / this.threads;
            int startIndex = 0;
            int endIndex = partitionSize;
            for (int i = 1; i <= this.threads; ++i) {
                List<File> partitionFileList = Collections.unmodifiableList(this.files.subList(startIndex, endIndex));
                FileUploaderThread fut = new FileUploaderThread(partitionFileList, startIndex, endIndex, this, this.updateAsyncCache);
                executor.execute(fut);
                startIndex = endIndex;
                endIndex = i == this.threads - 1 ? this.files.size() : startIndex + partitionSize;
            }
            executor.shutdown();
            try {
                while (!this.isExceptionRaised() && !executor.awaitTermination(15L, TimeUnit.SECONDS)) {
                    this.logProgress();
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            long endTime = System.currentTimeMillis();
            LOG.info("Uploaded:  {" + this.currentCount.get() + "}/{" + this.files.size() + "} files, {" + this.currentSize.get() + "}/{" + this.totalSize + "} size data, time taken {" + (endTime - startTime) / 1000L + "} sec");
            if (this.isExceptionRaised()) {
                executor.shutdownNow();
                throw this.exception;
            }
        }
    }
}

