/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.client;

import java.rmi.RemoteException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.rmi.client.ClientObject;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.client.RemoteRepositoryException;
import org.apache.jackrabbit.rmi.remote.RemoteVersionManager;

public class ClientVersionManager
extends ClientObject
implements VersionManager {
    private Session session;
    private RemoteVersionManager remote;

    public ClientVersionManager(Session session, RemoteVersionManager remote, LocalAdapterFactory factory) {
        super(factory);
        this.session = session;
        this.remote = remote;
    }

    public void cancelMerge(String absPath, Version version) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("TODO: JCR-3206");
    }

    public Version checkin(String absPath) throws RepositoryException {
        try {
            return this.getFactory().getVersion(this.session, this.remote.checkin(absPath));
        }
        catch (RemoteException e) {
            throw new RemoteRepositoryException(e);
        }
    }

    public void checkout(String absPath) throws RepositoryException {
        try {
            this.remote.checkout(absPath);
        }
        catch (RemoteException e) {
            throw new RemoteRepositoryException(e);
        }
    }

    public Version checkpoint(String absPath) throws RepositoryException {
        try {
            return this.getFactory().getVersion(this.session, this.remote.checkpoint(absPath));
        }
        catch (RemoteException e) {
            throw new RemoteRepositoryException(e);
        }
    }

    public Node createActivity(String title) throws RepositoryException {
        try {
            return this.getFactory().getNode(this.session, this.remote.createActivity(title));
        }
        catch (RemoteException e) {
            throw new RemoteRepositoryException(e);
        }
    }

    public Node createConfiguration(String absPath) throws RepositoryException {
        try {
            return this.getFactory().getNode(this.session, this.remote.createConfiguration(absPath));
        }
        catch (RemoteException e) {
            throw new RemoteRepositoryException(e);
        }
    }

    public void doneMerge(String absPath, Version version) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("TODO: JCR-3206");
    }

    public Node getActivity() throws RepositoryException {
        try {
            return this.getFactory().getNode(this.session, this.remote.getActivity());
        }
        catch (RemoteException e) {
            throw new RemoteRepositoryException(e);
        }
    }

    public Version getBaseVersion(String absPath) throws RepositoryException {
        try {
            return this.getFactory().getVersion(this.session, this.remote.getBaseVersion(absPath));
        }
        catch (RemoteException e) {
            throw new RemoteRepositoryException(e);
        }
    }

    public VersionHistory getVersionHistory(String absPath) throws RepositoryException {
        try {
            return this.getFactory().getVersionHistory(this.session, this.remote.getVersionHistory(absPath));
        }
        catch (RemoteException e) {
            throw new RemoteRepositoryException(e);
        }
    }

    public boolean isCheckedOut(String absPath) throws RepositoryException {
        try {
            return this.remote.isCheckedOut(absPath);
        }
        catch (RemoteException e) {
            throw new RemoteRepositoryException(e);
        }
    }

    public NodeIterator merge(Node activityNode) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("TODO: JCR-3206");
    }

    public NodeIterator merge(String absPath, String srcWorkspace, boolean bestEffort) throws RepositoryException {
        try {
            return this.getFactory().getNodeIterator(this.session, this.remote.merge(absPath, srcWorkspace, bestEffort));
        }
        catch (RemoteException e) {
            throw new RemoteRepositoryException(e);
        }
    }

    public NodeIterator merge(String absPath, String srcWorkspace, boolean bestEffort, boolean isShallow) throws RepositoryException {
        try {
            return this.getFactory().getNodeIterator(this.session, this.remote.merge(absPath, srcWorkspace, bestEffort, isShallow));
        }
        catch (RemoteException e) {
            throw new RemoteRepositoryException(e);
        }
    }

    public void removeActivity(Node activityNode) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("TODO: JCR-3206");
    }

    public void restore(Version[] versions, boolean removeExisting) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("TODO: JCR-3206");
    }

    public void restore(Version version, boolean removeExisting) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("TODO: JCR-3206");
    }

    public void restore(String absPath, String versionName, boolean removeExisting) throws RepositoryException {
        try {
            this.remote.restore(absPath, versionName, removeExisting);
        }
        catch (RemoteException e) {
            throw new RemoteRepositoryException(e);
        }
    }

    public void restore(String absPath, Version version, boolean removeExisting) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("TODO: JCR-3206");
    }

    public void restoreByLabel(String absPath, String versionLabel, boolean removeExisting) throws RepositoryException {
        try {
            this.remote.restoreByLabel(absPath, versionLabel, removeExisting);
        }
        catch (RemoteException e) {
            throw new RemoteRepositoryException(e);
        }
    }

    public Node setActivity(Node activity) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("TODO: JCR-3206");
    }
}

