/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.observation;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.jackrabbit.rmi.iterator.ArrayEventIterator;
import org.apache.jackrabbit.rmi.remote.RemoteEventCollection;
import org.apache.jackrabbit.rmi.remote.RemoteObservationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientEventPoll
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ClientEventPoll.class);
    private static final long POLL_TIMEOUT = 5000L;
    private static final String THREAD_NAME = "Client Event Poller";
    private static long counter = 0L;
    private final RemoteObservationManager remote;
    private final Session session;
    private Map listenerMap = new HashMap();
    private Map idMap = new HashMap();
    private boolean running = true;

    public ClientEventPoll(RemoteObservationManager remote, Session session) throws NullPointerException {
        super(THREAD_NAME);
        if (remote == null) {
            throw new NullPointerException("remote");
        }
        if (session == null) {
            throw new NullPointerException("session");
        }
        this.remote = remote;
        this.session = session;
    }

    public synchronized long addListener(EventListener listener) {
        Long id = new Long(counter++);
        this.listenerMap.put(id, listener);
        this.idMap.put(listener, id);
        return id;
    }

    public synchronized long removeListener(EventListener listener) {
        Long key = (Long)this.idMap.remove(listener);
        if (key != null) {
            this.listenerMap.remove(key);
            return key;
        }
        return -1L;
    }

    public synchronized EventListener[] getListeners() {
        return this.listenerMap.values().toArray(new EventListener[this.listenerMap.size()]);
    }

    public void terminate() {
        this.running = false;
    }

    @Override
    public void run() {
        while (this.running && this.session.isLive()) {
            try {
                Long id;
                EventListener listener;
                RemoteEventCollection remoteEvent = this.remote.getNextEvent(5000L);
                if (remoteEvent == null || (listener = (EventListener)this.listenerMap.get(id = new Long(remoteEvent.getListenerId()))) == null) continue;
                RemoteEventCollection.RemoteEvent[] remoteEvents = remoteEvent.getEvents();
                EventIterator events = this.toEvents(remoteEvents);
                try {
                    listener.onEvent(events);
                }
                catch (Exception e) {
                    log.error("Unexpected failure of Listener " + listener, (Throwable)e);
                }
            }
            catch (RemoteException re) {
                log.error("Problem handling event. Looking for next one.", (Throwable)re);
            }
        }
    }

    private EventIterator toEvents(RemoteEventCollection.RemoteEvent[] remoteEvents) throws RemoteException {
        Event[] events = new Event[remoteEvents.length];
        for (int i = 0; i < events.length; ++i) {
            events[i] = new JCREvent(remoteEvents[i]);
        }
        return new ArrayEventIterator(events);
    }

    private static class JCREvent
    implements Event {
        private final int type;
        private final String path;
        private final String userID;

        private JCREvent(RemoteEventCollection.RemoteEvent remoteEvent) throws RemoteException {
            this.type = remoteEvent.getType();
            this.path = remoteEvent.getPath();
            this.userID = remoteEvent.getUserID();
        }

        public int getType() {
            return this.type;
        }

        public String getPath() {
            return this.path;
        }

        public String getUserID() {
            return this.userID;
        }

        public long getDate() throws RepositoryException {
            throw new UnsupportedRepositoryOperationException("TODO: JCR-3206");
        }

        public String getIdentifier() throws RepositoryException {
            throw new UnsupportedRepositoryOperationException("TODO: JCR-3206");
        }

        public Map getInfo() throws RepositoryException {
            throw new UnsupportedRepositoryOperationException("TODO: JCR-3206");
        }

        public String getUserData() throws RepositoryException {
            throw new UnsupportedRepositoryOperationException("TODO: JCR-3206");
        }
    }
}

