/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server;

import java.rmi.RemoteException;
import javax.jcr.RepositoryException;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.rmi.remote.RemoteIterator;
import org.apache.jackrabbit.rmi.remote.RemoteNode;
import org.apache.jackrabbit.rmi.remote.RemoteVersion;
import org.apache.jackrabbit.rmi.remote.RemoteVersionHistory;
import org.apache.jackrabbit.rmi.remote.RemoteVersionManager;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.ServerObject;

public class ServerVersionManager
extends ServerObject
implements RemoteVersionManager {
    private final VersionManager manager;

    public ServerVersionManager(VersionManager manager, RemoteAdapterFactory factory) throws RemoteException {
        super(factory);
        this.manager = manager;
    }

    @Override
    public RemoteVersion checkin(String absPath) throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteVersion(this.manager.checkin(absPath));
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public void checkout(String absPath) throws RepositoryException {
        try {
            this.manager.checkout(absPath);
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public RemoteVersion checkpoint(String absPath) throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteVersion(this.manager.checkpoint(absPath));
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public RemoteNode createActivity(String title) throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteNode(this.manager.createActivity(title));
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public RemoteNode createConfiguration(String absPath) throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteNode(this.manager.createConfiguration(absPath));
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public RemoteNode getActivity() throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteNode(this.manager.getActivity());
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public RemoteVersion getBaseVersion(String absPath) throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteVersion(this.manager.getBaseVersion(absPath));
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public RemoteVersionHistory getVersionHistory(String absPath) throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteVersionHistory(this.manager.getVersionHistory(absPath));
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public boolean isCheckedOut(String absPath) throws RepositoryException {
        try {
            return this.manager.isCheckedOut(absPath);
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public RemoteIterator merge(String absPath, String srcWorkspace, boolean bestEffort) throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteNodeIterator(this.manager.merge(absPath, srcWorkspace, bestEffort));
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public RemoteIterator merge(String absPath, String srcWorkspace, boolean bestEffort, boolean isShallow) throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteNodeIterator(this.manager.merge(absPath, srcWorkspace, bestEffort, isShallow));
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public void restore(String absPath, String versionName, boolean removeExisting) throws RepositoryException {
        try {
            this.manager.restore(absPath, versionName, removeExisting);
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public void restoreByLabel(String absPath, String versionLabel, boolean removeExisting) throws RepositoryException {
        try {
            this.manager.restoreByLabel(absPath, versionLabel, removeExisting);
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    public void cancelMerge(String absPath, RemoteVersion version) throws RepositoryException, RemoteException {
    }

    public void doneMerge(String absPath, RemoteVersion version) throws RepositoryException, RemoteException {
    }
}

