/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.server.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.server.io.DefaultHandler;
import org.apache.jackrabbit.server.io.ExportContext;
import org.apache.jackrabbit.server.io.IOManager;
import org.apache.jackrabbit.server.io.ImportContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlHandler
extends DefaultHandler {
    private static Logger log;
    public static final String XML_MIMETYPE = "text/xml";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.server.io.XmlHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public XmlHandler() {
    }

    public XmlHandler(IOManager ioManager) {
        super(ioManager, "nt:unstructured", "nt:file", "nt:unstructured");
    }

    public XmlHandler(IOManager ioManager, String collectionNodetype, String defaultNodetype, String contentNodetype) {
        super(ioManager, collectionNodetype, defaultNodetype, contentNodetype);
    }

    public boolean canImport(ImportContext context, boolean isCollection) {
        if (context == null || context.isCompleted()) {
            return false;
        }
        boolean isXmlMimeType = XML_MIMETYPE.equals(context.getMimeType());
        return isXmlMimeType && context.hasStream() && context.getContentLength() > 0L && super.canImport(context, isCollection);
    }

    protected boolean importData(ImportContext context, boolean isCollection, Node contentNode) throws IOException, RepositoryException {
        InputStream in = context.getInputStream();
        int uuidBehavior = isCollection ? 1 : 0;
        try {
            contentNode.getSession().importXML(contentNode.getPath(), in, uuidBehavior);
        }
        finally {
            in.close();
        }
        return true;
    }

    protected boolean importProperties(ImportContext context, boolean isCollection, Node contentNode) {
        boolean success = super.importProperties(context, isCollection, contentNode);
        if (success) {
            try {
                contentNode.setProperty("jcr:encoding", "UTF-8");
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return success;
    }

    protected boolean forceCompatibleContentNodes() {
        return true;
    }

    public boolean canExport(ExportContext context, boolean isCollection) {
        if (super.canExport(context, isCollection)) {
            String mimeType = null;
            try {
                Node contentNode = this.getContentNode(context, isCollection);
                mimeType = contentNode.hasProperty("jcr:mimeType") ? contentNode.getProperty("jcr:mimeType").getString() : context.getMimeResolver().getMimeType(context.getExportRoot().getName());
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            return XML_MIMETYPE.equals(mimeType);
        }
        return false;
    }

    protected void exportData(ExportContext context, boolean isCollection, Node contentNode) throws IOException, RepositoryException {
        if (contentNode.getNodes().hasNext()) {
            contentNode = contentNode.getNodes().nextNode();
        }
        OutputStream out = context.getOutputStream();
        contentNode.getSession().exportDocumentView(contentNode.getPath(), out, true, false);
    }

    protected void exportProperties(ExportContext context, boolean isCollection, Node contentNode) throws IOException {
        super.exportProperties(context, isCollection, contentNode);
        try {
            if (!contentNode.hasProperty("jcr:mimeType")) {
                context.setContentType(XML_MIMETYPE, "UTF-8");
            }
        }
        catch (RepositoryException e) {
            throw new IOException(e.getMessage());
        }
    }
}

