/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.observation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.jcr.JcrDavException;
import org.apache.jackrabbit.webdav.jcr.JcrDavSession;
import org.apache.jackrabbit.webdav.jcr.observation.SubscriptionImpl;
import org.apache.jackrabbit.webdav.jcr.transaction.TransactionListener;
import org.apache.jackrabbit.webdav.observation.EventDiscovery;
import org.apache.jackrabbit.webdav.observation.ObservationResource;
import org.apache.jackrabbit.webdav.observation.Subscription;
import org.apache.jackrabbit.webdav.observation.SubscriptionDiscovery;
import org.apache.jackrabbit.webdav.observation.SubscriptionInfo;
import org.apache.jackrabbit.webdav.observation.SubscriptionManager;
import org.apache.jackrabbit.webdav.transaction.TransactionResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SubscriptionManagerImpl
implements SubscriptionManager,
TransactionListener {
    private static Logger log;
    private final SubscriptionMap subscriptions = new SubscriptionMap();
    private final Map transactionListenerById = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.observation.SubscriptionManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public SubscriptionDiscovery getSubscriptionDiscovery(ObservationResource resource) {
        Subscription[] subsForResource = this.subscriptions.getByPath(resource.getLocator());
        return new SubscriptionDiscovery(subsForResource);
    }

    public Subscription subscribe(SubscriptionInfo info, String subscriptionId, ObservationResource resource) throws DavException {
        Object subscription;
        if (subscriptionId == null) {
            SubscriptionImpl newSubs = new SubscriptionImpl(info, resource);
            this.registerSubscription(newSubs, resource);
            this.subscriptions.put(newSubs.getSubscriptionId(), newSubs);
            resource.getSession().addReference((Object)newSubs.getSubscriptionId());
            subscription = newSubs;
        } else {
            SubscriptionImpl existing = this.validate(subscriptionId, resource);
            existing.setInfo(info);
            this.registerSubscription(existing, resource);
            subscription = new WrappedSubscription(existing);
        }
        return subscription;
    }

    private void registerSubscription(SubscriptionImpl subscription, ObservationResource resource) throws DavException {
        try {
            Session session = SubscriptionManagerImpl.getRepositorySession(resource);
            ObservationManager oMgr = session.getWorkspace().getObservationManager();
            String itemPath = subscription.getLocator().getRepositoryPath();
            oMgr.addEventListener((EventListener)subscription, subscription.getJcrEventTypes(), itemPath, subscription.isDeep(), subscription.getUuidFilters(), subscription.getNodetypeNameFilters(), subscription.isNoLocal());
        }
        catch (RepositoryException e) {
            log.error("Unable to register eventlistener: " + e.getMessage());
            throw new JcrDavException(e);
        }
    }

    public void unsubscribe(String subscriptionId, ObservationResource resource) throws DavException {
        SubscriptionImpl subs = this.validate(subscriptionId, resource);
        this.unregisterSubscription(subs, resource);
    }

    private void unregisterSubscription(SubscriptionImpl subscription, ObservationResource resource) throws DavException {
        try {
            Session session = SubscriptionManagerImpl.getRepositorySession(resource);
            session.getWorkspace().getObservationManager().removeEventListener((EventListener)subscription);
            String sId = subscription.getSubscriptionId();
            this.subscriptions.remove(sId);
            resource.getSession().removeReference((Object)sId);
        }
        catch (RepositoryException e) {
            log.error("Unable to remove eventlistener: " + e.getMessage());
            throw new JcrDavException(e);
        }
    }

    public EventDiscovery poll(String subscriptionId, long timeout, ObservationResource resource) throws DavException {
        SubscriptionImpl subs = this.validate(subscriptionId, resource);
        return subs.discoverEvents(timeout);
    }

    private SubscriptionImpl validate(String subscriptionId, ObservationResource resource) throws DavException {
        if (this.subscriptions.contains(subscriptionId)) {
            SubscriptionImpl subs = (SubscriptionImpl)this.subscriptions.get(subscriptionId);
            if (!subs.isSubscribedToResource(resource)) {
                throw new DavException(412, "Attempt to operate on subscription with invalid resource path.");
            }
            if (subs.isExpired()) {
                this.unregisterSubscription(subs, resource);
                throw new DavException(412, "Attempt to  operate on expired subscription.");
            }
            return subs;
        }
        throw new DavException(412, "Attempt to modify or to poll for non-existing subscription.");
    }

    private static Session getRepositorySession(ObservationResource resource) throws DavException {
        return JcrDavSession.getRepositorySession(resource.getSession());
    }

    public synchronized void beforeCommit(TransactionResource resource, String lockToken) {
        ArrayList<TransactionListener> transactionListeners = new ArrayList<TransactionListener>();
        Iterator it = this.subscriptions.iterator();
        while (it.hasNext()) {
            SubscriptionImpl sub = (SubscriptionImpl)it.next();
            TransactionListener tl = sub.createTransactionListener();
            tl.beforeCommit(resource, lockToken);
            transactionListeners.add(tl);
        }
        this.transactionListenerById.put(lockToken, transactionListeners);
    }

    public void afterCommit(TransactionResource resource, String lockToken, boolean success) {
        List transactionListeners = (List)this.transactionListenerById.remove(lockToken);
        if (transactionListeners != null) {
            Iterator it = transactionListeners.iterator();
            while (it.hasNext()) {
                TransactionListener txListener = (TransactionListener)it.next();
                txListener.afterCommit(resource, lockToken, success);
            }
        }
    }

    private class SubscriptionMap {
        private HashMap subscriptions = new HashMap();
        private HashMap ids = new HashMap();

        private SubscriptionMap() {
        }

        private boolean contains(String subscriptionId) {
            return this.subscriptions.containsKey(subscriptionId);
        }

        private Subscription get(String subscriptionId) {
            return (Subscription)this.subscriptions.get(subscriptionId);
        }

        private Iterator iterator() {
            return this.subscriptions.values().iterator();
        }

        private void put(String subscriptionId, SubscriptionImpl subscription) {
            Set<String> idSet;
            this.subscriptions.put(subscriptionId, subscription);
            DavResourceLocator key = subscription.getLocator();
            if (this.ids.containsKey(key)) {
                idSet = (Set)this.ids.get(key);
            } else {
                idSet = new HashSet();
                this.ids.put(key, idSet);
            }
            if (!idSet.contains(subscriptionId)) {
                idSet.add(subscriptionId);
            }
        }

        private void remove(String subscriptionId) {
            SubscriptionImpl sub = (SubscriptionImpl)this.subscriptions.remove(subscriptionId);
            ((Set)this.ids.get(sub.getLocator())).remove(subscriptionId);
        }

        private Subscription[] getByPath(DavResourceLocator locator) {
            Set idSet = (Set)this.ids.get(locator);
            if (idSet != null && !idSet.isEmpty()) {
                Iterator idIterator = idSet.iterator();
                Subscription[] subsForResource = new Subscription[idSet.size()];
                int i = 0;
                while (idIterator.hasNext()) {
                    SubscriptionImpl s = (SubscriptionImpl)this.subscriptions.get(idIterator.next());
                    subsForResource[i] = new WrappedSubscription(s);
                }
                return subsForResource;
            }
            return new Subscription[0];
        }
    }

    private class WrappedSubscription
    implements Subscription {
        private final Subscription delegatee;

        private WrappedSubscription(Subscription subsc) {
            this.delegatee = subsc;
        }

        public String getSubscriptionId() {
            return null;
        }

        public Element toXml(Document document) {
            return this.delegatee.toXml(document);
        }
    }
}

