/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.property;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.jcr.ItemResourceConstants;
import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NamespacesProperty
extends AbstractDavProperty
implements ItemResourceConstants {
    private static Logger log;
    private final Map value = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.jcr.property.NamespacesProperty");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public NamespacesProperty(NamespaceRegistry nsReg) throws RepositoryException {
        super(JCR_NAMESPACES, false);
        if (nsReg != null) {
            String[] prefixes = nsReg.getPrefixes();
            int i = 0;
            while (i < prefixes.length) {
                this.value.put(prefixes[i], nsReg.getURI(prefixes[i]));
                ++i;
            }
        }
    }

    public NamespacesProperty(Map namespaces) {
        super(JCR_NAMESPACES, false);
        this.value.putAll(namespaces);
    }

    public NamespacesProperty(DavProperty property) throws DavException {
        super(JCR_NAMESPACES, false);
        Object v = property.getValue();
        if (!(v instanceof List)) {
            log.warn("Unexpected structure of dcr:namespace property.");
            throw new DavException(500);
        }
        Iterator it = ((List)v).iterator();
        while (it.hasNext()) {
            Element e;
            Object listEntry = it.next();
            if (!(listEntry instanceof Element) || !"namespace".equals((e = (Element)listEntry).getLocalName())) continue;
            Element pElem = DomUtil.getChildElement((Node)e, (String)"prefix", (Namespace)ItemResourceConstants.NAMESPACE);
            String prefix = DomUtil.getText((Element)pElem, (String)Namespace.EMPTY_NAMESPACE.getPrefix());
            Element uElem = DomUtil.getChildElement((Node)e, (String)"uri", (Namespace)ItemResourceConstants.NAMESPACE);
            String uri = DomUtil.getText((Element)uElem, (String)Namespace.EMPTY_NAMESPACE.getURI());
            this.value.put(prefix, uri);
        }
    }

    public Map getNamespaces() {
        return Collections.unmodifiableMap(this.value);
    }

    public Object getValue() {
        return Collections.unmodifiableMap(this.value);
    }

    public Element toXml(Document document) {
        Element elem = this.getName().toXml(document);
        Iterator prefixes = this.value.keySet().iterator();
        while (prefixes.hasNext()) {
            String prefix = (String)prefixes.next();
            String uri = (String)this.value.get(prefix);
            Element nsElem = DomUtil.addChildElement((Element)elem, (String)"namespace", (Namespace)ItemResourceConstants.NAMESPACE);
            DomUtil.addChildElement((Element)nsElem, (String)"prefix", (Namespace)ItemResourceConstants.NAMESPACE, (String)prefix);
            DomUtil.addChildElement((Element)nsElem, (String)"uri", (Namespace)ItemResourceConstants.NAMESPACE, (String)uri);
        }
        return elem;
    }
}

