/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.version.report;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.jcr.ItemResourceConstants;
import org.apache.jackrabbit.webdav.jcr.JcrDavException;
import org.apache.jackrabbit.webdav.jcr.version.report.AbstractJcrReport;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LocateByUuidReport
extends AbstractJcrReport {
    private static Logger log;
    private static final String REPORT_NAME = "locate-by-uuid";
    public static final ReportType LOCATE_BY_UUID_REPORT;
    private MultiStatus ms;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.jcr.version.report.LocateByUuidReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.apache.jackrabbit.webdav.jcr.version.report.LocateByUuidReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOCATE_BY_UUID_REPORT = ReportType.register((String)REPORT_NAME, (Namespace)ItemResourceConstants.NAMESPACE, (Class)clazz2);
    }

    public ReportType getType() {
        return LOCATE_BY_UUID_REPORT;
    }

    public boolean isMultiStatusReport() {
        return true;
    }

    public void init(DavResource resource, ReportInfo info) throws DavException {
        super.init(resource, info);
        if (!info.containsContentElement("href", DavConstants.NAMESPACE)) {
            throw new DavException(400, "dcr:locate-by-uuid element must at least contain a single DAV:href child.");
        }
        try {
            Element hrefElem = info.getContentElement("href", DavConstants.NAMESPACE);
            String uuid = DomUtil.getTextTrim((Element)hrefElem);
            DavResourceLocator resourceLoc = resource.getLocator();
            Node n = this.getRepositorySession().getNodeByUUID(uuid);
            DavResourceLocator loc = resourceLoc.getFactory().createResourceLocator(resourceLoc.getPrefix(), resourceLoc.getWorkspacePath(), n.getPath(), false);
            DavResource locatedResource = resource.getFactory().createResource(loc, resource.getSession());
            this.ms = new MultiStatus();
            this.ms.addResourceProperties(locatedResource, info.getPropertyNameSet(), info.getDepth());
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    public Element toXml(Document document) {
        return this.ms.toXml(document);
    }
}

