/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.version.report;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.commons.iterator.NodeTypeIteratorAdapter;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.jcr.JcrDavException;
import org.apache.jackrabbit.webdav.jcr.nodetype.NodeDefinitionImpl;
import org.apache.jackrabbit.webdav.jcr.nodetype.NodeTypeConstants;
import org.apache.jackrabbit.webdav.jcr.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.webdav.jcr.version.report.AbstractJcrReport;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NodeTypesReport
extends AbstractJcrReport
implements NodeTypeConstants {
    private static Logger log;
    public static final ReportType NODETYPES_REPORT;
    private NodeTypeIterator ntIter;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.jcr.version.report.NodeTypesReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.apache.jackrabbit.webdav.jcr.version.report.NodeTypesReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        NODETYPES_REPORT = ReportType.register((String)"nodetypes", (Namespace)NodeTypeConstants.NAMESPACE, (Class)clazz2);
    }

    public ReportType getType() {
        return NODETYPES_REPORT;
    }

    public boolean isMultiStatusReport() {
        return false;
    }

    public void init(DavResource resource, ReportInfo info) throws DavException {
        super.init(resource, info);
        try {
            this.ntIter = NodeTypesReport.getNodeTypes(this.getRepositorySession(), info);
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
        if (this.ntIter == null) {
            throw new DavException(500);
        }
    }

    public Element toXml(Document document) {
        Element report = document.createElement("nodeTypes");
        while (this.ntIter.hasNext()) {
            NodeType nt = this.ntIter.nextNodeType();
            Element ntDef = document.createElement("nodeType");
            ntDef.setAttribute("name", nt.getName());
            ntDef.setAttribute("isMixin", Boolean.toString(nt.isMixin()));
            ntDef.setAttribute("hasOrderableChildNodes", Boolean.toString(nt.hasOrderableChildNodes()));
            NodeType[] snts = nt.getDeclaredSupertypes();
            Element supertypes = DomUtil.addChildElement((Element)ntDef, (String)"supertypes", null);
            int i = 0;
            while (i < snts.length) {
                DomUtil.addChildElement((Element)supertypes, (String)"supertype", null, (String)snts[i].getName());
                ++i;
            }
            NodeDefinition[] cnd = nt.getChildNodeDefinitions();
            int i2 = 0;
            while (i2 < cnd.length) {
                if (cnd[i2].getDeclaringNodeType().getName().equals(nt.getName())) {
                    ntDef.appendChild(NodeDefinitionImpl.create(cnd[i2]).toXml(document));
                }
                ++i2;
            }
            PropertyDefinition[] pd = nt.getPropertyDefinitions();
            int i3 = 0;
            while (i3 < pd.length) {
                if (pd[i3].getDeclaringNodeType().getName().equals(nt.getName())) {
                    ntDef.appendChild(PropertyDefinitionImpl.create(pd[i3]).toXml(document));
                }
                ++i3;
            }
            String primaryItemName = nt.getPrimaryItemName();
            if (primaryItemName != null) {
                ntDef.setAttribute("primaryItemName", primaryItemName);
            }
            report.appendChild(ntDef);
        }
        return report;
    }

    private static NodeTypeIterator getNodeTypes(Session session, ReportInfo info) throws RepositoryException, DavException {
        NodeTypeManager ntMgr = session.getWorkspace().getNodeTypeManager();
        if (info.containsContentElement("all-nodetypes", NAMESPACE)) {
            return ntMgr.getAllNodeTypes();
        }
        if (info.containsContentElement("mixin-nodetypes", NAMESPACE)) {
            return ntMgr.getMixinNodeTypes();
        }
        if (info.containsContentElement("primary-nodetypes", NAMESPACE)) {
            return ntMgr.getPrimaryNodeTypes();
        }
        List elemList = info.getContentElements("nodetype", NAMESPACE);
        if (elemList.isEmpty()) {
            throw new DavException(400, "NodeTypes report: request body has invalid format.");
        }
        ArrayList<NodeType> ntList = new ArrayList<NodeType>();
        Iterator elemIter = elemList.iterator();
        while (elemIter.hasNext()) {
            Element el = (Element)elemIter.next();
            String nodetypeName = DomUtil.getChildTextTrim((Element)el, (String)"nodetypename", (Namespace)NAMESPACE);
            if (nodetypeName == null) continue;
            ntList.add(ntMgr.getNodeType(nodetypeName));
        }
        return new NodeTypeIteratorAdapter(ntList);
    }
}

