/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.jcr.JcrDavException;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.HrefProperty;
import org.apache.jackrabbit.webdav.simple.DeltaVResourceImpl;
import org.apache.jackrabbit.webdav.simple.ResourceConfig;
import org.apache.jackrabbit.webdav.version.LabelInfo;
import org.apache.jackrabbit.webdav.version.LabelSetProperty;
import org.apache.jackrabbit.webdav.version.VersionHistoryResource;
import org.apache.jackrabbit.webdav.version.VersionResource;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionResourceImpl
extends DeltaVResourceImpl
implements VersionResource {
    private static final Logger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.simple.VersionResourceImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public VersionResourceImpl(DavResourceLocator locator, DavResourceFactory factory, DavSession session, ResourceConfig config, Item item) throws DavException {
        super(locator, factory, session, config, item);
        if (this.getNode() == null || !(this.getNode() instanceof Version)) {
            throw new IllegalArgumentException("Version item expected.");
        }
    }

    public boolean isCollection() {
        return false;
    }

    public DavResourceIterator getMembers() {
        return new DavResourceIteratorImpl(Collections.EMPTY_LIST);
    }

    public void addMember(DavResource member, InputContext inputContext) throws DavException {
        throw new DavException(403);
    }

    public void removeMember(DavResource member) throws DavException {
        throw new DavException(403);
    }

    public void setProperty(DavProperty property) throws DavException {
        throw new DavException(403);
    }

    public void removeProperty(DavPropertyName propertyName) throws DavException {
        throw new DavException(403);
    }

    public MultiStatusResponse alterProperties(DavPropertySet setProperties, DavPropertyNameSet removePropertyNames) throws DavException {
        throw new DavException(403);
    }

    public MultiStatusResponse alterProperties(List changeList) throws DavException {
        throw new DavException(403);
    }

    public void label(LabelInfo labelInfo) throws DavException {
        if (labelInfo == null) {
            throw new DavException(400, "Valid label request body required.");
        }
        if (!this.exists()) {
            throw new DavException(404);
        }
        try {
            VersionHistory vh = this.getVersionHistoryItem();
            if (labelInfo.getType() == 1) {
                vh.removeVersionLabel(labelInfo.getLabelName());
            } else if (labelInfo.getType() == 2) {
                vh.addVersionLabel(this.getNode().getName(), labelInfo.getLabelName(), false);
            } else {
                vh.addVersionLabel(this.getNode().getName(), labelInfo.getLabelName(), true);
            }
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    public VersionHistoryResource getVersionHistory() throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        try {
            VersionHistory vh = this.getVersionHistoryItem();
            DavResourceLocator loc = this.getLocatorFromNode((Node)vh);
            DavResource vhr = this.createResourceFromLocator(loc);
            if (vhr instanceof VersionHistoryResource) {
                return (VersionHistoryResource)vhr;
            }
            throw new DavException(500);
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    private VersionHistory getVersionHistoryItem() throws RepositoryException {
        return ((Version)this.getNode()).getContainingHistory();
    }

    protected void initSupportedReports() {
        super.initSupportedReports();
        if (this.exists()) {
            this.supportedReports.addReportType(ReportType.VERSION_TREE);
        }
    }

    protected void initProperties() {
        if (!this.propsInitialized) {
            super.initProperties();
            Version v = (Version)this.getNode();
            try {
                String creationDate = DavConstants.creationDateFormat.format(v.getCreated().getTime());
                this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.CREATIONDATE, (Object)creationDate));
                this.properties.add((DavProperty)new DefaultDavProperty(VERSION_NAME, (Object)v.getName(), true));
                String[] labels = this.getVersionHistoryItem().getVersionLabels(v);
                this.properties.add((DavProperty)new LabelSetProperty(labels));
                this.properties.add((DavProperty)this.getHrefProperty(VersionResource.PREDECESSOR_SET, (Node[])v.getPredecessors(), true, false));
                this.properties.add((DavProperty)this.getHrefProperty(SUCCESSOR_SET, (Node[])v.getSuccessors(), true, false));
                String vhHref = this.getLocatorFromNode((Node)this.getVersionHistoryItem()).getHref(true);
                this.properties.add((DavProperty)new HrefProperty(VersionResource.VERSION_HISTORY, vhHref, true));
                PropertyIterator it = v.getReferences();
                ArrayList<Node> nodeList = new ArrayList<Node>();
                while (it.hasNext()) {
                    Node n;
                    Property p = it.nextProperty();
                    if (!"jcr:baseVersion".equals(p.getName()) || !(n = p.getParent()).isCheckedOut()) continue;
                    nodeList.add(n);
                }
                this.properties.add((DavProperty)this.getHrefProperty(CHECKOUT_SET, nodeList.toArray(new Node[nodeList.size()]), true, false));
            }
            catch (RepositoryException e) {
                log.error(e.getMessage());
            }
        }
    }
}

