/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.servlet;

import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import org.apache.jackrabbit.servlet.AbstractRepositoryServlet;

public class ContextRepositoryServlet
extends AbstractRepositoryServlet {
    private static final long serialVersionUID = 6222606878557491477L;

    protected Repository getRepository() throws RepositoryException {
        String path = this.getInitParameter("path");
        String name = this.getInitParameter("name", Repository.class.getName());
        ServletContext context = this.getServletContext();
        if (path != null && context.equals(context.getContext(path))) {
            path = null;
        }
        if (path == null && name.equals(this.getAttributeName())) {
            throw new RepositoryException("Invalid configuration: Can not duplicate attribute " + name + " of servlet " + this.getServletName());
        }
        ServletContext otherContext = context.getContext(path);
        if (otherContext == null) {
            throw new RepositoryException("Repository not found: Servlet context " + path + " does not exist or is not accessible from context " + context.getServletContextName());
        }
        Object repository = otherContext.getAttribute(name);
        if (repository instanceof Repository) {
            return (Repository)repository;
        }
        if (repository != null) {
            throw new RepositoryException("Invalid repository: Attribute " + name + " in servet context " + otherContext.getServletContextName() + " is an instance of " + repository.getClass().getName());
        }
        throw new RepositoryException("Repository not found: Attribute " + name + " does not exist in servet context " + otherContext.getServletContextName());
    }
}

