/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import junit.framework.TestResult;
import org.apache.jackrabbit.test.JCRTestResult;
import org.apache.jackrabbit.test.JUnitTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.RepositoryHelper;

public abstract class AbstractJCRTest
extends JUnitTest {
    public static RepositoryHelper helper = new RepositoryHelper();
    public static final String NS_JCR_URI = "http://www.jcp.org/jcr/1.0";
    public static final String NS_NT_URI = "http://www.jcp.org/jcr/nt/1.0";
    public static final String NS_MIX_URI = "http://www.jcp.org/jcr/mix/1.0";
    public static final String NS_SV_URI = "http://www.jcp.org/jcr/sv/1.0";
    protected String jcrPrimaryType;
    protected String jcrMixinTypes;
    protected String jcrPredecessors;
    protected String jcrSuccessors;
    protected String jcrCreated;
    protected String jcrVersionHistory;
    protected String jcrFrozenNode;
    protected String jcrFrozenUuid;
    protected String jcrRootVersion;
    protected String jcrBaseVersion;
    protected String jcrUUID;
    protected String jcrLockOwner;
    protected String jcrlockIsDeep;
    protected String jcrMergeFailed;
    protected String jcrSystem;
    protected String ntBase;
    protected String ntVersion;
    protected String ntVersionHistory;
    protected String ntVersionLabels;
    protected String ntFrozenNode;
    protected String mixReferenceable;
    protected String mixVersionable;
    protected String mixLockable;
    protected String ntQuery;
    protected String testPath;
    protected String testRoot;
    protected String testNodeType;
    protected String testNodeTypeNoChildren;
    protected String nodeName1;
    protected String nodeName2;
    protected String nodeName3;
    protected String nodeName4;
    protected String propertyName1;
    protected String propertyName2;
    protected String workspaceName;
    protected Session superuser;
    protected boolean isReadOnly = false;
    protected Node testRootNode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        super.setUp();
        this.testRoot = this.getProperty("testroot");
        if (this.testRoot == null) {
            AbstractJCRTest.fail((String)"Property 'testroot' is not defined.");
        }
        this.testPath = this.testRoot.substring(1);
        this.testNodeType = this.getProperty("nodetype");
        this.testNodeTypeNoChildren = this.getProperty("nodetypenochildren");
        this.nodeName1 = this.getProperty("nodename1");
        if (this.nodeName1 == null) {
            AbstractJCRTest.fail((String)"Property 'nodename1' is not defined.");
        }
        this.nodeName2 = this.getProperty("nodename2");
        if (this.nodeName2 == null) {
            AbstractJCRTest.fail((String)"Property 'nodename2' is not defined.");
        }
        this.nodeName3 = this.getProperty("nodename3");
        if (this.nodeName3 == null) {
            AbstractJCRTest.fail((String)"Property 'nodename3' is not defined.");
        }
        this.nodeName4 = this.getProperty("nodename4");
        if (this.nodeName4 == null) {
            AbstractJCRTest.fail((String)"Property 'nodename4' is not defined.");
        }
        this.propertyName1 = this.getProperty("propertyname1");
        if (this.propertyName1 == null) {
            AbstractJCRTest.fail((String)"Property 'propertyname1' is not defined.");
        }
        this.propertyName2 = this.getProperty("propertyname2");
        if (this.propertyName2 == null) {
            AbstractJCRTest.fail((String)"Property 'propertyname2' is not defined.");
        }
        this.workspaceName = this.getProperty("workspacename");
        if (this.workspaceName == null) {
            AbstractJCRTest.fail((String)"Property 'workspacename' is not defined.");
        }
        this.superuser = helper.getSuperuserSession();
        this.jcrPrimaryType = this.superuser.getNamespacePrefix(NS_JCR_URI) + ":primaryType";
        this.jcrMixinTypes = this.superuser.getNamespacePrefix(NS_JCR_URI) + ":mixinTypes";
        this.jcrPredecessors = this.superuser.getNamespacePrefix(NS_JCR_URI) + ":predecessors";
        this.jcrSuccessors = this.superuser.getNamespacePrefix(NS_JCR_URI) + ":successors";
        this.jcrCreated = this.superuser.getNamespacePrefix(NS_JCR_URI) + ":created";
        this.jcrVersionHistory = this.superuser.getNamespacePrefix(NS_JCR_URI) + ":versionHistory";
        this.jcrFrozenNode = this.superuser.getNamespacePrefix(NS_JCR_URI) + ":frozenNode";
        this.jcrFrozenUuid = this.superuser.getNamespacePrefix(NS_JCR_URI) + ":frozenUuid";
        this.jcrRootVersion = this.superuser.getNamespacePrefix(NS_JCR_URI) + ":rootVersion";
        this.jcrBaseVersion = this.superuser.getNamespacePrefix(NS_JCR_URI) + ":baseVersion";
        this.jcrUUID = this.superuser.getNamespacePrefix(NS_JCR_URI) + ":uuid";
        this.jcrLockOwner = this.superuser.getNamespacePrefix(NS_JCR_URI) + ":lockOwner";
        this.jcrlockIsDeep = this.superuser.getNamespacePrefix(NS_JCR_URI) + ":lockIsDeep";
        this.jcrMergeFailed = this.superuser.getNamespacePrefix(NS_JCR_URI) + ":mergeFailed";
        this.jcrSystem = this.superuser.getNamespacePrefix(NS_JCR_URI) + ":system";
        this.ntBase = this.superuser.getNamespacePrefix(NS_NT_URI) + ":base";
        this.ntVersion = this.superuser.getNamespacePrefix(NS_NT_URI) + ":version";
        this.ntVersionHistory = this.superuser.getNamespacePrefix(NS_NT_URI) + ":versionHistory";
        this.ntVersionLabels = this.superuser.getNamespacePrefix(NS_NT_URI) + ":versionLabels";
        this.ntFrozenNode = this.superuser.getNamespacePrefix(NS_NT_URI) + ":frozenNode";
        this.mixReferenceable = this.superuser.getNamespacePrefix(NS_MIX_URI) + ":referenceable";
        this.mixVersionable = this.superuser.getNamespacePrefix(NS_MIX_URI) + ":versionable";
        this.mixLockable = this.superuser.getNamespacePrefix(NS_MIX_URI) + ":lockable";
        this.ntQuery = this.superuser.getNamespacePrefix(NS_NT_URI) + ":query";
        if (this.isSupported("level.2.supported")) {
            NamespaceRegistry nsReg = this.superuser.getWorkspace().getNamespaceRegistry();
            String namespaces = this.getProperty("namespaces");
            if (namespaces != null) {
                String[] prefixes = namespaces.split(" ");
                for (int i = 0; i < prefixes.length; ++i) {
                    String uri = this.getProperty("namespaces." + prefixes[i]);
                    if (uri == null) continue;
                    try {
                        nsReg.getPrefix(uri);
                        continue;
                    }
                    catch (NamespaceException e) {
                        nsReg.registerNamespace(prefixes[i], uri);
                    }
                }
            }
        }
        if (this.isReadOnly) {
            if (this.testPath.length() == 0) {
                this.testRootNode = this.superuser.getRootNode();
            } else if (!this.superuser.getRootNode().hasNode(this.testPath)) {
                this.cleanUp();
                AbstractJCRTest.fail((String)("Workspace does not contain test data at: " + this.testRoot));
            } else {
                this.testRootNode = this.superuser.getRootNode().getNode(this.testPath);
            }
        } else if (this.isSupported("level.2.supported")) {
            this.testRootNode = this.cleanUpTestRoot(this.superuser);
            Session s = helper.getSuperuserSession(this.workspaceName);
            try {
                this.cleanUpTestRoot(s);
            }
            finally {
                s.logout();
            }
        } else {
            this.cleanUp();
            AbstractJCRTest.fail((String)"Test case requires level 2 support.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUp() throws Exception {
        if (this.superuser != null) {
            try {
                if (!this.isReadOnly && this.isSupported("level.2.supported")) {
                    this.cleanUpTestRoot(this.superuser);
                }
            }
            catch (Exception e) {
                this.log.println("Exception in tearDown: " + e.toString());
            }
            finally {
                this.superuser.logout();
                this.superuser = null;
            }
        }
        this.testRootNode = null;
    }

    protected void tearDown() throws Exception {
        this.cleanUp();
        super.tearDown();
    }

    public void run(TestResult testResult) {
        super.run((TestResult)new JCRTestResult(testResult, this.log));
    }

    public String getProperty(String propName) throws RepositoryException {
        String value;
        String testCaseName = this.getName();
        String testClassName = ((Object)((Object)this)).getClass().getName();
        String testPackName = "";
        int idx = testClassName.lastIndexOf(46);
        if (idx > -1) {
            testPackName = testClassName.substring(testClassName.lastIndexOf(46, idx - 1) + 1, idx);
            testClassName = testClassName.substring(idx + 1);
        }
        if ((value = helper.getProperty("javax.jcr.tck." + testClassName + "." + testCaseName + "." + propName)) != null) {
            return value;
        }
        value = helper.getProperty("javax.jcr.tck." + testClassName + "." + propName);
        if (value != null) {
            return value;
        }
        value = helper.getProperty("javax.jcr.tck." + testPackName + "." + propName);
        if (value != null) {
            return value;
        }
        return helper.getProperty("javax.jcr.tck." + propName);
    }

    protected long getSize(RangeIterator it) {
        long size = it.getSize();
        if (size != -1L) {
            return size;
        }
        size = 0L;
        while (it.hasNext()) {
            it.next();
            ++size;
        }
        return size;
    }

    protected String getNonExistingWorkspaceName(Session session) throws RepositoryException {
        List<String> names = Arrays.asList(session.getWorkspace().getAccessibleWorkspaceNames());
        String nonExisting = null;
        while (nonExisting == null) {
            String name = this.createRandomString(10);
            if (names.contains(name)) continue;
            nonExisting = name;
        }
        return nonExisting;
    }

    protected String createRandomString(int numChars) {
        Random rand = new Random(System.currentTimeMillis());
        StringBuffer tmp = new StringBuffer(numChars);
        for (int i = 0; i < numChars; ++i) {
            char c = (char)(rand.nextInt(26) + 97);
            tmp.append(c);
        }
        return tmp.toString();
    }

    protected boolean isSupported(String descriptorKey) throws RepositoryException {
        return "true".equals(helper.getRepository().getDescriptor(descriptorKey));
    }

    protected void ensureMultipleWorkspacesSupported() throws RepositoryException, NotExecutableException {
        String[] workspacenames = this.superuser.getWorkspace().getAccessibleWorkspaceNames();
        if (workspacenames == null || workspacenames.length < 2) {
            throw new NotExecutableException("This repository does not seem to support multiple workspaces.");
        }
    }

    private boolean canSetProperty(NodeType nodeType, String propertyName, int propertyType, boolean isMultiple) {
        PropertyDefinition[] propDefs = nodeType.getPropertyDefinitions();
        for (int i = 0; i < propDefs.length; ++i) {
            if (!propDefs[i].getName().equals(propertyName) && !propDefs[i].getName().equals("*") || propDefs[i].getRequiredType() != propertyType && propDefs[i].getRequiredType() != 0 || propDefs[i].isMultiple() != isMultiple) continue;
            return true;
        }
        return false;
    }

    private boolean canSetProperty(Node node, String propertyName, int propertyType, boolean isMultiple) throws RepositoryException {
        if (this.canSetProperty(node.getPrimaryNodeType(), propertyName, propertyType, isMultiple)) {
            return true;
        }
        NodeType[] mixins = node.getMixinNodeTypes();
        boolean canSetIt = false;
        for (int i = 0; i < mixins.length && !canSetIt; canSetIt |= this.canSetProperty(mixins[i], propertyName, propertyType, isMultiple), ++i) {
        }
        return canSetIt;
    }

    protected void ensureCanSetProperty(Node node, String propertyName, int propertyType, boolean isMultiple) throws NotExecutableException, RepositoryException {
        if (!this.canSetProperty(node, propertyName, propertyType, isMultiple)) {
            throw new NotExecutableException("configured property name " + propertyName + " can not be set on node " + node.getPath());
        }
    }

    protected void ensureCanSetProperty(Node node, String propertyName, Value value) throws NotExecutableException, RepositoryException {
        this.ensureCanSetProperty(node, propertyName, value.getType(), false);
    }

    protected void ensureCanSetProperty(Node node, String propertyName, Value[] values) throws NotExecutableException, RepositoryException {
        int propertyType;
        int n = propertyType = values.length == 0 ? 0 : values[0].getType();
        if (!this.canSetProperty(node, propertyName, propertyType, true)) {
            throw new NotExecutableException("configured property name " + propertyName + " can not be set on node " + node.getPath());
        }
    }

    protected boolean needsMixin(Node node, String mixin) throws RepositoryException {
        return !node.getSession().getWorkspace().getNodeTypeManager().getNodeType(node.getPrimaryNodeType().getName()).isNodeType(mixin);
    }

    protected Node cleanUpTestRoot(Session s) throws RepositoryException {
        Node testRootNode;
        s.refresh(false);
        Node root = s.getRootNode();
        if (root.hasNode(this.testPath)) {
            testRootNode = root.getNode(this.testPath);
            NodeIterator children = testRootNode.getNodes();
            while (children.hasNext()) {
                Node child = children.nextNode();
                NodeDefinition nodeDef = child.getDefinition();
                if (nodeDef.isMandatory() || nodeDef.isProtected()) continue;
                try {
                    child.remove();
                }
                catch (ConstraintViolationException e) {
                    this.log.println("unable to remove node: " + child.getPath());
                }
            }
        } else {
            StringTokenizer names = new StringTokenizer(this.testPath, "/");
            Node currentNode = root;
            while (names.hasMoreTokens()) {
                String name = names.nextToken();
                if (currentNode.hasNode(name)) {
                    currentNode = currentNode.getNode(name);
                    continue;
                }
                currentNode = currentNode.addNode(name, this.testNodeType);
            }
            testRootNode = currentNode;
        }
        s.save();
        return testRootNode;
    }
}

