/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import org.apache.jackrabbit.test.LogPrintWriter;
import org.apache.jackrabbit.test.NotExecutableException;

public class JCRTestResult
extends TestResult {
    private final TestResult orig;
    private final LogPrintWriter log;
    private final Set knownIssues;
    private final Set knownIssuesOverride;

    public JCRTestResult(TestResult orig, LogPrintWriter log) {
        this.orig = orig;
        this.log = log;
        this.knownIssues = JCRTestResult.tokenize("known.issues");
        this.knownIssuesOverride = JCRTestResult.tokenize("known.issues.override");
    }

    public synchronized void addError(Test test, Throwable throwable) {
        if (throwable instanceof NotExecutableException) {
            this.log.println("Test case: " + test.toString() + " not executable: " + throwable.getMessage());
        } else if (this.isKnownIssue(test)) {
            this.log.println("Known issue: " + test + ": " + throwable.getMessage());
        } else {
            this.orig.addError(test, throwable);
        }
    }

    public synchronized void addFailure(Test test, AssertionFailedError assertionFailedError) {
        if (this.isKnownIssue(test)) {
            this.log.println("Known issue: " + test + ": " + assertionFailedError.getMessage());
        } else {
            this.orig.addFailure(test, assertionFailedError);
        }
    }

    public synchronized void addListener(TestListener testListener) {
        this.orig.addListener(testListener);
    }

    public synchronized void removeListener(TestListener testListener) {
        this.orig.removeListener(testListener);
    }

    public void endTest(Test test) {
        this.orig.endTest(test);
    }

    public synchronized int errorCount() {
        return this.orig.errorCount();
    }

    public synchronized Enumeration errors() {
        return this.orig.errors();
    }

    public synchronized int failureCount() {
        return this.orig.failureCount();
    }

    public synchronized Enumeration failures() {
        return this.orig.failures();
    }

    public synchronized int runCount() {
        return this.orig.runCount();
    }

    public synchronized boolean shouldStop() {
        return this.orig.shouldStop();
    }

    public void startTest(Test test) {
        this.orig.startTest(test);
    }

    public synchronized void stop() {
        this.orig.stop();
    }

    public synchronized boolean wasSuccessful() {
        return this.orig.wasSuccessful();
    }

    private static Set tokenize(String name) {
        HashSet<String> tokens = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(System.getProperty(name, ""));
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }

    private static boolean contains(Set tokens, TestCase test) {
        String className = test.getClass().getName();
        String methodName = test.getName();
        int i = className.lastIndexOf(46);
        if (i >= 0) {
            String packageName = className.substring(0, i);
            String shortName = className.substring(i + 1);
            return tokens.contains(packageName) || tokens.contains(shortName) || tokens.contains(className) || tokens.contains(methodName) || tokens.contains(shortName + "#" + methodName) || tokens.contains(className + "#" + methodName);
        }
        return tokens.contains(className) || tokens.contains(methodName) || tokens.contains(className + "#" + methodName);
    }

    private boolean isKnownIssue(Test test) {
        if (test instanceof TestCase) {
            return JCRTestResult.contains(this.knownIssues, (TestCase)test) && !JCRTestResult.contains(this.knownIssuesOverride, (TestCase)test);
        }
        return false;
    }
}

