/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.AbstractPropertyTest;
import org.apache.jackrabbit.test.api.PropertyUtil;

public class BinaryPropertyTest
extends AbstractPropertyTest {
    protected int getPropertyType() {
        return 2;
    }

    protected Boolean getPropertyIsMultivalued() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSameStream() throws RepositoryException, IOException {
        Value val = PropertyUtil.getValue(this.prop);
        InputStream in = val.getStream();
        InputStream in2 = val.getStream();
        Value otherVal = PropertyUtil.getValue(this.prop);
        InputStream in3 = otherVal.getStream();
        try {
            BinaryPropertyTest.assertSame((String)"Same InputStream object expected when Value.getStream is called twice.", (Object)in, (Object)in2);
            BinaryPropertyTest.assertNotSame((String)"Value.getStream() called on a new value object should return a different Stream object.", (Object)in, (Object)in3);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignore) {}
            if (in2 != in) {
                try {
                    in2.close();
                }
                catch (IOException ignore) {}
            }
            if (in3 != in) {
                try {
                    in3.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiValue() throws RepositoryException, IOException {
        if (this.multiple) {
            InputStream in = null;
            try {
                in = this.prop.getStream();
                BinaryPropertyTest.fail((String)"Calling getStream() on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValue() throws IOException, RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        InputStream in = val.getStream();
        InputStream in2 = this.prop.getDefinition().isMultiple() ? this.prop.getValues()[0].getStream() : this.prop.getStream();
        try {
            int b = in.read();
            while (b != -1) {
                int b2 = in2.read();
                BinaryPropertyTest.assertEquals((String)"Value.getStream() and Property.getStream() return different values.", (int)b, (int)b2);
                b = in.read();
            }
            BinaryPropertyTest.assertEquals((String)"Value.getStream() and Property.getStream() return different values.", (int)-1, (int)in2.read());
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignore) {}
            try {
                in2.close();
            }
            catch (IOException ignore) {}
        }
    }

    public void testGetBoolean() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        String str = val.getString();
        boolean bool = val.getBoolean();
        BinaryPropertyTest.assertEquals((String)"Wrong conversion from Binary to Boolean.", (Object)new Boolean(bool), (Object)Boolean.valueOf(str));
    }

    public void testGetDate() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        if (PropertyUtil.isDateFormat(val.getString())) {
            val.getDate();
        } else {
            try {
                val.getDate();
                BinaryPropertyTest.fail((String)"Conversion from a malformed String to a Date should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }

    public void testGetDouble() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        String str = val.getString();
        try {
            Double.parseDouble(str);
            double d = val.getDouble();
            BinaryPropertyTest.assertEquals((String)"Wrong conversion from Binary to Double", (Object)new Double(d), (Object)Double.valueOf(str));
        }
        catch (NumberFormatException nfe) {
            try {
                val.getDouble();
                BinaryPropertyTest.fail((String)"Conversion from malformed Binary to Double should throw ValueFormatException.");
            }
            catch (ValueFormatException vfe) {
                // empty catch block
            }
        }
    }

    public void testGetLong() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        String str = val.getString();
        try {
            Long.parseLong(str);
            long l = val.getLong();
            BinaryPropertyTest.assertEquals((String)"Wrong conversion from Binary to Long", (Object)new Long(l), (Object)Long.valueOf(str));
        }
        catch (NumberFormatException nfe) {
            try {
                val.getLong();
                BinaryPropertyTest.fail((String)"Conversion from malformed Binary to Long should throw ValueFormatException.");
            }
            catch (ValueFormatException vfe) {
                // empty catch block
            }
        }
    }

    public void testGetType() throws RepositoryException {
        BinaryPropertyTest.assertTrue((String)"Value.getType() returns wrong type.", (boolean)PropertyUtil.checkGetType(this.prop, 2));
    }

    public void testAsReference() throws RepositoryException, NotExecutableException {
        if (this.multiple) {
            try {
                this.prop.getNode();
                BinaryPropertyTest.fail((String)"Property.getNode() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }

    public void testGetLength() throws RepositoryException {
        if (this.multiple) {
            try {
                this.prop.getLength();
                BinaryPropertyTest.fail((String)"Property.getLength() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException vfe) {}
        } else {
            long bytes;
            long length = this.prop.getLength();
            if (length > -1L && (bytes = PropertyUtil.countBytes(this.prop.getValue())) != -1L) {
                BinaryPropertyTest.assertEquals((String)"Property.getLength() returns wrong number of bytes.", (long)bytes, (long)length);
            }
        }
    }

    public void testGetLengths() throws RepositoryException {
        if (this.multiple) {
            Value[] values = this.prop.getValues();
            long[] lengths = this.prop.getLengths();
            for (int i = 0; i < lengths.length; ++i) {
                long length = PropertyUtil.countBytes(values[i]);
                BinaryPropertyTest.assertEquals((String)"Property.getLengths() returns wrong array of the lengths of a multivalue property.", (long)length, (long)lengths[i]);
            }
        } else {
            try {
                this.prop.getLengths();
                BinaryPropertyTest.fail((String)"Property.getLengths() called on a sinlge value property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }
}

