/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import junit.framework.Assert;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.api.SysViewContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExportSysViewTest
extends AbstractJCRTest {
    private File file;
    private final boolean SKIPBINARY = true;
    private final boolean SAVEBINARY = false;
    private final boolean NORECURSE = true;
    private final boolean RECURSE = false;
    private Session session;
    private String testPath;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        this.session = helper.getReadOnlySession();
        this.file = File.createTempFile("SysViewExportTest", ".xml");
        super.setUp();
        this.testPath = this.testRoot;
    }

    protected void tearDown() throws Exception {
        this.file.delete();
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testExportSysView_handler_session_skipBinary_noRecurse() throws IOException, RepositoryException, SAXException, IOException {
        this.doTestWithHandler(true, true);
    }

    public void testExportSysView_handler_session_skipBinary_recurse() throws IOException, RepositoryException, SAXException, IOException {
        this.doTestWithHandler(true, false);
    }

    public void testExportSysView_handler_session_saveBinary_noRecurse() throws IOException, RepositoryException, SAXException, IOException {
        this.doTestWithHandler(false, true);
    }

    public void testExportSysView_handler_session_saveBinary_recurse() throws IOException, RepositoryException, SAXException, IOException {
        this.doTestWithHandler(false, false);
    }

    public void testExportSysView_stream_session_skipBinary_recurse() throws IOException, RepositoryException, SAXException {
        this.doTestWithStream(true, false);
    }

    public void testExportSysView_stream_session_skipBinary_noRecurse() throws IOException, RepositoryException, SAXException {
        this.doTestWithStream(true, true);
    }

    public void testExportSysView_stream_session_saveBinary_noRecurse() throws IOException, RepositoryException, SAXException {
        this.doTestWithStream(false, true);
    }

    public void testExportSysView_stream_session_saveBinary_recurse() throws IOException, RepositoryException, SAXException {
        this.doTestWithStream(false, false);
    }

    public void doTestWithHandler(boolean skipBinary, boolean noRecurse) throws RepositoryException, SAXException, IOException {
        SysViewContentHandler contentHandler = new SysViewContentHandler(this.testPath, this.session, skipBinary, noRecurse);
        this.session.exportSystemView(this.testPath, (ContentHandler)contentHandler, skipBinary, noRecurse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doTestWithStream(boolean skipBinary, boolean noRecurse) throws RepositoryException, SAXException, IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.file));
        try {
            try {
                this.session.exportSystemView(this.testPath, (OutputStream)os, false, false);
                SysViewParser parser = new SysViewParser(this.testPath, this.session, false, false);
                parser.parse(this.file);
            }
            catch (RepositoryException re) {
                ExportSysViewTest.fail((String)("Could not initialize the contenthandler due to: " + re.toString()));
                Object var6_7 = null;
                os.close();
                return;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            os.close();
            throw throwable;
        }
        os.close();
    }

    protected class SysViewParser {
        String filePath;
        String nodePath;
        Node node;
        XMLReader parser;
        SysViewContentHandler handler;

        public SysViewParser(String nodePath, Session session, boolean skipBinary, boolean noRecurse) throws SAXException, RepositoryException {
            this.nodePath = nodePath;
            this.handler = new SysViewContentHandler(nodePath, session, skipBinary, noRecurse);
            this.parser = XMLReaderFactory.createXMLReader();
            this.parser.setContentHandler(this.handler);
        }

        public void parse(File file) throws IOException, SAXException {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                Assert.fail((String)("Input file not opened: " + e));
            }
            InputSource source = new InputSource(in);
            this.parser.parse(source);
        }
    }
}

