/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import junit.framework.Assert;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class NodeReadMethodsTest
extends AbstractJCRTest {
    private Session session;
    private Node childNode;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = helper.getReadOnlySession();
        this.testRootNode = this.session.getRootNode().getNode(this.testPath);
        NodeIterator nodes = this.testRootNode.getNodes();
        try {
            this.childNode = nodes.nextNode();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        this.childNode = null;
        super.tearDown();
    }

    public void testGetPath() throws NotExecutableException, RepositoryException {
        if (this.childNode == null) {
            throw new NotExecutableException("Workspace does not have sufficient content to run this test.");
        }
        String path = this.testRoot + "/" + this.childNode.getName();
        if (this.getSize((RangeIterator)this.testRootNode.getNodes(this.childNode.getName())) > 1L) {
            path = path + "[" + this.childNode.getIndex() + "]";
        }
        this.log.println("path: " + this.childNode.getPath());
        NodeReadMethodsTest.assertEquals((String)"getPath returns wrong result", (String)path, (String)this.childNode.getPath());
    }

    public void testGetName() throws RepositoryException, NotExecutableException {
        if (this.childNode == null) {
            throw new NotExecutableException("Workspace does not have sufficient content to run this test.");
        }
        String path = this.childNode.getPath();
        String name = path.substring(path.lastIndexOf("/") + 1);
        if (name.indexOf("[") != -1) {
            name = name.substring(0, name.indexOf("["));
        }
        NodeReadMethodsTest.assertEquals((String)"getName() must be the same as the last item in the path", (String)name, (String)this.childNode.getName());
    }

    public void testGetAncestorOfNodeDepth() throws RepositoryException {
        Node nodeAtDepth = (Node)this.testRootNode.getAncestor(this.testRootNode.getDepth());
        NodeReadMethodsTest.assertTrue((String)"The ancestor of depth = n, where n is the depth of this Node must be the item itself.", (boolean)this.testRootNode.isSame((Item)nodeAtDepth));
    }

    public void testGetAncestorOfGreaterDepth() throws RepositoryException {
        try {
            int greaterDepth = this.testRootNode.getDepth() + 1;
            this.testRootNode.getAncestor(greaterDepth);
            NodeReadMethodsTest.fail((String)"Getting ancestor of depth n, where n is greater than depth ofthis Node must throw an ItemNotFoundException");
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public void testGetAncestorOfNegativeDepth() throws RepositoryException {
        try {
            this.testRootNode.getAncestor(-1);
            NodeReadMethodsTest.fail((String)"Getting ancestor of depth < 0 must throw an ItemNotFoundException.");
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public void testGetParent() throws NotExecutableException, RepositoryException {
        if (this.childNode == null) {
            throw new NotExecutableException("Workspace does not have sufficient content to run this test.");
        }
        NodeReadMethodsTest.assertTrue((String)"getParent() of a child node return the parent node.", (boolean)this.testRootNode.isSame((Item)this.childNode.getParent()));
    }

    public void testGetParentOfRoot() throws RepositoryException {
        try {
            this.session.getRootNode().getParent();
            NodeReadMethodsTest.fail((String)"getParent() of root must throw an ItemNotFoundException.");
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public void testGetDepth() throws RepositoryException {
        NodeReadMethodsTest.assertEquals((String)"getDepth() of root must be 0", (int)0, (int)this.session.getRootNode().getDepth());
        NodeIterator it = this.session.getRootNode().getNodes();
        while (it.hasNext()) {
            NodeReadMethodsTest.assertEquals((String)"getDepth() of child node of root must be 1", (int)1, (int)it.nextNode().getDepth());
        }
    }

    public void testGetSession() throws RepositoryException {
        NodeReadMethodsTest.assertSame((String)"getSession must return the Session through which the Node was acquired.", (Object)this.testRootNode.getSession(), (Object)this.session);
    }

    public void testIsNode() {
        NodeReadMethodsTest.assertTrue((String)"isNode() must return true.", (boolean)this.testRootNode.isNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsSame() throws RepositoryException {
        Session s = helper.getReadOnlySession();
        try {
            Node otherTestNode = s.getRootNode().getNode(this.testPath);
            NodeReadMethodsTest.assertTrue((String)"isSame(Item item) must return true for the same item retrieved through different sessions.", (boolean)this.testRootNode.isSame((Item)otherTestNode));
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            s.logout();
            throw throwable;
        }
        s.logout();
    }

    public void testAccept() throws RepositoryException {
        final Node n = this.testRootNode;
        ItemVisitor itemVisitor = new ItemVisitor(){

            public void visit(Property property) {
                Assert.fail((String)"Wrong accept method executed.");
            }

            public void visit(Node node) throws RepositoryException {
                Assert.assertTrue((String)"Visited node is not the same as the one passed in method visit(Node)", (boolean)n.isSame((Item)node));
            }
        };
        n.accept(itemVisitor);
    }

    public void testGetNode() throws NotExecutableException, RepositoryException {
        StringBuffer notExistingPath = new StringBuffer("X");
        NodeIterator nodes = this.testRootNode.getNodes();
        while (nodes.hasNext()) {
            notExistingPath.append(nodes.nextNode().getName());
        }
        try {
            this.testRootNode.getNode(notExistingPath.toString().replaceAll(":", ""));
            NodeReadMethodsTest.fail((String)"getNode(String relPath) must throw a PathNotFoundExceptionif no node exists at relPath");
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        try {
            NodeIterator nodes2 = this.testRootNode.getNodes();
            Node node = nodes2.nextNode();
            NodeReadMethodsTest.assertTrue((String)"Node from Iterator is not the same as the Node from getNode()", (boolean)this.testRootNode.getNode(node.getName()).isSame((Item)node));
        }
        catch (NoSuchElementException e) {
            throw new NotExecutableException("Workspace does not have sufficient content for this test. Root node must have at least one child node.");
        }
    }

    public void testGetNodes() throws RepositoryException {
        NodeIterator nodes = this.testRootNode.getNodes();
        while (nodes.hasNext()) {
            Item item = (Item)nodes.next();
            NodeReadMethodsTest.assertTrue((String)"Item is not a node", (boolean)item.isNode());
        }
    }

    public void testGetNodesNamePattern() throws NotExecutableException, RepositoryException {
        Node node = this.testRootNode;
        if (!node.hasNodes()) {
            throw new NotExecutableException("Workspace does not have sufficient content for this test. Root node must have at least one child node.");
        }
        NodeIterator allNodesIt = node.getNodes();
        ArrayList<Node> allNodes = new ArrayList<Node>();
        while (allNodesIt.hasNext()) {
            Node n = allNodesIt.nextNode();
            allNodes.add(n);
        }
        String pattern0 = "";
        NodeIterator nodes0 = node.getNodes(pattern0);
        try {
            nodes0.nextNode();
            NodeReadMethodsTest.fail((String)"An empty NodeIterator must be returned if pattern doesnot match any child node.");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        Node firstNode = (Node)allNodes.get(0);
        String pattern1 = "*";
        String assertString1 = "node.getNodes(\"" + pattern1 + "\"): ";
        NodeIterator nodes1 = node.getNodes(pattern1);
        NodeReadMethodsTest.assertEquals((String)(assertString1 + "number of nodes found: "), (long)allNodes.size(), (long)this.getSize((RangeIterator)nodes1));
        String pattern2 = firstNode.getName();
        String assertString2 = "node.getNodes(\"" + pattern2 + "\"): ";
        NodeIterator nodes2 = node.getNodes(pattern2);
        while (nodes2.hasNext()) {
            Node n = nodes2.nextNode();
            NodeReadMethodsTest.assertEquals((String)(assertString2 + "name comparison failed: "), (String)firstNode.getName(), (String)n.getName());
        }
        int numExpected2 = 0;
        for (int i = 0; i < allNodes.size(); ++i) {
            Node n = (Node)allNodes.get(i);
            if (!n.getName().equals(firstNode.getName())) continue;
            ++numExpected2;
        }
        nodes2 = node.getNodes(pattern2);
        NodeReadMethodsTest.assertEquals((String)(assertString2 + "number of nodes found: "), (long)numExpected2, (long)this.getSize((RangeIterator)nodes2));
        String pattern3 = firstNode.getName() + "|" + firstNode.getName();
        String assertString3 = "node.getNodes(\"" + pattern3 + "\"): ";
        NodeIterator nodes3 = node.getNodes(pattern3);
        while (nodes3.hasNext()) {
            Node n = nodes3.nextNode();
            NodeReadMethodsTest.assertEquals((String)(assertString2 + "name comparison failed: "), (String)firstNode.getName(), (String)n.getName());
        }
        int numExpected3 = 0;
        for (int i = 0; i < allNodes.size(); ++i) {
            Node n = (Node)allNodes.get(i);
            if (!n.getName().equals(firstNode.getName())) continue;
            ++numExpected3;
        }
        nodes3 = node.getNodes(pattern3);
        NodeReadMethodsTest.assertEquals((String)(assertString3 + "number of nodes found: "), (long)numExpected3, (long)this.getSize((RangeIterator)nodes3));
        if (firstNode.getName().length() > 2) {
            String name = firstNode.getName();
            String shortenName = name.substring(1, name.length() - 1);
            String pattern4 = "*" + shortenName + "*";
            String assertString4 = "node.getNodes(\"" + pattern4 + "\"): ";
            NodeIterator nodes4 = node.getNodes(pattern4);
            while (nodes4.hasNext()) {
                Node n = nodes4.nextNode();
                NodeReadMethodsTest.assertTrue((String)(assertString4 + "name comparison failed: *" + shortenName + "* not found in " + n.getName()), (n.getName().indexOf(shortenName) != -1 ? 1 : 0) != 0);
            }
            int numExpected4 = 0;
            for (int i = 0; i < allNodes.size(); ++i) {
                Node n = (Node)allNodes.get(i);
                if (n.getName().indexOf(shortenName) == -1) continue;
                ++numExpected4;
            }
            nodes4 = node.getNodes(pattern4);
            NodeReadMethodsTest.assertEquals((String)(assertString4 + "number of nodes found: "), (long)numExpected4, (long)this.getSize((RangeIterator)nodes4));
        }
    }

    public void testGetProperty() throws NotExecutableException, RepositoryException {
        StringBuffer notExistingPath = new StringBuffer("X");
        PropertyIterator properties = this.testRootNode.getProperties();
        while (properties.hasNext()) {
            notExistingPath.append(properties.nextProperty().getName());
        }
        try {
            this.testRootNode.getProperty(notExistingPath.toString().replaceAll(":", ""));
            NodeReadMethodsTest.fail((String)"getProperty(String relPath) must throw a PathNotFoundException if no node exists at relPath");
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        try {
            PropertyIterator properties2 = this.testRootNode.getProperties();
            Property property = properties2.nextProperty();
            NodeReadMethodsTest.assertTrue((String)"Property returned by getProperties() is not the same as returned by getProperty(String).", (boolean)this.testRootNode.getProperty(property.getName()).isSame((Item)property));
        }
        catch (NoSuchElementException e) {
            NodeReadMethodsTest.fail((String)"Root node must always have at least one property: jcr:primaryType");
        }
    }

    public void testGetProperties() throws RepositoryException {
        PropertyIterator properties = this.testRootNode.getProperties();
        while (properties.hasNext()) {
            Item item = (Item)properties.next();
            NodeReadMethodsTest.assertFalse((String)"Item is not a property", (boolean)item.isNode());
        }
    }

    public void testGetPropertiesNamePattern() throws NotExecutableException, RepositoryException {
        Node node = this.testRootNode;
        if (!node.hasProperties()) {
            NodeReadMethodsTest.fail((String)"Root node must always have at least one property: jcr:primaryType");
        }
        PropertyIterator allPropertiesIt = node.getProperties();
        ArrayList<Property> allProperties = new ArrayList<Property>();
        StringBuffer notExistingPropertyName = new StringBuffer();
        while (allPropertiesIt.hasNext()) {
            Property p = allPropertiesIt.nextProperty();
            allProperties.add(p);
            notExistingPropertyName.append(p.getName() + "X");
        }
        String pattern0 = notExistingPropertyName.toString().replaceAll(":", "");
        NodeIterator properties0 = node.getNodes(pattern0);
        try {
            properties0.nextNode();
            NodeReadMethodsTest.fail((String)"An empty NodeIterator must be returned if pattern doesnot match any child node.");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        Property firstProperty = (Property)allProperties.get(0);
        String pattern1 = "*";
        String assertString1 = "node.getProperties(\"" + pattern1 + "\"): ";
        PropertyIterator properties1 = node.getProperties(pattern1);
        NodeReadMethodsTest.assertEquals((String)(assertString1 + "number of properties found: "), (long)allProperties.size(), (long)this.getSize((RangeIterator)properties1));
        String pattern2 = firstProperty.getName();
        String assertString2 = "node.getProperties(\"" + pattern2 + "\"): ";
        PropertyIterator properties2 = node.getProperties(pattern2);
        while (properties2.hasNext()) {
            Property p = properties2.nextProperty();
            NodeReadMethodsTest.assertEquals((String)(assertString2 + "name comparison failed: "), (String)firstProperty.getName(), (String)p.getName());
        }
        int numExpected2 = 0;
        for (int i = 0; i < allProperties.size(); ++i) {
            Property p = (Property)allProperties.get(i);
            if (!p.getName().equals(firstProperty.getName())) continue;
            ++numExpected2;
        }
        properties2 = node.getProperties(pattern2);
        NodeReadMethodsTest.assertEquals((String)(assertString2 + "number of properties found: "), (long)numExpected2, (long)this.getSize((RangeIterator)properties2));
        String pattern3 = firstProperty.getName() + "|" + firstProperty.getName();
        String assertString3 = "node.getProperties(\"" + pattern3 + "\"): ";
        PropertyIterator properties3 = node.getProperties(pattern3);
        while (properties3.hasNext()) {
            Property p = properties3.nextProperty();
            NodeReadMethodsTest.assertEquals((String)(assertString2 + "name comparison failed: "), (String)firstProperty.getName(), (String)p.getName());
        }
        int numExpected3 = 0;
        for (int i = 0; i < allProperties.size(); ++i) {
            Property p = (Property)allProperties.get(i);
            if (!p.getName().equals(firstProperty.getName())) continue;
            ++numExpected3;
        }
        properties3 = node.getProperties(pattern3);
        NodeReadMethodsTest.assertEquals((String)(assertString3 + "number of properties found: "), (long)numExpected3, (long)this.getSize((RangeIterator)properties3));
        if (firstProperty.getName().length() > 2) {
            String name = firstProperty.getName();
            String shortenName = name.substring(1, name.length() - 1);
            String pattern4 = "*" + shortenName + "*";
            String assertString4 = "node.getProperties(\"" + pattern4 + "\"): ";
            PropertyIterator properties4 = node.getProperties(pattern4);
            while (properties4.hasNext()) {
                Property p = properties4.nextProperty();
                NodeReadMethodsTest.assertTrue((String)(assertString4 + "name comparison failed: *" + shortenName + "* not found in " + p.getName()), (p.getName().indexOf(shortenName) != -1 ? 1 : 0) != 0);
            }
            int numExpected4 = 0;
            for (int i = 0; i < allProperties.size(); ++i) {
                Property p = (Property)allProperties.get(i);
                if (p.getName().indexOf(shortenName) == -1) continue;
                ++numExpected4;
            }
            properties4 = node.getProperties(pattern4);
            NodeReadMethodsTest.assertEquals((String)(assertString4 + "number of properties found: "), (long)numExpected4, (long)this.getSize((RangeIterator)properties4));
        }
    }

    public void testGetPrimaryItem() throws NotExecutableException, RepositoryException {
        Node node = this.locateNodeWithPrimaryItem(this.testRootNode);
        if (node == null) {
            throw new NotExecutableException("Workspace does not contain a node with primary item defined");
        }
        String primaryItemName = node.getPrimaryNodeType().getPrimaryItemName();
        Item primaryItem = node.getPrimaryItem();
        if (primaryItem.isNode()) {
            NodeReadMethodsTest.assertTrue((String)"Node returned by getPrimaryItem() is not the same as the one aquired by getNode(String)", (boolean)node.getNode(primaryItemName).isSame(primaryItem));
        } else {
            NodeReadMethodsTest.assertTrue((String)"Property returned by getPrimaryItem() is not the same as the one aquired by getProperty(String)", (boolean)node.getProperty(primaryItemName).isSame(primaryItem));
        }
    }

    public void testGetPrimaryItemItemNotFoundException() throws NotExecutableException, RepositoryException {
        Node node = this.locateNodeWithoutPrimaryItem(this.testRootNode);
        if (node == null) {
            throw new NotExecutableException("Workspace does not contain a node without primary item defined");
        }
        try {
            node.getPrimaryItem();
            NodeReadMethodsTest.fail((String)"getPrimaryItem() must throw a ItemNotFoundException if the primary node type does not define one");
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public void testGetIndex() throws RepositoryException {
        Node node = this.locateNodeWithSameNameSiblings(this.testRootNode);
        if (node == null) {
            NodeReadMethodsTest.assertEquals((String)"getIndex() of a node without same name siblings must return 1", (int)this.testRootNode.getIndex(), (int)1);
        } else {
            NodeIterator nodes = node.getParent().getNodes(node.getName());
            int i = 1;
            while (nodes.hasNext()) {
                NodeReadMethodsTest.assertEquals((String)"getIndex() must return the correct index", (int)nodes.nextNode().getIndex(), (int)i);
                ++i;
            }
        }
    }

    public void testGetReferences() throws NotExecutableException, RepositoryException {
        Node node = this.locateNodeWithReference(this.testRootNode);
        if (node == null) {
            throw new NotExecutableException("Workspace does not contain a node with a reference property set");
        }
        PropertyIterator properties = node.getProperties();
        while (properties.hasNext()) {
            Property p = properties.nextProperty();
            if (p.getType() != 9 || p.getDefinition().isMultiple()) continue;
            Node referencedNode = p.getNode();
            PropertyIterator refs = referencedNode.getReferences();
            boolean referenceFound = false;
            while (refs.hasNext()) {
                Property ref = refs.nextProperty();
                if (!ref.isSame((Item)p)) continue;
                referenceFound = true;
            }
            NodeReadMethodsTest.assertTrue((String)"Correct reference not found", (boolean)referenceFound);
        }
    }

    public void testGetUUID() throws NotExecutableException, RepositoryException {
        Node node = this.locateReferenceableNode(this.testRootNode);
        if (node == null) {
            throw new NotExecutableException("Workspace does not contain a referencable node");
        }
        try {
            NodeReadMethodsTest.assertEquals((String)"node.getUUID() does not match node.getProperty(\"jcr:uuid\").getString()", (String)node.getProperty(this.jcrUUID).getString(), (String)node.getUUID());
        }
        catch (PathNotFoundException e) {
            NodeReadMethodsTest.fail((String)("Property UUID expected for node of type \"" + this.mixReferenceable + "\""));
        }
    }

    public void testGetUUIDOfNonReferenceableNode() throws NotExecutableException, RepositoryException {
        Node node = this.locateNonReferenceableNode(this.testRootNode);
        if (node == null) {
            throw new NotExecutableException("Workspace does not contain a non referenceable node");
        }
        try {
            node.getUUID();
            NodeReadMethodsTest.fail((String)"UnsupportedRepositoryOperationException expected");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testHasNode() throws NotExecutableException, RepositoryException {
        Node node = this.testRootNode;
        NodeIterator nodes = node.getNodes();
        StringBuffer notExistingNodeName = new StringBuffer();
        while (nodes.hasNext()) {
            Node n = nodes.nextNode();
            NodeReadMethodsTest.assertTrue((String)"hasNode(String relPath) returns false although node at relPath is existing", (boolean)node.hasNode(n.getName()));
            notExistingNodeName.append(n.getName() + "X");
        }
        if (notExistingNodeName.toString().equals("")) {
            throw new NotExecutableException("Workspace does not have sufficient content for this test. Root node must have at least one child node.");
        }
        NodeReadMethodsTest.assertFalse((String)"hasNode(String relPath) returns true although node at relPath is not existing", (boolean)node.hasNode(notExistingNodeName.toString().replaceAll(":", "")));
    }

    public void testHasNodes() throws RepositoryException {
        Node node = this.testRootNode;
        NodeIterator nodes = node.getNodes();
        int i = 0;
        while (nodes.hasNext()) {
            nodes.nextNode();
            ++i;
        }
        if (i == 0) {
            NodeReadMethodsTest.assertFalse((String)"node.hasNodes() returns true although no sub nodes existing", (boolean)node.hasNodes());
        } else {
            NodeReadMethodsTest.assertTrue((String)"node.hasNodes() returns false althuogh sub nodes are existing", (boolean)node.hasNodes());
        }
    }

    public void testHasProperty() throws NotExecutableException, RepositoryException {
        Node node = this.testRootNode;
        PropertyIterator properties = node.getProperties();
        StringBuffer notExistingPropertyName = new StringBuffer();
        while (properties.hasNext()) {
            Property p = properties.nextProperty();
            NodeReadMethodsTest.assertTrue((String)"node.hasProperty(\"relPath\") returns false although property at relPath is existing", (boolean)node.hasProperty(p.getName()));
            notExistingPropertyName.append(p.getName() + "X");
        }
        if (notExistingPropertyName.toString().equals("")) {
            NodeReadMethodsTest.fail((String)"Root node must at least have one property: jcr:primaryType");
        }
        NodeReadMethodsTest.assertFalse((String)"node.hasProperty(\"relPath\") returns true although property at relPath is not existing", (boolean)node.hasProperty(notExistingPropertyName.toString().replaceAll(":", "")));
    }

    public void testHasProperties() throws RepositoryException {
        Node node = this.testRootNode;
        PropertyIterator properties = node.getProperties();
        int i = 0;
        while (properties.hasNext()) {
            Property p = properties.nextProperty();
            this.log.println(p.getName());
            ++i;
        }
        if (i == 0) {
            NodeReadMethodsTest.assertFalse((String)"Must return false when no properties exist", (boolean)node.hasProperties());
        } else {
            NodeReadMethodsTest.assertTrue((String)"Must return true when one or more properties exist", (boolean)node.hasProperties());
        }
    }

    private Node locateReferenceableNode(Node node) throws RepositoryException {
        if (node.isNodeType(this.mixReferenceable)) {
            return node;
        }
        NodeIterator nodes = node.getNodes();
        while (nodes.hasNext()) {
            Node returnedNode = this.locateReferenceableNode(nodes.nextNode());
            if (returnedNode == null) continue;
            return returnedNode;
        }
        return null;
    }

    private Node locateNonReferenceableNode(Node node) throws RepositoryException {
        if (!node.isNodeType(this.mixReferenceable)) {
            return node;
        }
        NodeIterator nodes = node.getNodes();
        while (nodes.hasNext()) {
            Node returnedNode = this.locateNonReferenceableNode(nodes.nextNode());
            if (returnedNode == null) continue;
            return returnedNode;
        }
        return null;
    }

    private Node locateNodeWithReference(Node node) throws RepositoryException {
        PropertyIterator properties = node.getProperties();
        while (properties.hasNext()) {
            Property p = properties.nextProperty();
            if (p.getType() != 9 || p.getDefinition().isMultiple()) continue;
            return node;
        }
        NodeIterator nodes = node.getNodes();
        while (nodes.hasNext()) {
            Node returnedNode = this.locateNodeWithReference(nodes.nextNode());
            if (returnedNode == null) continue;
            return returnedNode;
        }
        return null;
    }

    private Node locateNodeWithPrimaryItem(Node node) throws RepositoryException {
        if (node.getPrimaryNodeType().getPrimaryItemName() != null) {
            return node;
        }
        NodeIterator nodes = node.getNodes();
        while (nodes.hasNext()) {
            Node returnedNode = this.locateNodeWithPrimaryItem(nodes.nextNode());
            if (returnedNode == null) continue;
            return returnedNode;
        }
        return null;
    }

    private Node locateNodeWithoutPrimaryItem(Node node) throws RepositoryException {
        if (node.getPrimaryNodeType().getPrimaryItemName() == null) {
            return node;
        }
        NodeIterator nodes = node.getNodes();
        while (nodes.hasNext()) {
            Node n = this.locateNodeWithoutPrimaryItem(nodes.nextNode());
            if (n == null) continue;
            return n;
        }
        return null;
    }

    private Node locateNodeWithSameNameSiblings(Node node) throws RepositoryException {
        NodeIterator nodes = node.getNodes();
        while (nodes.hasNext()) {
            Node n = nodes.nextNode();
            NodeIterator nodes2 = node.getNodes(n.getName());
            int i = 0;
            while (nodes2.hasNext()) {
                nodes2.next();
                ++i;
            }
            if (i > 1) {
                return n;
            }
            Node returnedNode = this.locateNodeWithSameNameSiblings(n);
            if (returnedNode == null) continue;
            return returnedNode;
        }
        return null;
    }
}

