/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class NodeTest
extends AbstractJCRTest {
    private Session superuserW2;

    public void setUp() throws Exception {
        super.setUp();
        this.superuserW2 = helper.getSuperuserSession(this.workspaceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() throws Exception {
        try {
            this.cleanUpTestRoot(this.superuserW2);
        }
        catch (RepositoryException e) {
            this.log.println("Exception in tearDown: " + e.toString());
        }
        finally {
            this.superuserW2.logout();
            this.superuserW2 = null;
        }
        super.tearDown();
    }

    public void testGetCorrespondingNodePathNoSuchWorkspaceException() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node defaultTestNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        try {
            defaultTestNode.getCorrespondingNodePath(this.getNonExistingWorkspaceName(this.superuser));
            NodeTest.fail((String)"Calling Node.getCorrespondingNodePath(workspace) with invalid workspace should throw NoSuchWorkspaceException");
        }
        catch (NoSuchWorkspaceException noSuchWorkspaceException) {
            // empty catch block
        }
    }

    public void testGetCorrespondingNodePathItemNotFoundException() throws RepositoryException, NotExecutableException {
        super.ensureMultipleWorkspacesSupported();
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node defaultTestNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        try {
            defaultTestNode.getCorrespondingNodePath(this.workspaceName);
            NodeTest.fail((String)"Calling Node.getCorrespondingNodePath() on node that has no correspondend node should throw ItemNotFoundException");
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public void testGetCorrespondingNodePath() throws RepositoryException, NotExecutableException {
        super.ensureMultipleWorkspacesSupported();
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node defaultTestNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        Node rootNodeW2 = (Node)this.superuserW2.getItem(this.testRootNode.getPath());
        rootNodeW2.addNode(this.nodeName1, this.testNodeType);
        this.superuserW2.save();
        defaultTestNode.getCorrespondingNodePath(this.workspaceName);
    }

    public void testUpdateInvalidItemStateException() throws RepositoryException, NotExecutableException {
        super.ensureMultipleWorkspacesSupported();
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node testNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        Node rootNodeW2 = (Node)this.superuserW2.getItem(this.testRootNode.getPath());
        rootNodeW2.addNode(this.nodeName1);
        this.superuserW2.save();
        testNode.setProperty(this.propertyName1, "test");
        try {
            testNode.update(this.workspaceName);
            NodeTest.fail((String)"Calling Node.update() on modified node should throw InvalidItemStateException");
        }
        catch (InvalidItemStateException e) {
            // empty catch block
        }
    }

    public void testUpdateNoSuchWorkspaceException() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node testNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        try {
            testNode.update(this.getNonExistingWorkspaceName(this.superuser));
            NodeTest.fail((String)"Calling Node.update() on a non existing workspace should throw NoSuchWorkspaceException");
        }
        catch (NoSuchWorkspaceException noSuchWorkspaceException) {
            // empty catch block
        }
    }

    public void testUpdateNoClone() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node testNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        testNode.setProperty(this.propertyName1, "test");
        this.superuser.save();
        testNode.update(this.workspaceName);
        NodeTest.assertTrue((String)"Node got property removed after Node.update() eventhough node has no clone", (boolean)testNode.hasProperty(this.propertyName1));
        NodeTest.assertFalse((String)"Node has children assigned after Node.update() eventhough node has no clone", (boolean)testNode.hasNodes());
    }

    public void testUpdate() throws RepositoryException, NotExecutableException {
        super.ensureMultipleWorkspacesSupported();
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node defaultTestNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        defaultTestNode.setProperty(this.propertyName1, "test");
        this.superuser.save();
        Node rootNodeW2 = (Node)this.superuserW2.getItem(this.testRootNode.getPath());
        Node testNodeW2 = rootNodeW2.addNode(this.nodeName1, this.testNodeType);
        testNodeW2.addNode(this.nodeName2, this.testNodeType);
        this.superuserW2.save();
        defaultTestNode.update(this.workspaceName);
        NodeTest.assertFalse((String)"Node updated with Node.update() should have property removed", (boolean)defaultTestNode.hasProperty(this.propertyName1));
        NodeTest.assertTrue((String)"Node updated with Node.update() should have received childrens", (boolean)defaultTestNode.hasNode(this.nodeName2));
    }

    public void testAddNodeConstraintViolationExceptionUndefinedNodeType() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        String nodetype = this.testNodeTypeNoChildren == null ? this.ntBase : this.testNodeTypeNoChildren;
        Node defaultTestNode = defaultRootNode.addNode(this.nodeName1, nodetype);
        try {
            defaultTestNode.addNode(this.nodeName2);
            NodeTest.fail((String)"Adding a node with node.addNode(node) where nodetype can not be determined from parent should throw ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
    }

    public void testAddNodeConstraintViolationExceptionProperty() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node defaultTestNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        defaultTestNode.setProperty(this.propertyName1, "test");
        try {
            defaultTestNode.addNode(this.propertyName1 + "/" + this.nodeName2);
            NodeTest.fail((String)"Adding a node as a child of a property should throw ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testAddNodeItemExistsException() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node defaultTestNode = defaultRootNode.addNode(this.nodeName2, this.testNodeType);
        defaultTestNode.addNode(this.nodeName3, this.testNodeType);
        defaultRootNode.save();
        try {
            defaultTestNode.addNode(this.nodeName3, this.testNodeType);
            defaultRootNode.save();
            NodeTest.fail((String)"Adding a node to a location where same name siblings are not allowed, but a node with same name already exists should throw ItemExistsException ");
        }
        catch (ItemExistsException itemExistsException) {
            // empty catch block
        }
    }

    public void testAddNodePathNotFoundException() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        try {
            defaultRootNode.addNode(this.nodeName1 + "/" + this.nodeName2);
            NodeTest.fail((String)"Creating a node at a non existent destination should throw PathNotFoundException");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testAddNodeRepositoryExceptionRelPathIndex() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        try {
            defaultRootNode.addNode(this.nodeName1 + "[1]", this.testNodeType);
            NodeTest.fail((String)"Creating a node with index as postfix for new name should throw RepositoryException");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testAddNodeRepositoryExceptionSaveOnNewNode() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node testNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        try {
            testNode.save();
            NodeTest.fail((String)"Calling Node.save() on a newly created node should throw RepositoryException");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddNodeParentSave() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node testNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        defaultRootNode.save();
        Session session = helper.getReadOnlySession();
        try {
            testNode = (Node)session.getItem(testNode.getPath());
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddNodeSessionSave() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node testNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        Session session = helper.getReadOnlySession();
        try {
            testNode = (Node)session.getItem(testNode.getPath());
        }
        finally {
            session.logout();
        }
    }

    public void testRemoveMandatoryNode() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node defaultTestNode = defaultRootNode.addNode(this.nodeName2, this.getProperty("nodetype2"));
        Node defaultTestNodeChild = defaultTestNode.addNode(this.nodeName3, this.getProperty("nodetype3"));
        defaultRootNode.save();
        try {
            defaultTestNodeChild.remove();
            defaultTestNode.save();
            NodeTest.fail((String)"Removing a mandatory node should throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveInvalidItemStateException() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node defaultTestNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        Session testSession = helper.getReadWriteSession();
        try {
            Node defaultTestNodeSession2 = (Node)testSession.getItem(defaultTestNode.getPath());
            defaultTestNode.remove();
            this.superuser.save();
            try {
                defaultTestNodeSession2.remove();
                testSession.save();
                NodeTest.fail((String)"Removing a node already deleted by other session should throw an InvalidItemStateException!");
            }
            catch (InvalidItemStateException e) {
                // empty catch block
            }
        }
        finally {
            testSession.logout();
        }
    }

    public void testRemoveNodeParentSave() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node defaultTestNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        defaultRootNode.save();
        defaultTestNode.remove();
        defaultRootNode.save();
        try {
            defaultRootNode.getNode(this.nodeName1);
            NodeTest.fail((String)"Permanently removed node should no longer be adressable using Parent Node's getNode() method");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveNodeSessionSave() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node defaultTestNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        defaultTestNode.remove();
        this.superuser.save();
        try {
            this.superuser.getItem(defaultRootNode.getPath() + "/" + this.nodeName1);
            NodeTest.fail((String)"Permanently removed node should no longer be adressable using Session.getItem()");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveNodeLockedItself() throws LockException, NotExecutableException, RepositoryException {
        Session session = this.testRootNode.getSession();
        if (!this.isSupported("option.locking.supported")) {
            throw new NotExecutableException("Locking is not supported.");
        }
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        if (!node.isNodeType(this.mixLockable)) {
            if (node.canAddMixin(this.mixLockable)) {
                node.addMixin(this.mixLockable);
            } else {
                throw new NotExecutableException("Node " + this.nodeName1 + " is not lockable and does not " + "allow to add mix:lockable");
            }
        }
        this.testRootNode.save();
        String pathRelToRoot = node.getPath().substring(1);
        Session session2 = helper.getSuperuserSession();
        try {
            Node node2 = session2.getRootNode().getNode(pathRelToRoot);
            node2.lock(true, true);
            node.remove();
        }
        finally {
            session2.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveNodeParentLocked() throws LockException, NotExecutableException, RepositoryException {
        Session session = this.testRootNode.getSession();
        if (!this.isSupported("option.locking.supported")) {
            throw new NotExecutableException("Locking is not supported.");
        }
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        if (!node.isNodeType(this.mixLockable)) {
            if (node.canAddMixin(this.mixLockable)) {
                node.addMixin(this.mixLockable);
            } else {
                throw new NotExecutableException("Node " + this.nodeName1 + " is not lockable and does not " + "allow to add mix:lockable");
            }
        }
        Node subNode = node.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.save();
        String pathRelToRoot = node.getPath().substring(1);
        Session session2 = helper.getSuperuserSession();
        try {
            Node node2 = session2.getRootNode().getNode(pathRelToRoot);
            node2.lock(true, true);
            try {
                subNode.remove();
                session.save();
                NodeTest.fail((String)"Removal of a Node must throw a LockException upon remove() or upon save() if the parent of the node is locked");
            }
            catch (LockException e) {
                // empty catch block
            }
            node2.unlock();
        }
        finally {
            session2.logout();
        }
    }

    public void testNodeIdentity() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node testNode1 = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        testNode1.addNode(this.nodeName1, this.testNodeType);
        testNode1.setProperty(this.propertyName1, "test");
        defaultRootNode.save();
        Node testNode2 = (Node)this.superuser.getItem(testNode1.getPath());
        NodeTest.assertTrue((String)"Two references of same node have different properties", (boolean)testNode1.getProperty(this.propertyName1).isSame((Item)testNode2.getProperty(this.propertyName1)));
        NodeTest.assertTrue((String)"Two references of same node have different children", (boolean)testNode1.getNode(this.nodeName1).isSame((Item)testNode2.getNode(this.nodeName1)));
        NodeTest.assertEquals((String)"Two references of same node have different State for Node.isCheckedOut()", (boolean)testNode1.isCheckedOut(), (boolean)testNode2.isCheckedOut());
        NodeTest.assertEquals((String)"Two references of same node have different State for Node.isLocked()", (boolean)testNode1.isLocked(), (boolean)testNode2.isLocked());
        NodeTest.assertEquals((String)"Two references of same node have different State for Node.isModified()", (boolean)testNode1.isModified(), (boolean)testNode2.isModified());
        NodeTest.assertEquals((String)"Two references of same node have different State for Node.isNew()", (boolean)testNode1.isNew(), (boolean)testNode2.isNew());
        NodeTest.assertEquals((String)"Two references of same node have different State for Node.isNode()", (boolean)testNode1.isNode(), (boolean)testNode2.isNode());
        NodeTest.assertEquals((String)"Two references of same node have different State for Node.isNodeType()", (boolean)testNode1.isNodeType(this.testNodeType), (boolean)testNode2.isNodeType(this.testNodeType));
        NodeTest.assertTrue((String)"Two references of same node should return true for Node1.isSame(Node2)", (boolean)testNode1.isSame((Item)testNode2));
        NodeTest.assertEquals((String)"Two references of same node have different Definitions", (String)testNode1.getDefinition().getName(), (String)testNode2.getDefinition().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsSameMustNotCompareStates() throws RepositoryException {
        Node testNode1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.save();
        Session session = helper.getReadOnlySession();
        try {
            Node testNode2 = (Node)session.getItem(testNode1.getPath());
            testNode1.setProperty(this.propertyName1, "value1");
            NodeTest.assertTrue((String)"Two references of same node should return true for Node1.isSame(Node2)", (boolean)testNode1.isSame((Item)testNode2));
        }
        finally {
            session.logout();
        }
    }

    public void testIsModified() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node testNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        defaultRootNode.save();
        NodeTest.assertFalse((String)"Unmodified node should return false on Node.isModified()", (boolean)testNode.isModified());
        testNode.setProperty(this.propertyName1, "test");
        NodeTest.assertTrue((String)"Modified node should return true on Node.isModified()", (boolean)testNode.isModified());
        defaultRootNode.save();
        testNode.addNode(this.nodeName2, this.testNodeType);
        NodeTest.assertTrue((String)"Modified node should return true on Node.isModified()", (boolean)testNode.isModified());
    }

    public void testIsNew() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node testNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        NodeTest.assertTrue((String)"Newly created node should return true on newNode.isNew()", (boolean)testNode.isNew());
        defaultRootNode.save();
        NodeTest.assertFalse((String)"Unmodified, exisiting node should return false on newNode.isNew()", (boolean)testNode.isNew());
    }

    public void testRefreshInvalidItemStateException() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node testNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        defaultRootNode.save();
        defaultRootNode.remove();
        try {
            testNode.refresh(true);
            NodeTest.fail((String)"Calling Node.refresh() on deleted node should throw InvalidItemStateException!");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRefreshBooleanFalse() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node testNode1Session1 = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        Node testNode2Session1 = defaultRootNode.addNode(this.nodeName2, this.testNodeType);
        defaultRootNode.save();
        testNode1Session1.addNode(this.nodeName2, this.testNodeType);
        Session session2 = helper.getReadWriteSession();
        try {
            Node testNode2Session2 = (Node)session2.getItem(testNode2Session1.getPath());
            testNode2Session2.addNode(this.nodeName3, this.testNodeType);
            session2.save();
            defaultRootNode.refresh(false);
            NodeTest.assertFalse((String)"Session should have no pending changes recorded after Node.refresh(false)!", (boolean)this.superuser.hasPendingChanges());
            NodeTest.assertFalse((String)"Node Modifications have not been flushed after Node.refresh(false)", (boolean)testNode1Session1.hasNodes());
            NodeTest.assertTrue((String)"Node modified by a different session has not been updated after Node.refresh(false)", (boolean)testNode2Session1.hasNodes());
        }
        finally {
            session2.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRefreshBooleanTrue() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node testNode1Session1 = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        Node testNode2Session1 = defaultRootNode.addNode(this.nodeName2, this.testNodeType);
        defaultRootNode.save();
        testNode1Session1.addNode(this.nodeName2, this.testNodeType);
        Session session2 = helper.getReadWriteSession();
        try {
            Node testNode2Session2 = (Node)session2.getItem(testNode2Session1.getPath());
            testNode2Session2.addNode(this.nodeName3, this.testNodeType);
            session2.save();
            defaultRootNode.refresh(true);
            NodeTest.assertTrue((String)"Session should still have pending changes recorded after Node.refresh(true)!", (boolean)this.superuser.hasPendingChanges());
            NodeTest.assertTrue((String)"Node Modifications are lost after Node.refresh(true)", (boolean)testNode1Session1.hasNodes());
            NodeTest.assertTrue((String)"Node modified by a different session has not been updated after Node.refresh(true)", (boolean)testNode2Session1.hasNodes());
        }
        finally {
            session2.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaveInvalidStateException() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node nodeSession1 = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        nodeSession1.addNode(this.nodeName2, this.testNodeType);
        Session testSession = helper.getReadWriteSession();
        try {
            Node nodeSession2 = (Node)testSession.getItem(nodeSession1.getPath());
            nodeSession2.remove();
            testSession.save();
            try {
                defaultRootNode.save();
                NodeTest.fail((String)"Saving a modified Node using Node.save() already deleted by an other session should throw InvalidItemStateException");
            }
            catch (InvalidItemStateException e) {
                // empty catch block
            }
        }
        finally {
            testSession.logout();
        }
    }

    public void testSaveContstraintViolationException() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        defaultRootNode.addNode(this.nodeName1, this.getProperty("nodetype2"));
        try {
            this.superuser.save();
            NodeTest.fail((String)"Trying to use parent Node.save() with a node that has a mandatory property not set, should throw ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodeSave() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node testNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        defaultRootNode.save();
        Session testSession = helper.getReadOnlySession();
        try {
            testSession.getItem(testNode.getPath());
        }
        finally {
            testSession.logout();
        }
    }

    public void testSaveOnNewNodeRepositoryException() throws Exception {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node newNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        try {
            newNode.save();
            NodeTest.fail((String)"Calling Node.save() on a newly added node should throw a RepositoryException");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testPrimaryType() throws Exception {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node testNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        NodeTest.assertEquals((String)"The primary node type is not properly stored in jcr:primaryType", (String)this.testNodeType, (String)testNode.getProperty(this.jcrPrimaryType).getString());
    }

    public void testPrimaryTypeProtected() throws Exception {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node testNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        try {
            testNode.setProperty(this.jcrPrimaryType, this.ntBase);
            NodeTest.fail((String)"Manually setting jcr:primaryType should throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testMixinTypesProtected() throws Exception {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node testNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        Value mixinName = this.superuser.getValueFactory().createValue(this.mixLockable, 7);
        try {
            testNode.setProperty(this.jcrMixinTypes, new Value[]{mixinName});
            NodeTest.fail((String)"Manually setting jcr:mixinTypes should throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException success) {
            // empty catch block
        }
    }
}

