/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.test.api.AbstractPropertyTest;
import org.apache.jackrabbit.test.api.PropertyUtil;

public class PathPropertyTest
extends AbstractPropertyTest {
    protected int getPropertyType() {
        return 8;
    }

    protected Boolean getPropertyIsMultivalued() {
        return null;
    }

    public void testGetString() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        PathPropertyTest.assertTrue((String)("Not a valid Path property: " + this.prop.getName()), (boolean)PropertyUtil.checkPathFormat(val.getString(), this.session));
    }

    public void testGetBoolean() throws RepositoryException {
        try {
            Value val = PropertyUtil.getValue(this.prop);
            val.getBoolean();
            PathPropertyTest.fail((String)"Conversion from a Path value to a Boolean value should throw a ValueFormatException.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetDate() throws RepositoryException {
        try {
            Value val = PropertyUtil.getValue(this.prop);
            val.getDate();
            PathPropertyTest.fail((String)"Conversion from a Path value to a Date value should throw a ValueFormatException.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetDouble() throws RepositoryException {
        try {
            Value val = PropertyUtil.getValue(this.prop);
            val.getDouble();
            PathPropertyTest.fail((String)"Conversion from a Path value to a Double value should throw a ValueFormatException.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetLong() throws RepositoryException {
        try {
            Value val = PropertyUtil.getValue(this.prop);
            val.getLong();
            PathPropertyTest.fail((String)"Conversion from a Path value to a Long value should throw a ValueFormatException.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetType() throws RepositoryException {
        PathPropertyTest.assertTrue((String)"Value.getType() returns wrong type.", (boolean)PropertyUtil.checkGetType(this.prop, 8));
    }

    public void testAsReference() throws RepositoryException {
        if (!this.multiple) {
            try {
                this.prop.getNode();
                PathPropertyTest.fail((String)"Conversion from a Path value to a Reference value should throw a ValueFormatException.");
            }
            catch (ValueFormatException vfe) {}
        } else {
            try {
                this.prop.getNode();
                PathPropertyTest.fail((String)"Property.getNode() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }
}

