/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.util.Calendar;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.ISO8601;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.nodetype.NodeTypeUtil;

public class SetPropertyAssumeTypeTest
extends AbstractJCRTest {
    private Node testNode;
    private String testPropName;
    private Value binaryValue;
    private Value booleanValue;
    private Value dateValue;
    private Value doubleValue;
    private Value longValue;
    private Value nameValue;
    private Value pathValue;
    private Value stringValue;
    private Value[] binaryValues;
    private Value[] booleanValues;
    private Value[] dateValues;
    private Value[] doubleValues;
    private Value[] longValues;
    private Value[] nameValues;
    private Value[] pathValues;
    private Value[] stringValues;

    public void setUp() throws Exception {
        super.setUp();
        this.testNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.binaryValue = NodeTypeUtil.getValueOfType(this.superuser, 2);
        this.booleanValue = NodeTypeUtil.getValueOfType(this.superuser, 6);
        this.dateValue = NodeTypeUtil.getValueOfType(this.superuser, 5);
        this.doubleValue = NodeTypeUtil.getValueOfType(this.superuser, 4);
        this.longValue = NodeTypeUtil.getValueOfType(this.superuser, 3);
        this.nameValue = NodeTypeUtil.getValueOfType(this.superuser, 7);
        this.pathValue = NodeTypeUtil.getValueOfType(this.superuser, 8);
        this.stringValue = NodeTypeUtil.getValueOfType(this.superuser, 1);
        this.binaryValues = new Value[]{this.binaryValue};
        this.booleanValues = new Value[]{this.booleanValue};
        this.dateValues = new Value[]{this.dateValue};
        this.doubleValues = new Value[]{this.doubleValue};
        this.longValues = new Value[]{this.longValue};
        this.nameValues = new Value[]{this.nameValue};
        this.pathValues = new Value[]{this.pathValue};
        this.stringValues = new Value[]{this.stringValue};
    }

    protected void tearDown() throws Exception {
        this.testNode = null;
        this.testPropName = null;
        this.binaryValue = null;
        this.booleanValue = null;
        this.dateValue = null;
        this.doubleValue = null;
        this.longValue = null;
        this.nameValue = null;
        this.pathValue = null;
        this.stringValue = null;
        this.binaryValues = null;
        this.booleanValues = null;
        this.dateValues = null;
        this.doubleValues = null;
        this.longValues = null;
        this.nameValues = null;
        this.pathValues = null;
        this.stringValues = null;
        super.tearDown();
    }

    public void testValue() throws NotExecutableException, RepositoryException {
        this.setUpNodeWithUndefinedProperty(false);
        Value stringValueForBinary = NodeTypeUtil.getValueOfType(this.superuser, 1);
        Property prop = this.testNode.setProperty(this.testPropName, stringValueForBinary, 2);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)2, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.stringValue, 6);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)6, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.doubleValue, 5);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)5, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.dateValue, 4);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)4, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.dateValue, 3);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)3, (int)prop.getType());
        Value valueConvertibleToName = this.superuser.getValueFactory().createValue(this.nameValue.getString(), 8);
        prop = this.testNode.setProperty(this.testPropName, valueConvertibleToName, 7);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)7, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.nameValue, 8);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)8, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.dateValue, 1);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)1, (int)prop.getType());
    }

    public void testValues() throws NotExecutableException, RepositoryException {
        this.setUpNodeWithUndefinedProperty(true);
        Value[] stringValuesForBinary = new Value[]{NodeTypeUtil.getValueOfType(this.superuser, 1)};
        Property prop = this.testNode.setProperty(this.testPropName, stringValuesForBinary, 2);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)2, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.stringValues, 6);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)6, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.doubleValues, 5);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)5, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.dateValues, 4);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)4, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.dateValues, 3);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)3, (int)prop.getType());
        Value[] valuesConvertibleToName = new Value[]{this.superuser.getValueFactory().createValue(this.nameValue.getString(), 8)};
        prop = this.testNode.setProperty(this.testPropName, valuesConvertibleToName, 7);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)7, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.nameValues, 8);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)8, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.dateValues, 1);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)1, (int)prop.getType());
    }

    public void testString() throws NotExecutableException, RepositoryException {
        this.setUpNodeWithUndefinedProperty(false);
        Property prop = this.testNode.setProperty(this.testPropName, this.binaryValue.getString(), 2);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)2, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.booleanValue.getString(), 6);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)6, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.dateValue.getString(), 5);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)5, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.doubleValue.getString(), 4);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)4, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.longValue.getString(), 3);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)3, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.nameValue.getString(), 7);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)7, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.pathValue.getString(), 8);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)8, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.stringValue.getString(), 1);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value, int) of a property of type undefined must assume the property type of the type parameter.", (int)1, (int)prop.getType());
    }

    public void testValueAssumeTypeOfValue() throws NotExecutableException, RepositoryException {
        this.setUpNodeWithUndefinedProperty(false);
        Property prop = this.testNode.setProperty(this.testPropName, this.binaryValue);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value) of a property of type undefined must assume the property type of the supplied value object.", (int)2, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.booleanValue);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value) of a property of type undefined must assume the property type of the supplied value object.", (int)6, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.dateValue);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value) of a property of type undefined must assume the property type of the supplied value object.", (int)5, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.doubleValue);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value) of a property of type undefined must assume the property type of the supplied value object.", (int)4, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.longValue);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value) of a property of type undefined must assume the property type of the supplied value object.", (int)3, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.nameValue);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value) of a property of type undefined must assume the property type of the supplied value object.", (int)7, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.pathValue);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value) of a property of type undefined must assume the property type of the supplied value object.", (int)8, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.stringValue);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value) of a property of type undefined must assume the property type of the supplied value object.", (int)1, (int)prop.getType());
    }

    public void testNodeAssumeTypeOfValue() throws NotExecutableException, RepositoryException {
        this.setUpNodeWithUndefinedProperty(false);
        Node referenceableNode = this.testRootNode.addNode(this.nodeName2);
        referenceableNode.addMixin(this.mixReferenceable);
        this.testRootNode.save();
        Property prop = this.testNode.setProperty(this.testPropName, referenceableNode);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value) of a property of type undefined must assume the property type of the supplied value object.", (int)9, (int)prop.getType());
    }

    public void testValuesAssumeTypeOfValue() throws NotExecutableException, RepositoryException {
        this.setUpNodeWithUndefinedProperty(true);
        Property prop = this.testNode.setProperty(this.testPropName, this.binaryValues);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value) of a property of type undefined must assume the property type of the supplied value object.", (int)2, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.booleanValues);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value) of a property of type undefined must assume the property type of the supplied value object.", (int)6, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.dateValues);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value) of a property of type undefined must assume the property type of the supplied value object.", (int)5, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.doubleValues);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value) of a property of type undefined must assume the property type of the supplied value object.", (int)4, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.longValues);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value) of a property of type undefined must assume the property type of the supplied value object.", (int)3, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.nameValues);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value) of a property of type undefined must assume the property type of the supplied value object.", (int)7, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.pathValues);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value) of a property of type undefined must assume the property type of the supplied value object.", (int)8, (int)prop.getType());
        prop = this.testNode.setProperty(this.testPropName, this.stringValues);
        SetPropertyAssumeTypeTest.assertEquals((String)"setProperty(String, Value) of a property of type undefined must assume the property type of the supplied value object.", (int)1, (int)prop.getType());
    }

    public void testValueConstraintViolationExceptionBecauseOfInvalidTypeParameter() throws NotExecutableException, RepositoryException {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date(0L));
            Value v = this.superuser.getValueFactory().createValue(ISO8601.format(cal));
            this.testNode.setProperty(this.propertyName1, v, 5);
            this.testRootNode.save();
            SetPropertyAssumeTypeTest.fail((String)"Node.setProperty(String, Value, int) must throw a ConstraintViolationExcpetion if the type parameter and the type of the property do not match.");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testStringConstraintViolationExceptionBecauseOfInvalidTypeParameter() throws NotExecutableException, RepositoryException {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date(0L));
            this.testNode.setProperty(this.propertyName1, ISO8601.format(cal), 5);
            this.testRootNode.save();
            SetPropertyAssumeTypeTest.fail((String)"Node.setProperty(String, Value, int) must throw a ConstraintViolationExcpetion if the type parameter and the type of the property do not match.");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testValuesConstraintViolationExceptionBecauseOfInvalidTypeParameter() throws NotExecutableException, RepositoryException {
        try {
            this.testNode.setProperty(this.propertyName1, this.stringValues, 5);
            this.testRootNode.save();
            SetPropertyAssumeTypeTest.fail((String)"Node.setProperty(String, Value, int) must throw a ConstraintViolationExcpetion or a ValueFormatException if the type parameter and the type of the property do not match.");
        }
        catch (ConstraintViolationException e) {
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    private void setUpNodeWithUndefinedProperty(boolean multiple) throws NotExecutableException {
        try {
            PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.superuser, 0, multiple, false, false, false);
            if (propDef == null) {
                throw new NotExecutableException("No testable property of type UNDEFINED has been found.");
            }
            String nodeType = propDef.getDeclaringNodeType().getName();
            this.testNode = this.testRootNode.addNode(this.nodeName1, nodeType);
            this.testPropName = propDef.getName();
        }
        catch (RepositoryException e) {
            throw new NotExecutableException("Not able to set up test items.");
        }
    }
}

