/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class SetValueBinaryTest
extends AbstractJCRTest {
    private Value value;
    private byte[] data;
    private Node node;
    private Property property1;

    protected void setUp() throws Exception {
        super.setUp();
        this.data = this.createRandomString(10).getBytes();
        this.value = this.superuser.getValueFactory().createValue((InputStream)new ByteArrayInputStream(this.data));
        this.node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.save();
        if (this.propertyName1.equals("jcr:data") && this.node.hasNode("jcr:content") && this.node.getNode("jcr:content").isNodeType("nt:resource") && !this.node.hasProperty("jcr:data")) {
            this.node = this.node.getNode("jcr:content");
        }
        this.property1 = this.node.setProperty(this.propertyName1, this.superuser.getValueFactory().createValue((InputStream)new ByteArrayInputStream(new byte[0])));
        this.superuser.save();
    }

    protected void tearDown() throws Exception {
        this.value = null;
        this.node = null;
        this.property1 = null;
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBinarySession() throws RepositoryException, IOException {
        this.property1.setValue(this.value);
        this.superuser.save();
        InputStream in = this.property1.getValue().getStream();
        try {
            this.compareStream(this.data, in);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            in.close();
            throw throwable;
        }
        in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBinaryParent() throws RepositoryException, IOException {
        InputStream in = this.value.getStream();
        try {
            this.property1.setValue(in);
            this.node.save();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            in.close();
            throw throwable;
        }
        in.close();
        in = this.property1.getValue().getStream();
        try {
            this.compareStream(this.data, in);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            in.close();
            throw throwable;
        }
        in.close();
    }

    public void testRemoveBinarySession() throws RepositoryException, NotExecutableException {
        if (this.property1.getDefinition().isMandatory() || this.property1.getDefinition().isProtected()) {
            throw new NotExecutableException("property " + this.property1.getName() + " can not be removed");
        }
        this.property1.setValue((InputStream)null);
        this.superuser.save();
        try {
            this.node.getProperty(this.propertyName1);
            SetValueBinaryTest.fail((String)"The property should not exist anymore, as a null Value has been assigned");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testRemoveBinaryParent() throws RepositoryException, NotExecutableException {
        if (this.property1.getDefinition().isMandatory() || this.property1.getDefinition().isProtected()) {
            throw new NotExecutableException("property " + this.property1.getName() + " can not be removed");
        }
        this.property1.setValue((Value)null);
        this.node.save();
        try {
            this.node.getProperty(this.propertyName1);
            SetValueBinaryTest.fail((String)"The property should not exist anymore, as a null Value has been assigned");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void compareStream(byte[] data, InputStream s) throws IOException {
        byte[] read = new byte[1];
        for (int i = 0; i < data.length; ++i) {
            SetValueBinaryTest.assertEquals((String)"Stream data does not match value set.", (int)1, (int)s.read(read));
            SetValueBinaryTest.assertEquals((String)"Stream data does not match value set.", (byte)data[i], (byte)read[0]);
        }
        if (s.available() > 0) {
            SetValueBinaryTest.fail((String)"InputStream has more data than value set.");
        }
    }
}

