/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import junit.framework.Assert;
import org.apache.jackrabbit.test.api.Base64;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class SysViewContentHandler
extends DefaultHandler {
    protected Session session;
    protected String path;
    boolean skipBinary;
    boolean noRecurse;
    NodeElemData currentNodeElem;
    NodeElemData parentNodeElem;
    PropElemData currentPropElem;
    protected StringBuffer currentValue;
    protected ArrayList currentValues;
    protected HashMap prefixes;
    protected boolean testRootDone;
    Stack nodeElemStack;
    private String jcrRoot;
    private String jcrPrimaryType;
    private String jcrMixinTypes;
    private String jcrUuid;
    private String svNode;
    private String svProperty;
    private String svName;
    private String svType;
    private String svValue;
    private String mixReferenceable;

    public SysViewContentHandler(String path, Session session, boolean skipBinary, boolean noRecurse) throws RepositoryException {
        this.session = session;
        this.path = path;
        this.skipBinary = skipBinary;
        this.noRecurse = noRecurse;
        this.jcrRoot = session.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":root";
        this.jcrPrimaryType = session.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":primaryType";
        this.jcrMixinTypes = session.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":mixinTypes";
        this.jcrUuid = session.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":uuid";
        this.svNode = session.getNamespacePrefix("http://www.jcp.org/jcr/sv/1.0") + ":node";
        this.svProperty = session.getNamespacePrefix("http://www.jcp.org/jcr/sv/1.0") + ":property";
        this.svName = session.getNamespacePrefix("http://www.jcp.org/jcr/sv/1.0") + ":name";
        this.svType = session.getNamespacePrefix("http://www.jcp.org/jcr/sv/1.0") + ":type";
        this.svValue = session.getNamespacePrefix("http://www.jcp.org/jcr/sv/1.0") + ":value";
        this.mixReferenceable = session.getNamespacePrefix("http://www.jcp.org/jcr/mix/1.0") + ":referenceable";
    }

    public void startDocument() throws SAXException {
        try {
            Item item = this.session.getItem(this.path);
            this.checkCondition("TestPath " + this.path + " is not a path to a node.", item.isNode());
            this.nodeElemStack = new Stack();
            this.currentNodeElem = new NodeElemData();
            this.currentNodeElem.name = item.getName();
            this.currentNodeElem.node = (Node)item;
            this.currentNodeElem.path = this.path;
            this.prefixes = new HashMap();
            this.testRootDone = false;
        }
        catch (PathNotFoundException pe) {
            this.checkCondition("TestPath " + this.path + " is not a valid path." + pe.toString(), false);
        }
        catch (RepositoryException re) {
            this.checkCondition("Could not determine test node: " + re.toString(), false);
        }
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.prefixes.put(prefix, uri);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if (qName.equals(this.svNode)) {
                String nodeName = attributes.getValue(this.svName);
                if (this.noRecurse) {
                    if (!this.testRootDone) {
                        this.nodeElemStack.push(this.currentNodeElem);
                        this.testRootDone = true;
                        if (this.currentNodeElem.node.getDepth() == 0) {
                            this.checkCondition("Exported Root node has not the required element name 'jcr:root'.", nodeName.equals(this.jcrRoot));
                        }
                    } else {
                        this.checkCondition("Child Node Element of testRoot Node element found although noRecursive is true.", !this.testRootDone);
                    }
                } else if (!this.testRootDone) {
                    this.nodeElemStack.push(this.currentNodeElem);
                    this.testRootDone = true;
                    if (this.currentNodeElem.node.getDepth() == 0) {
                        this.checkCondition("Exported Root node has not the required element name 'jcr:root'.", nodeName.equals(this.jcrRoot));
                    }
                } else {
                    this.parentNodeElem = (NodeElemData)this.nodeElemStack.pop();
                    NodeIterator nodeIter = this.parentNodeElem.node.getNodes(nodeName);
                    this.currentNodeElem = new NodeElemData();
                    this.currentNodeElem.name = nodeName;
                    long size = this.getSize((RangeIterator)nodeIter);
                    if (size >= 1L) {
                        if (this.parentNodeElem.childNodeElemNames.containsKey(nodeName)) {
                            ChildNodeElem child = (ChildNodeElem)this.parentNodeElem.childNodeElemNames.get(nodeName);
                            ++child.number;
                            this.currentNodeElem.index = child.number;
                            String relPath = this.currentNodeElem.name + "[" + child.number + "]";
                            this.currentNodeElem.node = this.parentNodeElem.node.getNode(relPath);
                            this.currentNodeElem.path = this.currentNodeElem.node.getPath();
                            this.parentNodeElem.childNodeElemNames.put(nodeName, child);
                        } else {
                            ChildNodeElem child = new ChildNodeElem();
                            child.name = nodeName;
                            this.currentNodeElem.index = child.number = 1L;
                            String relPath = this.currentNodeElem.name + "[" + child.number + "]";
                            this.currentNodeElem.node = this.parentNodeElem.node.getNode(relPath);
                            this.currentNodeElem.path = this.currentNodeElem.node.getPath();
                            this.parentNodeElem.childNodeElemNames.put(nodeName, child);
                        }
                    } else {
                        this.checkCondition("No child node of node " + this.parentNodeElem.path + " found with name:  " + nodeName, false);
                    }
                    this.nodeElemStack.push(this.parentNodeElem);
                    this.nodeElemStack.push(this.currentNodeElem);
                }
            } else if (qName.equals(this.svProperty)) {
                this.currentPropElem = new PropElemData();
                this.currentPropElem.name = attributes.getValue(this.svName);
                this.currentPropElem.typeName = attributes.getValue(this.svType);
                this.currentPropElem.type = PropertyType.valueFromName((String)this.currentPropElem.typeName);
                this.currentPropElem.values = new ArrayList();
            } else if (qName.equals(this.svValue)) {
                this.currentValue = new StringBuffer();
            } else {
                this.checkCondition("Invalid element name " + qName + " in SysView export found", false);
            }
        }
        catch (PathNotFoundException pne) {
            this.checkCondition("Item not found during exportSysViewTest: " + pne.toString(), false);
        }
        catch (RepositoryException re) {
            // empty catch block
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentValue != null) {
            this.currentValue.append(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (qName.equals(this.svValue)) {
                if (this.currentValue != null) {
                    String val = this.currentValue.toString();
                    if (this.currentPropElem.type != 2 || this.currentPropElem.type == 2 && !this.skipBinary) {
                        this.currentPropElem.values.add(val);
                    }
                }
            } else if (qName.equals(this.svProperty)) {
                this.currentNodeElem = (NodeElemData)this.nodeElemStack.pop();
                this.currentNodeElem.propElems.add(this.currentPropElem);
                this.nodeElemStack.push(this.currentNodeElem);
            } else if (qName.equals(this.svNode)) {
                this.currentNodeElem = (NodeElemData)this.nodeElemStack.peek();
                if (this.currentNodeElem.node == null) {
                    this.checkCondition("Tree structure of exported node does not match the tree structure of the repository.", false);
                } else {
                    this.checkPropOrder(this.currentNodeElem);
                    this.checkChildren(this.currentNodeElem, this.noRecurse);
                    try {
                        this.checkAllProps(this.currentNodeElem, this.skipBinary);
                        this.nodeElemStack.pop();
                    }
                    catch (IOException ioe) {
                        this.checkCondition("Error in Base64 encoding of a binary property value: " + ioe.toString(), false);
                    }
                }
            } else {
                this.checkCondition("Invalid element name " + qName + " in SysView export found", false);
            }
        }
        catch (PathNotFoundException pne) {
            this.checkCondition("Item not found during exportSysViewTest: " + pne.toString(), false);
        }
        catch (RepositoryException re) {
            // empty catch block
        }
    }

    public void endDocument() throws SAXException {
        try {
            HashMap<String, String> sessionNamespaces = new HashMap<String, String>();
            String[] sessionPrefixes = this.session.getNamespacePrefixes();
            for (int i = 0; i < sessionPrefixes.length; ++i) {
                sessionNamespaces.put(sessionPrefixes[i], this.session.getNamespaceURI(sessionPrefixes[i]));
            }
            Iterator it = this.prefixes.keySet().iterator();
            while (it.hasNext()) {
                String prefix = (String)it.next();
                if ("xml".equals(prefix)) {
                    Assert.fail((String)"Prefix mapping for 'xml' must not be exported.");
                }
                String uri = (String)this.prefixes.get(prefix);
                this.checkCondition("Exported uri " + uri + " is not a registered namespace.", sessionNamespaces.containsValue(uri));
                this.checkCondition("Exported prefix " + prefix + " does not match " + "current namespacce mapping in Session", sessionNamespaces.containsKey(prefix));
            }
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
    }

    private void checkCondition(String str, boolean bool) {
        Assert.assertTrue((String)str, (boolean)bool);
    }

    private void checkPropOrder(NodeElemData nodeElem) throws RepositoryException, SAXException {
        boolean jcrPrimaryTypeFound = false;
        boolean jcrMixinTypesFound = true;
        boolean uuidFound = true;
        PropElemData propElem = (PropElemData)nodeElem.propElems.get(0);
        jcrPrimaryTypeFound = this.jcrPrimaryType.equals(propElem.name);
        this.checkCondition("Exported property jcr:primaryType of node " + nodeElem.path + " is not at the first position.", jcrPrimaryTypeFound);
        if (nodeElem.node.hasProperty(this.jcrMixinTypes)) {
            PropElemData propElem2 = (PropElemData)nodeElem.propElems.get(1);
            jcrMixinTypesFound = this.jcrMixinTypes.equals(propElem2.name);
            this.checkCondition("Exported property jcr:jcrMixinTypes of node " + nodeElem.path + " is not at the second position.", jcrMixinTypesFound);
            NodeType[] mixins = nodeElem.node.getMixinNodeTypes();
            for (int j = 0; j < mixins.length; ++j) {
                if (!mixins[j].getName().equals(this.mixReferenceable)) continue;
                uuidFound = this.jcrUuid.equals(((PropElemData)nodeElem.propElems.get((int)2)).name);
                this.checkCondition("Exported property jcr:uuid of node " + nodeElem.path + " is not at the third position.", uuidFound);
            }
        }
    }

    private void checkAllProps(NodeElemData nodeElem, boolean skipBinary) throws RepositoryException, SAXException, IOException {
        boolean allFound = false;
        boolean correctVal = false;
        Node node = nodeElem.node;
        ArrayList propElems = nodeElem.propElems;
        if (propElems.size() == 0) {
            if (node.hasProperties()) {
                if (skipBinary) {
                    PropertyIterator iter = node.getProperties();
                    while (iter.hasNext()) {
                        Property prop = iter.nextProperty();
                        this.checkCondition("Property " + prop.getName() + " of node " + node.getPath() + " is not exported.", prop.getType() == 2);
                    }
                } else {
                    this.checkCondition("One or more properties of node " + node.getPath() + " are not exported.", false);
                }
            }
        } else {
            for (int i = 0; i < propElems.size(); ++i) {
                correctVal = false;
                PropElemData propElem = (PropElemData)propElems.get(i);
                int propType = propElem.type;
                if (node.hasProperty(propElem.name)) {
                    Property prop = node.getProperty(propElem.name);
                    correctVal = propType == prop.getType();
                    this.checkCondition("Property type of property " + propElem.name + " of node " + nodeElem.path + " is not exported correctly." + "expected: " + prop.getType() + " received: " + propType, correctVal);
                    if (propType == 2 && !skipBinary || propType != 2) {
                        try {
                            int size = propElem.values.size();
                            if (size == 0) {
                                if (prop.getDefinition().isMultiple()) {
                                    long length = prop.getValues().length;
                                    this.checkCondition("Value of property " + prop.getPath() + " is not exported.", length == 0L);
                                } else {
                                    this.checkCondition("Singler value property " + prop.getPath() + " with no value is exported.", false);
                                }
                            }
                            if (size == 1) {
                                String str = "";
                                str = prop.getDefinition().isMultiple() ? prop.getValues()[0].getString() : prop.getString();
                                String val = (String)propElem.values.get(0);
                                if (prop.getType() == 2) {
                                    val = this.decodeBase64(val);
                                }
                                correctVal = str.equals(val);
                                this.checkCondition("Property value of property " + propElem.name + " of node " + nodeElem.path + " is not exported correctly:" + " expected value: " + str + " found value: " + val, correctVal);
                                continue;
                            }
                            Value[] vals = prop.getValues();
                            this.checkCondition("Number of exported values of property " + prop.getPath() + " does not match the number " + "its values", vals.length == size);
                            for (int j = 0; j < size; ++j) {
                                String val = (String)propElem.values.get(j);
                                if (prop.getType() == 2) {
                                    val = this.decodeBase64(val);
                                }
                                String str = vals[j].getString();
                                correctVal = val.equals(str);
                                this.checkCondition("Property value of property " + propElem.name + " of node " + nodeElem.path + " is not exported correctly.", correctVal);
                            }
                            continue;
                        }
                        catch (ValueFormatException vfe) {
                            this.checkCondition("Error during retreiviing the value(s) of property " + prop.getPath() + vfe.toString() + " .", false);
                            continue;
                        }
                    }
                    this.checkCondition("Value of binary property " + prop.getPath() + " exported although skipBinary flag is true.", propElem.values.isEmpty());
                    continue;
                }
                this.checkCondition("Property element " + propElem.name + " found but node " + nodeElem.node.getPath() + " does not have a property with that name", false);
            }
            long otherSize = this.getSize((RangeIterator)node.getProperties());
            allFound = (long)propElems.size() == otherSize;
            this.checkCondition("Not all properties of node " + nodeElem.path + " are exported.", allFound);
        }
    }

    private void checkChildren(NodeElemData nodeElem, boolean noRecurse) throws RepositoryException, SAXException {
        Hashtable childElemsFound = nodeElem.childNodeElemNames;
        boolean totalSumOk = false;
        boolean partialSumOk = true;
        if (noRecurse) {
            totalSumOk = childElemsFound.size() == 0;
        } else {
            long childrenFound = 0L;
            NodeIterator nodeIter = nodeElem.node.getNodes();
            long children = this.getSize((RangeIterator)nodeIter);
            Enumeration e = childElemsFound.elements();
            while (e.hasMoreElements()) {
                ChildNodeElem child = (ChildNodeElem)e.nextElement();
                String name = child.name;
                long number = child.number;
                NodeIterator iter = nodeElem.node.getNodes(name);
                long size = 0L;
                size = this.getSize((RangeIterator)iter);
                if (size != number) {
                    partialSumOk = false;
                    break;
                }
                childrenFound += number;
            }
            totalSumOk = children == childrenFound;
            this.checkCondition("The number of child nodes of node" + nodeElem.path + " which are exported does not match the number of its child nodes.", totalSumOk && partialSumOk);
        }
    }

    private String decodeBase64(String str) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Base64.decode(str, (OutputStream)bos);
        String decoded = bos.toString("UTF-8");
        return decoded;
    }

    private long getSize(RangeIterator it) {
        long size = it.getSize();
        if (size != -1L) {
            return size;
        }
        size = 0L;
        while (it.hasNext()) {
            it.next();
            ++size;
        }
        return size;
    }

    private class ChildNodeElem {
        String name;
        long number;

        private ChildNodeElem() {
        }
    }

    private class PropElemData {
        String name;
        String typeName;
        int type;
        ArrayList values;

        private PropElemData() {
        }
    }

    private class NodeElemData {
        String name;
        long index;
        String path;
        ArrayList propElems = new ArrayList();
        Node node;
        int position = 0;
        Hashtable childNodeElemNames = new Hashtable();

        private NodeElemData() {
        }
    }

    public class ConditionException
    extends SAXException {
        public ConditionException(String message) {
            super(message);
        }
    }
}

