/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.nodetype;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Comparator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class PredefinedNodeTypeTest
extends AbstractJCRTest {
    private NodeTypeManager manager;
    private Session session;
    private static final Comparator NODE_DEF_COMPARATOR = new Comparator(){

        public int compare(Object a, Object b) {
            NodeDefinition nda = (NodeDefinition)a;
            NodeDefinition ndb = (NodeDefinition)b;
            if (nda.getName().equals("*") && !ndb.getName().equals("*")) {
                return 1;
            }
            if (!nda.getName().equals("*") && ndb.getName().equals("*")) {
                return -1;
            }
            return nda.getName().compareTo(ndb.getName());
        }
    };
    private static final Comparator PROPERTY_DEF_COMPARATOR = new Comparator(){

        public int compare(Object a, Object b) {
            PropertyDefinition pda = (PropertyDefinition)a;
            PropertyDefinition pdb = (PropertyDefinition)b;
            if (pda.getName().equals("*") && !pdb.getName().equals("*")) {
                return 1;
            }
            if (!pda.getName().equals("*") && pdb.getName().equals("*")) {
                return -1;
            }
            int result = pda.getName().compareTo(pdb.getName());
            if (result != 0) {
                return result;
            }
            if (pda.isMultiple() && !pdb.isMultiple()) {
                return 1;
            }
            if (!pda.isMultiple() && pdb.isMultiple()) {
                return -1;
            }
            return 0;
        }
    };
    private static final Comparator NODE_TYPE_COMPARATOR = new Comparator(){

        public int compare(Object a, Object b) {
            NodeType nta = (NodeType)a;
            NodeType ntb = (NodeType)b;
            if (nta.isMixin() && !ntb.isMixin()) {
                return 1;
            }
            if (!nta.isMixin() && ntb.isMixin()) {
                return -1;
            }
            return nta.getName().compareTo(ntb.getName());
        }
    };

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = helper.getReadOnlySession();
        this.manager = this.session.getWorkspace().getNodeTypeManager();
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        this.manager = null;
        super.tearDown();
    }

    public void testIfPrimaryNodeTypesAreSubtypesOfNTBase() throws RepositoryException {
        NodeTypeIterator types = this.manager.getPrimaryNodeTypes();
        while (types.hasNext()) {
            NodeType type = types.nextNodeType();
            PredefinedNodeTypeTest.assertTrue((String)("Primary node type " + type.getName() + " must inherit nt:base"), (boolean)type.isNodeType("nt:base"));
        }
    }

    public void testLockable() throws NotExecutableException {
        this.testPredefinedNodeType("mix:lockable");
    }

    public void testReferenceable() throws NotExecutableException {
        this.testPredefinedNodeType("mix:referenceable");
    }

    public void testVersionable() throws NotExecutableException {
        this.testPredefinedNodeType("mix:versionable");
    }

    public void testBase() throws NotExecutableException {
        this.testPredefinedNodeType("nt:base");
    }

    public void testUnstructured() throws NotExecutableException {
        this.testPredefinedNodeType("nt:unstructured");
    }

    public void testHierarchyNode() throws NotExecutableException {
        this.testPredefinedNodeType("nt:hierarchyNode");
    }

    public void testFile() throws NotExecutableException {
        this.testPredefinedNodeType("nt:file");
    }

    public void testLinkedFile() throws NotExecutableException {
        this.testPredefinedNodeType("nt:linkedFile");
    }

    public void testFolder() throws NotExecutableException {
        this.testPredefinedNodeType("nt:folder");
    }

    public void testNodeType() throws NotExecutableException {
        this.testPredefinedNodeType("nt:nodeType");
    }

    public void testPropertyDef() throws NotExecutableException {
        this.testPredefinedNodeType("nt:propertyDefinition");
    }

    public void testChildNodeDef() throws NotExecutableException {
        this.testPredefinedNodeType("nt:childNodeDefinition");
    }

    public void testVersionHistory() throws NotExecutableException {
        this.testPredefinedNodeType("nt:versionHistory");
    }

    public void testVersionLabels() throws NotExecutableException {
        this.testPredefinedNodeType("nt:versionLabels");
    }

    public void testVersion() throws NotExecutableException {
        this.testPredefinedNodeType("nt:version");
    }

    public void testFrozenNode() throws NotExecutableException {
        this.testPredefinedNodeType("nt:frozenNode");
    }

    public void testVersionedChild() throws NotExecutableException {
        this.testPredefinedNodeType("nt:versionedChild");
    }

    public void testQuery() throws NotExecutableException {
        this.testPredefinedNodeType("nt:query");
    }

    public void testResource() throws NotExecutableException {
        this.testPredefinedNodeType("nt:resource");
    }

    private void testPredefinedNodeType(String name) throws NotExecutableException {
        try {
            StringBuffer spec = new StringBuffer();
            String resource = "org/apache/jackrabbit/test/api/nodetype/spec/" + name.replace(':', '-') + ".txt";
            InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resource));
            int ch = ((Reader)reader).read();
            while (ch != -1) {
                spec.append((char)ch);
                ch = ((Reader)reader).read();
            }
            NodeType type = this.manager.getNodeType(name);
            String current = PredefinedNodeTypeTest.getNodeTypeSpec(type);
            if (!System.getProperty("line.separator").equals("\n")) {
                current = this.normalizeLineSeparators(current);
            }
            String expected = this.normalizeLineSeparators(spec.toString());
            PredefinedNodeTypeTest.assertEquals((String)("Predefined node type " + name), (String)expected, (String)current);
        }
        catch (IOException e) {
            PredefinedNodeTypeTest.fail((String)e.getMessage());
        }
        catch (NoSuchNodeTypeException e) {
            if ("nt:base".equals(name)) {
                PredefinedNodeTypeTest.fail((String)e.getMessage());
            }
            throw new NotExecutableException("NodeType " + name + " not supported by this repository implementation.");
        }
        catch (RepositoryException e) {
            PredefinedNodeTypeTest.fail((String)e.getMessage());
        }
    }

    private static String getNodeTypeSpec(NodeType type) throws RepositoryException {
        String typeName = type.getName();
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        writer.println("NodeTypeName");
        writer.println("  " + typeName);
        writer.println("Supertypes");
        NodeType[] supertypes = type.getDeclaredSupertypes();
        Arrays.sort(supertypes, NODE_TYPE_COMPARATOR);
        boolean hasPrinted = false;
        for (int i = 0; i < supertypes.length; ++i) {
            String name = supertypes[i].getName();
            if (!name.startsWith("nt:") && (!name.equals("mix:referenceable") || !typeName.equals("mix:versionable") && !typeName.equals("nt:resource") && !typeName.equals("nt:versionHistory") && !typeName.equals("nt:version") && !typeName.equals("nt:frozenNode"))) continue;
            writer.println("  " + supertypes[i].getName());
            hasPrinted = true;
        }
        if (!hasPrinted) {
            writer.println("  []");
        }
        writer.println("IsMixin");
        writer.println("  " + type.isMixin());
        writer.println("HasOrderableChildNodes");
        writer.println("  " + type.hasOrderableChildNodes());
        writer.println("PrimaryItemName");
        writer.println("  " + type.getPrimaryItemName());
        NodeDefinition[] nodes = type.getDeclaredChildNodeDefinitions();
        Arrays.sort(nodes, NODE_DEF_COMPARATOR);
        for (int i = 0; i < nodes.length; ++i) {
            writer.print(PredefinedNodeTypeTest.getChildNodeDefSpec(nodes[i]));
        }
        PropertyDefinition[] properties = type.getDeclaredPropertyDefinitions();
        Arrays.sort(properties, PROPERTY_DEF_COMPARATOR);
        for (int i = 0; i < properties.length; ++i) {
            writer.print(PredefinedNodeTypeTest.getPropertyDefSpec(properties[i]));
        }
        return buffer.toString();
    }

    private static String getChildNodeDefSpec(NodeDefinition node) {
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        writer.println("ChildNodeDefinition");
        if (node.getName().equals("*")) {
            writer.println("  Name \"*\"");
        } else {
            writer.println("  Name " + node.getName());
        }
        writer.print("  RequiredPrimaryTypes [");
        NodeType[] types = node.getRequiredPrimaryTypes();
        Arrays.sort(types, NODE_TYPE_COMPARATOR);
        for (int j = 0; j < types.length; ++j) {
            if (j > 0) {
                writer.print(',');
            }
            writer.print(types[j].getName());
        }
        writer.println("]");
        if (node.getDefaultPrimaryType() != null) {
            writer.println("  DefaultPrimaryType " + node.getDefaultPrimaryType().getName());
        } else {
            writer.println("  DefaultPrimaryType null");
        }
        writer.println("  AutoCreated " + node.isAutoCreated());
        writer.println("  Mandatory " + node.isMandatory());
        writer.println("  OnParentVersion " + OnParentVersionAction.nameFromValue((int)node.getOnParentVersion()));
        writer.println("  Protected " + node.isProtected());
        writer.println("  SameNameSiblings " + node.allowsSameNameSiblings());
        return buffer.toString();
    }

    private static String getPropertyDefSpec(PropertyDefinition property) throws RepositoryException {
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        writer.println("PropertyDefinition");
        if (property.getName().equals("*")) {
            writer.println("  Name \"*\"");
        } else {
            writer.println("  Name " + property.getName());
        }
        String type = PropertyType.nameFromValue((int)property.getRequiredType());
        writer.println("  RequiredType " + type.toUpperCase());
        Value[] values = property.getDefaultValues();
        if (values != null && values.length > 0) {
            writer.print("  DefaultValues [");
            for (int j = 0; j < values.length; ++j) {
                if (j > 0) {
                    writer.print(',');
                }
                writer.print(values[j].getString());
            }
            writer.println("]");
        } else {
            writer.println("  DefaultValues null");
        }
        writer.println("  AutoCreated " + property.isAutoCreated());
        writer.println("  Mandatory " + property.isMandatory());
        String action = OnParentVersionAction.nameFromValue((int)property.getOnParentVersion());
        writer.println("  OnParentVersion " + action);
        writer.println("  Protected " + property.isProtected());
        writer.println("  Multiple " + property.isMultiple());
        return buffer.toString();
    }

    private String normalizeLineSeparators(String stringValue) {
        stringValue = stringValue.replaceAll("\r\n", "\n");
        stringValue = stringValue.replaceAll("\r", "\n");
        return stringValue;
    }
}

