/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.observation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public abstract class AbstractObservationTest
extends AbstractJCRTest {
    protected static final long DEFAULT_WAIT_TIMEOUT = 5000L;
    protected ObservationManager obsMgr;

    protected void setUp() throws Exception {
        super.setUp();
        try {
            this.obsMgr = this.superuser.getWorkspace().getObservationManager();
        }
        catch (UnsupportedRepositoryOperationException ex) {
            throw new NotExecutableException("observation not supported");
        }
    }

    protected void tearDown() throws Exception {
        this.obsMgr = null;
        super.tearDown();
    }

    protected void addEventListener(EventListener listener) throws RepositoryException {
        this.addEventListener(listener, 31);
    }

    protected void addEventListener(EventListener listener, int eventType) throws RepositoryException {
        if (this.obsMgr == null) {
            throw new IllegalStateException("ObservationManager not available.");
        }
        this.obsMgr.addEventListener(listener, eventType, this.superuser.getRootNode().getPath(), true, null, null, false);
    }

    protected void removeEventListener(EventListener listener) throws RepositoryException {
        if (this.obsMgr == null) {
            throw new IllegalStateException("ObservationManager not available.");
        }
        this.obsMgr.removeEventListener(listener);
    }

    protected EventListener[] toArray(EventListenerIterator it) {
        ArrayList<EventListener> listeners = new ArrayList<EventListener>();
        while (it.hasNext()) {
            listeners.add(it.nextEventListener());
        }
        return listeners.toArray(new EventListener[listeners.size()]);
    }

    protected void checkNodeAdded(Event[] events, String[] requiredRelPaths, String[] optionalRelPaths) throws RepositoryException {
        this.checkNodes(events, requiredRelPaths, optionalRelPaths, 1L);
    }

    protected void checkNodeRemoved(Event[] events, String[] requiredRelPaths, String[] optionalRelPaths) throws RepositoryException {
        this.checkNodes(events, requiredRelPaths, optionalRelPaths, 2L);
    }

    protected void checkPropertyAdded(Event[] events, String[] relPaths) throws RepositoryException {
        this.checkNodes(events, relPaths, null, 4L);
    }

    protected void checkPropertyChanged(Event[] events, String[] relPaths) throws RepositoryException {
        this.checkNodes(events, relPaths, null, 16L);
    }

    protected void checkPropertyRemoved(Event[] events, String[] relPaths) throws RepositoryException {
        this.checkNodes(events, relPaths, null, 8L);
    }

    private void checkNodes(Event[] events, String[] requiredRelPaths, String[] optionalRelPaths, long eventType) throws RepositoryException {
        int i;
        HashSet<String> paths = new HashSet<String>();
        for (i = 0; i < events.length; ++i) {
            AbstractObservationTest.assertEquals((String)"Wrong event type", (long)eventType, (long)events[i].getType());
            String path = events[i].getPath();
            paths.add(path);
        }
        for (i = 0; i < requiredRelPaths.length; ++i) {
            String expected = this.testRoot + "/" + requiredRelPaths[i];
            AbstractObservationTest.assertTrue((String)("Path " + expected + " not found in events."), (boolean)paths.contains(expected));
            paths.remove(expected);
        }
        HashSet<String> optional = new HashSet<String>();
        if (optionalRelPaths != null) {
            for (int i2 = 0; i2 < optionalRelPaths.length; ++i2) {
                optional.add(this.testRoot + "/" + optionalRelPaths[i2]);
            }
        }
        Iterator it = paths.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            AbstractObservationTest.assertTrue((String)("Path " + path + " not expected in events."), (boolean)optional.contains(path));
        }
    }
}

